/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.download;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.download.NodeJsDownloadableInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.Decompressor;
import com.intellij.util.system.CpuArch;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsDownloadService {
    private final ExecutorService myInstaller = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeJsInstaller", (int)1);

    public void ensureInstalled(Project project, NodeJsInterpreter node, Consumer<NodeJsInterpreter> runWhenInstalled) {
        if (node instanceof NodeJsDownloadableInterpreter) {
            this.myInstaller.execute(() -> NodeJsDownloadService.installWithProgress(project, (NodeJsDownloadableInterpreter)node, runWhenInstalled));
        } else {
            runWhenInstalled.accept(node);
        }
    }

    private static void installWithProgress(Project project, final NodeJsDownloadableInterpreter node, final Consumer<NodeJsInterpreter> runWhenInstalled) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaScriptBundle.message("node.js.downloading", node), true, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodeJsDownloadService.install(node, runWhenInstalled);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService$1", "run"));
            }
        });
    }

    public static void install(@NotNull NodeJsDownloadableInterpreter node, @Nullable Consumer<NodeJsInterpreter> runWhenInstalled) {
        if (node == null) {
            NodeJsDownloadService.$$$reportNull$$$0(0);
        }
        try {
            Logger.getInstance(NodeJsDownloadService.class).info("Installing Node.js " + node.getCachedVersion().get());
            String installDirectory = NodeJsDownloadService.getInstallDirectory(node);
            if (!FileUtil.exists((String)installDirectory)) {
                String filename = NodeJsDownloadService.constructFilename(node);
                String url = NodeJsDownloadService.constructUrl((SemVer)node.getCachedVersion().get(), filename);
                File tempFile = FileUtil.createTempFile((String)"", (String)"", (boolean)true);
                DownloadUtil.downloadAtomically((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (String)url, (File)tempFile);
                Decompressor.Zip decompressor = SystemInfo.isWindows ? new Decompressor.Zip(tempFile) : new Decompressor.Tar(tempFile);
                decompressor.extract(new File(NodeJsDownloadService.getInstallDirectory()));
            }
            NodeJsLocalInterpreter interpreter = new NodeJsLocalInterpreter(installDirectory + (!SystemInfo.isWindows ? "/bin" : "") + "/node" + (SystemInfo.isWindows ? ".exe" : ""));
            NodeJsLocalInterpreterType type = NodeJsLocalInterpreterType.getInstance();
            ArrayList<NodeJsLocalInterpreter> interpreters = new ArrayList<NodeJsLocalInterpreter>(type.getInterpreters());
            if (!interpreters.contains(interpreter)) {
                interpreters.add(interpreter);
                type.setInterpreters((List<NodeJsLocalInterpreter>)interpreters);
            }
            if (runWhenInstalled != null) {
                ApplicationManager.getApplication().invokeLater(() -> runWhenInstalled.accept(interpreter));
            }
        }
        catch (IOException e) {
            Logger.getInstance(NodeJsDownloadService.class).warn("Cannot install Node.js interpreter: " + e.getMessage());
        }
    }

    @NotNull
    private static String constructFilename(NodeJsDownloadableInterpreter node) {
        Ref<SemVer> ref = node.getCachedVersion();
        SemVer version = (SemVer)ref.get();
        String os = SystemInfo.isWindows ? "win" : (SystemInfo.isMac ? "darwin" : "linux");
        String arch = CpuArch.isIntel32() ? "x86" : "x64";
        String string = "node-v" + version + "-" + os + "-" + arch;
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getInstallDirectory(NodeJsDownloadableInterpreter node) {
        String string = NodeJsDownloadService.getInstallDirectory() + NodeJsDownloadService.constructFilename(node);
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String getInstallDirectory() {
        String string = PathManager.getConfigPath() + "/node/";
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String getNpmInstallDirectory(@Nullable NodeJsDownloadableInterpreter interpreter) {
        String string = NodeJsDownloadService.getInstallDirectory(interpreter) + (SystemInfo.isWindows ? "" : "/lib") + "/node_modules/npm/";
        if (string == null) {
            NodeJsDownloadService.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static String constructUrl(SemVer version, String filename) {
        String extension = SystemInfo.isWindows ? "zip" : "tar.gz";
        return "https://nodejs.org/dist/v" + version + "/" + filename + "." + extension;
    }

    public static NodeJsDownloadService getInstance() {
        return (NodeJsDownloadService)ApplicationManager.getApplication().getService(NodeJsDownloadService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/download/NodeJsDownloadService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "constructFilename";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpmInstallDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "install";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

