/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.target.WslTargetEnvironmentConfiguration;
import com.intellij.execution.wsl.target.WslTargetEnvironmentRequest;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreterType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PathUtil;
import com.intellij.util.text.SemVer;
import com.pty4j.PtyProcess;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WslNodeInterpreter
extends NodeJsInterpreter {
    @NlsSafe
    private final String myWslDistributionId;
    @NlsSafe
    private final String myWslInterpreterPath;
    private WSLDistribution myDistribution;

    public WslNodeInterpreter(@NotNull @NlsSafe String wslDistributionId, @NotNull @NlsSafe String wslInterpreterPath) {
        if (wslDistributionId == null) {
            WslNodeInterpreter.$$$reportNull$$$0(0);
        }
        if (wslInterpreterPath == null) {
            WslNodeInterpreter.$$$reportNull$$$0(1);
        }
        this.myWslDistributionId = wslDistributionId;
        this.myWslInterpreterPath = FileUtil.toSystemIndependentName((String)wslInterpreterPath);
    }

    @NotNull
    @NlsSafe
    public String getWslDistributionId() {
        String string = this.myWslDistributionId;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getWslInterpreterPath() {
        String string = this.myWslInterpreterPath;
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public WSLDistribution getDistribution() {
        WSLDistribution distribution = this.myDistribution;
        if (distribution == null) {
            this.myDistribution = distribution = WslDistributionManager.getInstance().getOrCreateDistributionByMsId(this.myWslDistributionId);
        }
        WSLDistribution wSLDistribution = distribution;
        if (wSLDistribution == null) {
            WslNodeInterpreter.$$$reportNull$$$0(4);
        }
        return wSLDistribution;
    }

    @Override
    @NotNull
    public NodeJsInterpreterType<? extends NodeJsInterpreter> getType() {
        WslNodeInterpreterType wslNodeInterpreterType = WslNodeInterpreterType.getInstance();
        if (wslNodeInterpreterType == null) {
            WslNodeInterpreter.$$$reportNull$$$0(5);
        }
        return wslNodeInterpreterType;
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String string = WslNodeInterpreterManager.getReferenceName(this);
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        WSLDistribution dist = this.getDistribution();
        String name = dist.getPresentableName();
        String string = name + " " + this.getWslInterpreterPath();
        if (string == null) {
            WslNodeInterpreter.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return WslNodeInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            WslNodeInterpreter.$$$reportNull$$$0(8);
        }
        WslNodeInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return null;
    }

    @Nullable
    public String getPrependNodeDirToPathCommand() {
        String defaultPath = "/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:/usr/games:/usr/local/games";
        String binDir = PathUtil.getParentPath((String)this.myWslInterpreterPath);
        if (StringUtil.split((String)defaultPath, (String)":").contains(binDir)) {
            return null;
        }
        return "export PATH=\"" + CommandLineUtil.posixQuote((String)binDir) + ":$PATH\"";
    }

    @Override
    @NotNull
    public NodeInterpreterTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRun.Options options) throws ExecutionException {
        if (project == null) {
            WslNodeInterpreter.$$$reportNull$$$0(9);
        }
        if (options == null) {
            WslNodeInterpreter.$$$reportNull$$$0(10);
        }
        final WslTargetEnvironmentRequest request = new WslTargetEnvironmentRequest(new WslTargetEnvironmentConfiguration(this.getDistribution()));
        request.setPtyOptions(options.getPtyOptions());
        return new NodeInterpreterTargetRunSetup((TargetEnvironmentRequest)request){

            @Override
            public void configureCommandLine(@NotNull TargetedCommandLineBuilder commandLineBuilder) {
                if (commandLineBuilder == null) {
                    1.$$$reportNull$$$0(0);
                }
                commandLineBuilder.setExePath(WslNodeInterpreter.this.myWslInterpreterPath);
                WSLCommandLineOptions wslOptions = request.getWslOptions();
                wslOptions.setPassEnvVarsUsingInterop(true);
                String prependNodeDirToPathCommand = WslNodeInterpreter.this.getPrependNodeDirToPathCommand();
                if (prependNodeDirToPathCommand != null) {
                    wslOptions.addInitCommand(prependNodeDirToPathCommand);
                }
            }

            @Override
            @NotNull
            public KillableProcessHandler createProcessHandler(@NotNull NodeTargetRun run, @NotNull Process process2, @NotNull TargetedCommandLine commandLine, @NotNull TargetEnvironment environment) {
                if (run == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (process2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (commandLine == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (environment == null) {
                    1.$$$reportNull$$$0(4);
                }
                KillableProcessHandler processHandler = super.createProcessHandler(run, process2, commandLine, environment);
                processHandler.setShouldKillProcessSoftlyWithWinP(process2 instanceof PtyProcess);
                KillableProcessHandler killableProcessHandler = processHandler;
                if (killableProcessHandler == null) {
                    1.$$$reportNull$$$0(5);
                }
                return killableProcessHandler;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commandLineBuilder";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "run";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "process";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "commandLine";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter$1";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createProcessHandler";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "configureCommandLine";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "createProcessHandler";
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WslNodeInterpreter that = (WslNodeInterpreter)o;
        return Objects.equals(this.myWslDistributionId, that.myWslDistributionId) && Objects.equals(this.myWslInterpreterPath, that.myWslInterpreterPath);
    }

    public int hashCode() {
        return Objects.hash(this.myWslDistributionId, this.myWslInterpreterPath);
    }

    public String toString() {
        return "wsl_id=" + this.myWslDistributionId + ", wsl_path=" + this.myWslInterpreterPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslDistributionId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wslInterpreterPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslDistributionId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslInterpreterPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDistribution";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

