/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpWorkspace;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.NavigatableWithText;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpSyntheticLibrary
extends SyntheticLibrary
implements ItemPresentation,
NavigatableWithText {
    private final YarnPnpFile myFile;
    private final YarnPnpWorkspace myWorkspace;
    private final String myLibraryName;
    private final List<VirtualFile> mySourceRoots;

    YarnPnpSyntheticLibrary(@NotNull YarnPnpFile file2, @NotNull YarnPnpWorkspace workspace, @NotNull String libraryName, @NotNull List<VirtualFile> sourceRoots) {
        if (file2 == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(0);
        }
        if (workspace == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(1);
        }
        if (libraryName == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(2);
        }
        if (sourceRoots == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(3);
        }
        this.myFile = file2;
        this.myWorkspace = workspace;
        this.myLibraryName = libraryName;
        this.mySourceRoots = ImmutableList.copyOf(sourceRoots);
    }

    @NotNull
    public YarnPnpFile getPnpFile() {
        YarnPnpFile yarnPnpFile = this.myFile;
        if (yarnPnpFile == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(4);
        }
        return yarnPnpFile;
    }

    @NotNull
    public String getLibraryName() {
        String string = this.myLibraryName;
        if (string == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public YarnPnpWorkspace getWorkspace() {
        YarnPnpWorkspace yarnPnpWorkspace = this.myWorkspace;
        if (yarnPnpWorkspace == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(6);
        }
        return yarnPnpWorkspace;
    }

    @NotNull
    public Collection<VirtualFile> getSourceRoots() {
        List<VirtualFile> list2 = this.mySourceRoots;
        if (list2 == null) {
            YarnPnpSyntheticLibrary.$$$reportNull$$$0(7);
        }
        return list2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        YarnPnpSyntheticLibrary other = (YarnPnpSyntheticLibrary)((Object)o);
        if (!this.myFile.getPnpFile().equals(other.myFile.getPnpFile())) {
            return false;
        }
        return this.mySourceRoots.equals(other.getSourceRoots());
    }

    public int hashCode() {
        return Objects.hash(this.myFile.getPnpFile(), this.mySourceRoots);
    }

    @Nullable
    public String getPresentableText() {
        return this.myLibraryName;
    }

    @Nullable
    public String getLocationString() {
        return "Yarn";
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return JavaScriptLanguageIcons.Nodejs.Yarn;
    }

    @Nullable
    public String getNavigateActionText(boolean focusEditor) {
        return JavaScriptBundle.message("intention.family.name.navigate.to.package.json", new Object[0]);
    }

    public void navigate(boolean requestFocus) {
        VirtualFile packageJson = this.myWorkspace.findPackageJson();
        if (packageJson != null) {
            new OpenFileDescriptor(this.myFile.getProject(), packageJson, -1).navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        return true;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRoots";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpSyntheticLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/YarnPnpSyntheticLibrary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPnpFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkspace";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

