/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonReader;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomNpmRegistryService {
    private static final Logger LOG = Logger.getInstance(CustomNpmRegistryService.class);
    private static final String SCOPED_REGISTRY_KEY_SUFFIX = ":registry";
    private static final String REGISTRY_KEY = "registry";
    private static final String PUBLIC_REGISTRY_URL = "https://registry.npmjs.org/";
    private static final int TIMEOUT = 10000;
    private final Project myProject;
    private long myLastExternalChangesCount;
    private NodeJsInterpreterRef myLastInterpreterRef;
    private NodePackageRef myLastNpmPackageRef;
    private final Map<VirtualFile, Registries> myCache;

    public CustomNpmRegistryService(@NotNull Project project) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(0);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, Registries>();
        this.myProject = project;
    }

    @NotNull
    public static CustomNpmRegistryService getInstance(@NotNull Project project) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(1);
        }
        CustomNpmRegistryService customNpmRegistryService = (CustomNpmRegistryService)project.getService(CustomNpmRegistryService.class);
        if (customNpmRegistryService == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(2);
        }
        return customNpmRegistryService;
    }

    @NotNull
    private static <T, E extends Exception> T executeWithoutReadAction(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(3);
        }
        if (computable == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            Object object;
            try {
                object = ApplicationUtil.runWithCheckCanceled(() -> computable.compute(), (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (object == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(5);
            }
            return (T)object;
        }
        Object object = computable.compute();
        if (object == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    @NotNull
    public List<NodePackageBasicInfo> findPackages(@Nullable ProgressIndicator indicator, @NotNull VirtualFile packageJson, @NotNull String packageNamePrefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(7);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(9);
        }
        return (List)CustomNpmRegistryService.executeWithoutReadAction(EmptyProgressIndicator.notNullize((ProgressIndicator)indicator), () -> this.doFindPackages(indicator, packageJson, packageNamePrefix, limit, filter));
    }

    @NotNull
    private List<NodePackageBasicInfo> doFindPackages(@Nullable ProgressIndicator indicator, @NotNull VirtualFile packageJson, @NotNull String packageNamePrefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        Registries registries;
        List<Registry> matchedRegistries;
        Registry registry;
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(10);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(12);
        }
        if ((registry = (Registry)ContainerUtil.getFirstItem(matchedRegistries = (registries = this.findRegistries(indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)indicator), packageJson)).findRegistriesWithScope(packageNamePrefix))) == null || registry.myRegistryUrl.equals(PUBLIC_REGISTRY_URL)) {
            List<NodePackageBasicInfo> list2 = List.of();
            if (list2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(13);
            }
            return list2;
        }
        long startNano = System.nanoTime();
        List<NodePackageBasicInfo> result2 = this.npmSearch(indicator, registry, packageJson, packageNamePrefix);
        LOG.info("npm search --registry=" + registry.myRegistryUrl + " '" + packageNamePrefix + "' " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson) + ": " + ContainerUtil.map(result2, info -> info.getName()));
        List<NodePackageBasicInfo> list3 = result2.stream().filter(info -> filter.value(info) && info.getName().startsWith(packageNamePrefix)).limit(limit).collect(Collectors.toList());
        if (list3 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(14);
        }
        return list3;
    }

    @NotNull
    private List<NodePackageBasicInfo> npmSearch(@NotNull ProgressIndicator indicator, final @NotNull Registry registry, @NotNull VirtualFile packageJson, final @NotNull String packageNamePrefix) {
        ProcessOutput output;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(15);
        }
        if (registry == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(16);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(17);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(18);
        }
        if ((output = this.run(indicator, packageJson, NodePackageRef.create("npm"), new CommandLineProducer(){

            @Override
            @NotNull
            public GeneralCommandLine produce(@NotNull Path workingDirectory, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (workingDirectory == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (interpreter == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (npmPkg == null) {
                    1.$$$reportNull$$$0(2);
                }
                GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(workingDirectory.toFile(), interpreter, npmPkg, NpmCommand.SEARCH, List.of("--json", "--registry=" + registry.myRegistryUrl, packageNamePrefix));
                if (generalCommandLine == null) {
                    1.$$$reportNull$$$0(3);
                }
                return generalCommandLine;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "workingDirectory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "npmPkg";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "produce";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "produce";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        })) != null) {
            List<NodePackageBasicInfo> result2 = CustomNpmRegistryService.parsePackageInfos(output.getStdout());
            if (result2 != null) {
                List<NodePackageBasicInfo> list2 = result2;
                if (list2 == null) {
                    CustomNpmRegistryService.$$$reportNull$$$0(19);
                }
                return list2;
            }
            LOG.info("Failed to parse packages from " + output.getStdout());
        }
        List<NodePackageBasicInfo> list3 = List.of();
        if (list3 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(20);
        }
        return list3;
    }

    @Nullable
    private static List<NodePackageBasicInfo> parsePackageInfos(@NotNull String stdout) {
        JsonArray array;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(21);
        }
        try {
            array = (JsonArray)ObjectUtils.tryCast((Object)JsonParser.parseString((String)stdout), JsonArray.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (array == null) {
            return null;
        }
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>();
        for (JsonElement element : array) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (obj == null) continue;
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description2 = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            if (name == null) continue;
            result2.add(new NodePackageBasicInfo(name, description2));
        }
        return array.size() > 0 && result2.isEmpty() ? null : result2;
    }

    @NotNull
    private Registries findRegistries(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson) {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(22);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(23);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Registries registries = Registries.EMPTY;
            if (registries == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(24);
            }
            return registries;
        }
        Registries registries = this.myCache.get(packageJson);
        if (registries != null && SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount() == this.myLastExternalChangesCount && NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef().equals(this.myLastInterpreterRef) && NpmManager.getInstance(this.myProject).getPackageRef().equals(this.myLastNpmPackageRef)) {
            Registries registries2 = registries;
            if (registries2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(25);
            }
            return registries2;
        }
        registries = this.doFindRegistries(indicator, packageJson);
        this.myCache.put(packageJson, registries);
        this.myLastExternalChangesCount = SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        this.myLastInterpreterRef = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
        this.myLastNpmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
        Registries registries3 = registries;
        if (registries3 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(26);
        }
        return registries3;
    }

    @NotNull
    private Registries doFindRegistries(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson) {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(27);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(28);
        }
        long startNano = System.nanoTime();
        NodePackageRef npmPkgRef = NpmManager.getInstance(this.myProject).getPackageRef();
        boolean isYarn = NpmUtil.isYarnAlikePackageRef(npmPkgRef);
        ProcessOutput output = this.run(indicator, packageJson, npmPkgRef, new CommandLineProducer(){

            @Override
            @NotNull
            public GeneralCommandLine produce(@NotNull Path workingDirectory, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (workingDirectory == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (interpreter == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (npmPkg == null) {
                    2.$$$reportNull$$$0(2);
                }
                GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(workingDirectory.toFile(), interpreter, npmPkg, NpmCommand.CONFIG, List.of("list", "--json"));
                if (generalCommandLine == null) {
                    2.$$$reportNull$$$0(3);
                }
                return generalCommandLine;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "workingDirectory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "npmPkg";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "produce";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "produce";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Registries result2 = Registries.EMPTY;
        if (output != null) {
            Registries registries = CustomNpmRegistryService.parseRegistries(output.getStdout(), isYarn);
            if (registries != null) {
                result2 = registries;
            } else {
                LOG.info("Failed to parse registries from " + output.getStdout());
            }
        }
        LOG.info("Found registries " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson) + ": " + result2);
        Registries registries = result2;
        if (registries == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(29);
        }
        return registries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String getContextDebugInfo(long startNano, @NotNull VirtualFile virtualFile) {
        void packageJson;
        VirtualFile vDir;
        if (virtualFile == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(30);
        }
        Object path2 = (vDir = packageJson.getParent()) != null ? vDir.getPath() : "";
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHome) && ((String)path2).startsWith(userHome + "/")) {
            path2 = "~" + ((String)path2).substring(userHome.length());
        }
        String string = "(" + TimeoutUtil.getDurationMillis((long)startNano) + " ms, " + (String)path2 + ")";
        if (string == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    private static Registries parseRegistries(@NotNull String stdout, boolean isNpm) {
        JsonObject rootObj;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(32);
        }
        try {
            rootObj = (JsonObject)ObjectUtils.tryCast((Object)JsonParser.parseString((String)stdout), JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (rootObj == null) {
            return null;
        }
        ArrayList<Registry> registries = new ArrayList<Registry>();
        Set entries = rootObj.entrySet();
        for (Map.Entry entry : entries) {
            String url;
            String key = (String)entry.getKey();
            if (!key.endsWith(SCOPED_REGISTRY_KEY_SUFFIX) && !key.equals(REGISTRY_KEY) || (url = JsonUtil.getString((JsonElement)((JsonElement)entry.getValue()))) == null) continue;
            String prefix = StringUtil.trimEnd((String)key, (String)SCOPED_REGISTRY_KEY_SUFFIX);
            registries.add(new Registry(key.equals(prefix) ? null : prefix, url));
        }
        return new Registries(registries);
    }

    @Nullable
    public AvailablePackageVersions getPackageVersion(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson, @NotNull String packageName) {
        Registries registries;
        Registry registry;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(33);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(34);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(35);
        }
        if ((registry = (Registry)ContainerUtil.getFirstItem((registries = this.findRegistries(indicator, packageJson)).findRegistriesWithScope(packageName))) == null || registry.myRegistryUrl.equals(PUBLIC_REGISTRY_URL)) {
            return null;
        }
        long startNano = System.nanoTime();
        AvailablePackageVersions versions = this.doNpmView(indicator, packageJson, registry, packageName);
        LOG.info("Found versions of " + packageName + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson) + ": " + versions.getVersions());
        return versions;
    }

    /*
     * Loose catch block
     */
    @NotNull
    private AvailablePackageVersions doNpmView(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson, final @NotNull Registry registry, final @NotNull String packageName) {
        ProcessOutput output;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(36);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(37);
        }
        if (registry == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(38);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(39);
        }
        if ((output = this.run(indicator, packageJson, NodePackageRef.create("npm"), new CommandLineProducer(){

            @Override
            @NotNull
            public GeneralCommandLine produce(@NotNull Path workingDirectory, @NotNull NodeJsInterpreter interpreter, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (workingDirectory == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (interpreter == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (npmPkg == null) {
                    3.$$$reportNull$$$0(2);
                }
                GeneralCommandLine generalCommandLine = NpmUtil.createNpmCommandLine(workingDirectory.toFile(), interpreter, npmPkg, NpmCommand.VIEW, List.of("--json", "--registry=" + registry.myRegistryUrl, packageName));
                if (generalCommandLine == null) {
                    3.$$$reportNull$$$0(3);
                }
                return generalCommandLine;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "workingDirectory";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreter";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "npmPkg";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$3";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "produce";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "produce";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        })) != null) {
            JsonReader reader = new JsonReader((Reader)new StringReader(output.getStdout()));
            AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.parseFromPackageMetadata(reader);
            reader.close();
            AvailablePackageVersions availablePackageVersions2 = availablePackageVersions;
            if (availablePackageVersions2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(40);
            }
            return availablePackageVersions2;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.info("Failed to parse versions: " + e.getMessage());
                    }
                }
            }
        }
        AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.createEmpty();
        if (availablePackageVersions == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(41);
        }
        return availablePackageVersions;
    }

    @Nullable
    private ProcessOutput run(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson, @NotNull NodePackageRef npmPkgRef, @NotNull CommandLineProducer commandLineProducer) {
        NodePackage npmPkg;
        VirtualFile dir;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(42);
        }
        if (packageJson == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(43);
        }
        if (npmPkgRef == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(44);
        }
        if (commandLineProducer == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(45);
        }
        if ((dir = packageJson.getParent()) == null) {
            LOG.info("No parent directory for " + packageJson);
            return null;
        }
        NodeJsInterpreter interpreter = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreter();
        if (interpreter == null) {
            LOG.info("Node.js interpreter unavailable");
            return null;
        }
        try {
            npmPkg = NpmManager.getInstance(this.myProject).getPackageOrThrow(npmPkgRef, interpreter);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot find npm package:" + e.getMessage());
            return null;
        }
        try {
            ProcessOutput output;
            GeneralCommandLine commandLine = commandLineProducer.produce(dir.toNioPath(), interpreter, npmPkg);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running " + commandLine.getCommandLineString());
            }
            if ((output = new CapturingProcessHandler(commandLine).runProcessWithProgressIndicator(indicator, 10000)).isCancelled() || output.isTimeout() || output.getExitCode() != 0) {
                LOG.info("Failed to run " + commandLine + ": " + output);
                return null;
            }
            return output;
        }
        catch (ExecutionException e) {
            LOG.info("Cannot find npm package: " + e.getMessage());
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 40: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 3: 
            case 15: 
            case 22: 
            case 27: 
            case 33: 
            case 36: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 10: 
            case 17: 
            case 23: 
            case 28: 
            case 30: 
            case 34: 
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 16: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGISTRY_KEY;
                break;
            }
            case 21: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 35: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgRef";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithoutReadAction";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindPackages";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "npmSearch";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findRegistries";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindRegistries";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDebugInfo";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "doNpmView";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 40: 
            case 41: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutReadAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFindPackages";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "npmSearch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageInfos";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findRegistries";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doFindRegistries";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getContextDebugInfo";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseRegistries";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersion";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "doNpmView";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 31: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Registry {
        @Nullable
        private final String myScope;
        @NotNull
        private final String myRegistryUrl;

        private Registry(@Nullable String scope, @NotNull String registryUrl) {
            if (registryUrl == null) {
                Registry.$$$reportNull$$$0(0);
            }
            this.myScope = scope;
            this.myRegistryUrl = registryUrl;
        }

        public String toString() {
            return "(" + this.myScope + ", " + this.myRegistryUrl + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registryUrl", "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registry", "<init>"));
        }
    }

    private static class Registries {
        private static final Registries EMPTY = new Registries(List.of());
        private final List<Registry> myRegistries;

        private Registries(@NotNull List<Registry> registries) {
            if (registries == null) {
                Registries.$$$reportNull$$$0(0);
            }
            this.myRegistries = List.copyOf(registries);
        }

        @NotNull
        public List<Registry> findRegistriesWithScope(@NotNull String packageNamePrefix) {
            if (packageNamePrefix == null) {
                Registries.$$$reportNull$$$0(1);
            }
            if (packageNamePrefix.startsWith("@")) {
                String typedScope = (String)ObjectUtils.notNull((Object)NodeModuleSearchUtil.getScopeByPackageName(packageNamePrefix), (Object)packageNamePrefix);
                List list2 = ContainerUtil.filter(this.myRegistries, registry -> {
                    String registryScope = registry.myScope;
                    return registryScope != null && registryScope.startsWith(typedScope);
                });
                if (list2 == null) {
                    Registries.$$$reportNull$$$0(2);
                }
                return list2;
            }
            List list3 = ContainerUtil.createMaybeSingletonList((Object)((Registry)ContainerUtil.find(this.myRegistries, registry -> registry.myScope == null)));
            if (list3 == null) {
                Registries.$$$reportNull$$$0(3);
            }
            return list3;
        }

        public String toString() {
            return this.myRegistries.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registries";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNamePrefix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findRegistriesWithScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "findRegistriesWithScope";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface CommandLineProducer {
        @NotNull
        public GeneralCommandLine produce(@NotNull Path var1, @NotNull NodeJsInterpreter var2, @NotNull NodePackage var3) throws ExecutionException;
    }
}

