/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.reference;

import com.intellij.javascript.JSFileReference;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class RequiredFileSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public RequiredFileSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        ResolvedModuleInfo info;
        VirtualFile dir;
        PsiElement element;
        if (queryParameters == null) {
            RequiredFileSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            RequiredFileSearcher.$$$reportNull$$$0(1);
        }
        if ((element = queryParameters.getElementToSearch()) instanceof PsiFile) {
            VirtualFile file2 = ((PsiFile)element).getVirtualFile();
            if (file2 != null && file2.isValid()) {
                String fileName = file2.getName();
                VirtualFile fileDir = file2.getParent();
                if (fileDir != null && JSFileReference.findImplicitExtension(fileName) != null) {
                    ResolvedModuleInfo info2;
                    VirtualFile packageJsonDir;
                    VirtualFile packageJson = PackageJsonUtil.findUpPackageJson(fileDir);
                    VirtualFile virtualFile = packageJsonDir = packageJson != null ? packageJson.getParent() : null;
                    if (packageJsonDir != null && (info2 = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(null, packageJsonDir, ModuleType.EXACT_PATH, true)) != null && info2.getModuleMainFile().equals(file2)) {
                        queryParameters.getOptimizer().searchWord(packageJsonDir.getName(), queryParameters.getEffectiveSearchScope(), true, element);
                    }
                    if (!fileDir.equals(packageJsonDir) && fileName.startsWith("index")) {
                        queryParameters.getOptimizer().searchWord(fileDir.getName(), queryParameters.getEffectiveSearchScope(), true, element);
                    }
                }
            }
        } else if (element instanceof PsiDirectory && (dir = ((PsiDirectory)element).getVirtualFile()).isDirectory() && dir.isValid() && (info = NodeModuleDirectorySearchProcessor.PROCESSOR.loadDirectory(null, dir, ModuleType.EXACT_PATH, true)) != null) {
            VirtualFile file3 = info.getModuleMainFile();
            PsiFile psiFile = PsiManager.getInstance((Project)queryParameters.getProject()).findFile(file3);
            if (psiFile != null) {
                queryParameters.getOptimizer().searchWord(dir.getName(), queryParameters.getEffectiveSearchScope(), true, (PsiElement)psiFile);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "queryParameters";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/nodejs/reference/RequiredFileSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

