/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.linter.stylelint;

import com.intellij.lang.css.linter.stylelint.StylelintConfiguration;
import com.intellij.lang.css.linter.stylelint.StylelintExternalRunner;
import com.intellij.lang.css.linter.stylelint.StylelintFixResult;
import com.intellij.lang.css.linter.stylelint.StylelintState;
import com.intellij.lang.css.linter.stylelint.StylelintUtil;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.util.Consumer;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StylelintFixAction
extends JSLinterFixAction {
    @NlsSafe
    private static final String LINTER_NAME = "Stylelint";

    public StylelintFixAction() {
        super(() -> LINTER_NAME, JavaScriptBundle.messagePointer("stylelint.action.fix.problems.description", new Object[0]), JavaScriptLanguageIcons.FileTypes.Stylelint);
    }

    @Override
    protected boolean needRefreshFilesAfter() {
        return false;
    }

    @Override
    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file2) {
        return file2 != null && (StylelintUtil.isStylelintConfigFile(file2) || PackageJsonUtil.isPackageJsonFile(file2));
    }

    @Override
    protected boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            StylelintFixAction.$$$reportNull$$$0(1);
        }
        return (psiFile = PsiManager.getInstance((Project)project).findFile(file2)) instanceof StylesheetFile || psiFile instanceof JSFile && ((StylelintState)StylelintConfiguration.getInstance(project).getExtendedState().getState()).processJS();
    }

    @Override
    @NotNull
    protected JSLinterConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(2);
        }
        StylelintConfiguration stylelintConfiguration = StylelintConfiguration.getInstance(project);
        if (stylelintConfiguration == null) {
            StylelintFixAction.$$$reportNull$$$0(3);
        }
        return stylelintConfiguration;
    }

    @Override
    protected Task createTask(@NotNull Project project, @NotNull Collection<? extends VirtualFile> filesToProcess, @NotNull Runnable completeCallback, boolean modalProgress) {
        if (project == null) {
            StylelintFixAction.$$$reportNull$$$0(4);
        }
        if (filesToProcess == null) {
            StylelintFixAction.$$$reportNull$$$0(5);
        }
        if (completeCallback == null) {
            StylelintFixAction.$$$reportNull$$$0(6);
        }
        final Consumer task = indicator -> {
            StylelintState state2 = (StylelintState)StylelintConfiguration.getInstance(project).getExtendedState().getState();
            for (VirtualFile file2 : filesToProcess) {
                JSLinterInput<StylelintState> input;
                JSLinterAnnotationResult result2;
                indicator.checkCanceled();
                PsiFile psiFile = (PsiFile)ReadAction.compute(() -> PsiManager.getInstance((Project)project).findFile(file2));
                if (psiFile == null || !((result2 = new StylelintExternalRunner(false, true).execute(input = JSLinterInput.create(psiFile, state2, null))) instanceof StylelintFixResult)) continue;
                StylelintFixAction.setFileContent(psiFile, ((StylelintFixResult)result2).getNewFileContent());
            }
            completeCallback.run();
        };
        if (modalProgress) {
            return new Task.Modal(project, JavaScriptBundle.message("stylelint.action.modal.title", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    task.consume((Object)indicator);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/css/linter/stylelint/StylelintFixAction$1", "run"));
                }
            };
        }
        return new Task.Backgroundable(project, JavaScriptBundle.message("stylelint.action.background.title", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                task.consume((Object)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/css/linter/stylelint/StylelintFixAction$2", "run"));
            }
        };
    }

    private static void setFileContent(@NotNull PsiFile psiFile, @NotNull String fileContent) {
        if (psiFile == null) {
            StylelintFixAction.$$$reportNull$$$0(7);
        }
        if (fileContent == null) {
            StylelintFixAction.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            Document document2 = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
            if (document2 != null && document2.getTextLength() != fileContent.length() && !document2.getText().equals(fileContent)) {
                WriteCommandAction.runWriteCommandAction((Project)psiFile.getProject(), (String)JavaScriptBundle.message("stylelint.action.modal.title", new Object[0]), null, () -> document2.setText((CharSequence)fileContent), (PsiFile[])new PsiFile[0]);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/css/linter/stylelint/StylelintFixAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/css/linter/stylelint/StylelintFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

