/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ExportedDefaultBinding;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.frameworks.commonjs.CommonJSUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyImpl;
import com.intellij.lang.javascript.psi.impl.JSDestructuringPropertyReference;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6DefaultExportReferenceSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public ES6DefaultExportReferenceSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer) {
        PsiElement element;
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(1);
        }
        if (!((element = queryParameters.getElementToSearch()) instanceof JSElement)) {
            return;
        }
        PsiElement exportElement = ES6PsiUtil.getDefaultElement(element);
        PsiElement parent = element.getContext();
        if (exportElement != null || ES6DefaultExportReferenceSearcher.isModuleExportsFor(parent, element)) {
            ES6DefaultExportReferenceSearcher.processModuleReferences((PsiElement)ObjectUtils.coalesce((Object)exportElement, (Object)element), queryParameters, new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession()), consumer);
            return;
        }
        if (!(element instanceof JSPsiNamedElementBase)) {
            return;
        }
        DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
        if (holder == null || !holder.hasFeature(JSLanguageFeature.EXPORT_DECLARATIONS)) {
            return;
        }
        String name = ((JSPsiNamedElementBase)element).getName();
        if (name != null) {
            SearchScope scope = queryParameters.getEffectiveSearchScope();
            SearchRequestCollector collector = queryParameters.getOptimizer();
            collector.searchWord(name, scope, (short)1, true, element, (RequestResultProcessor)new MyProcessor(queryParameters));
        }
    }

    private static boolean isModuleExportsFor(@Nullable PsiElement candidate, @Nullable PsiElement toExports) {
        if (candidate instanceof JSAssignmentExpression) {
            JSDefinitionExpression def = ((JSAssignmentExpression)candidate).getDefinitionExpression();
            if (def == null) {
                return false;
            }
            JSExpression initializer = def.getInitializerOrStub();
            if (initializer == toExports && CommonJSUtil.isExportsDefinition((PsiElement)def)) {
                return true;
            }
        }
        return false;
    }

    private static void processModuleReferences(@NotNull PsiElement exportElement, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull SearchRequestCollector newCollector, @NotNull Processor<? super PsiReference> consumer) {
        JSElement fileOrModule;
        if (exportElement == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(2);
        }
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(3);
        }
        if (newCollector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(5);
        }
        if ((fileOrModule = ES6PsiUtil.getExportScope(exportElement)) instanceof JSEmbeddedContent) {
            fileOrModule = PsiTreeUtil.getContextOfType((PsiElement)fileOrModule, (Class[])new Class[]{XmlFile.class});
        }
        if (fileOrModule == null) {
            return;
        }
        SearchScope userDeterminedScope = ES6DefaultExportReferenceSearcher.excludeCurrentModuleScope(queryParameters.getScopeDeterminedByUser(), (PsiElement)fileOrModule);
        queryParameters.getOptimizer().searchQuery(new QuerySearchRequest(ReferencesSearch.search((PsiElement)fileOrModule, (SearchScope)userDeterminedScope), newCollector, false, (fileReference, _collector) -> {
            PsiElement fileReferenceElement = fileReference.getElement();
            if (fileReferenceElement instanceof ES6FromClause) {
                PsiElement importOrExportDeclaration = fileReferenceElement.getParent();
                if (!ES6DefaultExportReferenceSearcher.processImportDeclaration(_collector, queryParameters, consumer, userDeterminedScope, importOrExportDeclaration, exportElement)) {
                    return false;
                }
                return ES6DefaultExportReferenceSearcher.processExportDeclaration(_collector, queryParameters, consumer, userDeterminedScope, importOrExportDeclaration);
            }
            if (fileReferenceElement instanceof TypeScriptExternalModuleReference) {
                PsiElement parent = fileReferenceElement.getParent();
                if (parent instanceof TypeScriptImportStatement) {
                    TypeScriptImportStatement tsImport = (TypeScriptImportStatement)parent;
                    ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, tsImport);
                    if (!ES6DefaultExportReferenceSearcher.searchAdditionalReferences(_collector, consumer, userDeterminedScope, tsImport)) {
                        return false;
                    }
                }
                return true;
            }
            String nameForLocalSearch = null;
            Object searchTarget = null;
            if (fileReferenceElement instanceof JSLiteralExpression) {
                PsiElement parent = fileReferenceElement.getParent();
                if (parent instanceof ES6ImportCall) {
                    nameForLocalSearch = "default";
                    searchTarget = exportElement;
                    if (nameForLocalSearch == "default") {
                        consumer.process(fileReference);
                    }
                } else {
                    JSCallExpression requireCall = JSUtils.findCallExprByArg(fileReferenceElement);
                    if (requireCall != null && requireCall.isRequireCall()) {
                        JSQualifiedNamedElement initializedElement = JSPsiImplUtils.getInitializedElement(requireCall);
                        if (initializedElement != null) {
                            nameForLocalSearch = initializedElement.getName();
                            searchTarget = initializedElement;
                        } else {
                            nameForLocalSearch = "default";
                            searchTarget = exportElement;
                        }
                    }
                }
            }
            if (nameForLocalSearch != null) {
                ES6DefaultExportReferenceSearcher.performLocalSearch(_collector, queryParameters, nameForLocalSearch, userDeterminedScope, fileReferenceElement.getContainingFile(), searchTarget);
            }
            return true;
        }));
    }

    @NotNull
    static SearchScope excludeCurrentModuleScope(@NotNull SearchScope userDeterminedScope, @NotNull PsiElement fileOrModule) {
        if (userDeterminedScope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (fileOrModule == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(7);
        }
        if (!(userDeterminedScope instanceof GlobalSearchScope) || !(fileOrModule instanceof PsiFile)) {
            SearchScope searchScope = userDeterminedScope;
            if (searchScope == null) {
                ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(8);
            }
            return searchScope;
        }
        final VirtualFile moduleFile = ((PsiFile)fileOrModule).getVirtualFile();
        return new DelegatingGlobalSearchScope((GlobalSearchScope)userDeterminedScope){

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return super.contains(file2) && !file2.equals(moduleFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher$1", "contains"));
            }
        };
    }

    private static boolean processImportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement importDeclarationCandidate, @NotNull PsiElement exportElement) {
        if (collector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(9);
        }
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(12);
        }
        if (exportElement == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(13);
        }
        if (!(importDeclarationCandidate instanceof ES6ImportDeclaration)) {
            return true;
        }
        ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)importDeclarationCandidate;
        ES6ImportedBinding[] importedBindings = importDeclaration.getImportedBindings();
        for (ES6ImportedBinding eS6ImportedBinding : importedBindings) {
            if (eS6ImportedBinding.isNamespaceImport()) {
                ES6DefaultExportReferenceSearcher.performLocalSearch(collector, queryParameters, "default", scope, importDeclaration.getContainingFile(), exportElement);
                continue;
            }
            ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, eS6ImportedBinding);
            if (ES6DefaultExportReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, eS6ImportedBinding)) continue;
            return false;
        }
        for (ES6ImportExportDeclarationPart eS6ImportExportDeclarationPart : importDeclaration.getImportSpecifiers()) {
            if (ES6DefaultExportReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, (ES6ImportExportSpecifier)eS6ImportExportDeclarationPart)) continue;
            return false;
        }
        return true;
    }

    private static boolean processSpecifier(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope scope, @NotNull ES6ImportExportSpecifier specifier) {
        if (collector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(14);
        }
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(15);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(17);
        }
        if (specifier == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(18);
        }
        if (!specifier.isDefault()) {
            return true;
        }
        PsiElement nameElement = specifier.getReferenceNameElement();
        if (nameElement == null) {
            return true;
        }
        ES6ImportExportSpecifierAlias alias = specifier.getAlias();
        if (alias == null) {
            if (specifier instanceof ES6ExportSpecifier) {
                ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, nameElement, specifier);
                return ES6DefaultExportReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, specifier);
            }
            return true;
        }
        ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, nameElement, specifier);
        return ES6DefaultExportReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, alias);
    }

    private static boolean processExportDeclaration(@NotNull SearchRequestCollector collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope scope, @Nullable PsiElement exportDeclarationCandidate) {
        if (collector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(19);
        }
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(20);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(21);
        }
        if (scope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(22);
        }
        if (!(exportDeclarationCandidate instanceof ES6ExportDeclaration)) {
            return true;
        }
        ES6ExportDeclaration exportDeclaration = (ES6ExportDeclaration)exportDeclarationCandidate;
        ES6ExportedDefaultBinding exportBinding = exportDeclaration.getExportedDefaultBinding();
        if (exportBinding != null) {
            ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, exportBinding);
            if (!ES6DefaultExportReferenceSearcher.searchAdditionalReferences(collector, consumer, scope, exportBinding)) {
                return false;
            }
        }
        for (ES6ExportSpecifier specifier : exportDeclaration.getExportSpecifiers()) {
            if (ES6DefaultExportReferenceSearcher.processSpecifier(collector, queryParameters, consumer, scope, specifier)) continue;
            return false;
        }
        return true;
    }

    private static void performLocalSearch(@NotNull SearchRequestCollector _collector, @NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull String nameForLocalSearch, @NotNull SearchScope userDeterminedScope, @NotNull PsiFile file2, @NotNull PsiElement searchTarget) {
        if (_collector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(23);
        }
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(24);
        }
        if (nameForLocalSearch == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(25);
        }
        if (userDeterminedScope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(26);
        }
        if (file2 == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(27);
        }
        if (searchTarget == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(28);
        }
        SearchRequestCollector collector = queryParameters.getOptimizer();
        SearchScope scope = userDeterminedScope.intersectWith((SearchScope)new LocalSearchScope((PsiElement)file2));
        collector.searchWord(nameForLocalSearch, scope, (short)1, true, searchTarget, (RequestResultProcessor)new JSLocalSearchResultsProcessor(queryParameters, _collector, searchTarget));
    }

    private static boolean searchAdditionalReferences(@NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> consumer, @NotNull SearchScope scope, @NotNull PsiNamedElement elementToSearch) {
        String name;
        if (collector == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(29);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(30);
        }
        if (scope == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(31);
        }
        if (elementToSearch == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(32);
        }
        if ((name = elementToSearch.getName()) != null) {
            ReferencesSearch.searchOptimized((PsiElement)elementToSearch, (SearchScope)scope.intersectWith(elementToSearch.getUseScope()), (boolean)false, (SearchRequestCollector)collector, consumer);
        }
        return true;
    }

    private static void addExplicitReference(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer, @NotNull PsiNameIdentifierOwner nameIdentifierOwner) {
        PsiElement identifier;
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(33);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(34);
        }
        if (nameIdentifierOwner == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(35);
        }
        if ((identifier = nameIdentifierOwner.getNameIdentifier()) == null) {
            return;
        }
        ES6DefaultExportReferenceSearcher.addExplicitReference(queryParameters, consumer, identifier, (PsiNamedElement)nameIdentifierOwner);
    }

    private static void addExplicitReference(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<? super PsiReference> consumer, @NotNull PsiElement nameIdentifier, final @NotNull PsiNamedElement parent) {
        if (queryParameters == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(36);
        }
        if (consumer == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(37);
        }
        if (nameIdentifier == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(38);
        }
        if (parent == null) {
            ES6DefaultExportReferenceSearcher.$$$reportNull$$$0(39);
        }
        TextRange nameRange = ES6DefaultExportReferenceSearcher.getRangeInParentElement((PsiElement)parent, nameIdentifier);
        PsiReferenceBase.Immediate<PsiElement> ref = new PsiReferenceBase.Immediate<PsiElement>((PsiElement)parent, nameRange, queryParameters.getElementToSearch()){

            public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
                if (newElementName == null) {
                    2.$$$reportNull$$$0(0);
                }
                return parent.setName(newElementName);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElementName", "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher$2", "handleElementRename"));
            }
        };
        consumer.process((Object)ref);
    }

    private static TextRange getRangeInParentElement(PsiElement parent, PsiElement nameIdentifier) {
        return nameIdentifier.getTextRange().shiftRight(-parent.getTextRange().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryParameters";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 16: 
            case 21: 
            case 30: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCollector";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDeterminedScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrModule";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher";
                break;
            }
            case 9: 
            case 14: 
            case 19: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 12: 
            case 17: 
            case 22: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_collector";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameForLocalSearch";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchTarget";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifierOwner";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "excludeCurrentModuleScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processQuery";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processModuleReferences";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "excludeCurrentModuleScope";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processImportDeclaration";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processSpecifier";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processExportDeclaration";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "performLocalSearch";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "searchAdditionalReferences";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitReference";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class JSLocalSearchResultsProcessor
    extends RequestResultProcessor {
        private final ReferencesSearch.SearchParameters myQueryParameters;
        private final PsiElement myTargetElement;
        private final SearchRequestCollector myCollector;

        JSLocalSearchResultsProcessor(ReferencesSearch.SearchParameters queryParameters, SearchRequestCollector collector, PsiElement targetElement) {
            super(new Object[0]);
            this.myQueryParameters = queryParameters;
            this.myTargetElement = targetElement;
            this.myCollector = collector;
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            JSReferenceExpression referenceExpression;
            if (element == null) {
                JSLocalSearchResultsProcessor.$$$reportNull$$$0(0);
            }
            if (consumer == null) {
                JSLocalSearchResultsProcessor.$$$reportNull$$$0(1);
            }
            if (element instanceof JSDestructuringPropertyImpl) {
                JSDestructuringPropertyImpl prop = (JSDestructuringPropertyImpl)element;
                JSDestructuringPropertyReference reference = prop.getReference();
                if (reference == null || !reference.isReferenceTo(this.myTargetElement)) {
                    return true;
                }
                JSInitializerOwner pattern2 = prop.getDestructuringElement();
                ES6DefaultExportReferenceSearcher.addExplicitReference(this.myQueryParameters, consumer, prop);
                if (pattern2 instanceof JSVariable) {
                    JSVariable variable = (JSVariable)pattern2;
                    return ES6DefaultExportReferenceSearcher.searchAdditionalReferences(this.myCollector, consumer, variable.getUseScope(), variable);
                }
            }
            return !(element instanceof JSReferenceExpression) || !(referenceExpression = (JSReferenceExpression)element).isReferenceTo(this.myTargetElement) || consumer.process((Object)referenceExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "consumer";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher$JSLocalSearchResultsProcessor";
            objectArray[2] = "processTextOccurrence";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyProcessor
    extends RequestResultProcessor {
        private final ReferencesSearch.SearchParameters myQueryParameters;
        private final SearchRequestCollector myOwnCollector;
        private final AtomicBoolean myProcessedAsModule;

        MyProcessor(@NotNull ReferencesSearch.SearchParameters queryParameters) {
            if (queryParameters == null) {
                MyProcessor.$$$reportNull$$$0(0);
            }
            super(new Object[0]);
            this.myProcessedAsModule = new AtomicBoolean();
            this.myQueryParameters = queryParameters;
            this.myOwnCollector = new SearchRequestCollector(queryParameters.getOptimizer().getSearchSession());
        }

        public boolean processTextOccurrence(@NotNull PsiElement element, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
            if (element == null) {
                MyProcessor.$$$reportNull$$$0(1);
            }
            if (consumer == null) {
                MyProcessor.$$$reportNull$$$0(2);
            }
            if (!(element instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression reference = (JSReferenceExpression)element;
            if (!reference.isReferenceTo(this.myQueryParameters.getElementToSearch())) {
                return true;
            }
            PsiElement parent = element.getParent();
            if (parent instanceof JSExportAssignment || ES6DefaultExportReferenceSearcher.isModuleExportsFor(parent, element)) {
                boolean isExportForCurrentModule;
                JSElement exportScope = ES6PsiUtil.getExportScope(parent);
                boolean bl = isExportForCurrentModule = exportScope != null && exportScope.isEquivalentTo((PsiElement)ES6PsiUtil.getExportScope(this.myQueryParameters.getElementToSearch()));
                if (isExportForCurrentModule && this.myProcessedAsModule.compareAndSet(false, true)) {
                    ES6DefaultExportReferenceSearcher.processModuleReferences(parent, this.myQueryParameters, this.myOwnCollector, consumer);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "queryParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/ecmascript6/findUsages/ES6DefaultExportReferenceSearcher$MyProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTextOccurrence";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

