/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.inspections.JSDefaultInspectionSuppressor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceInspectionProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JavaScriptFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnalysisHandlersFactory {
    public static final LanguageExtension<JSAnalysisHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.analysisHandlersFactory");
    private static final JSAnalysisHandlersFactory DEFAULT_INSTANCE = new JSAnalysisHandlersFactory();

    @NotNull
    public static JSAnalysisHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        return JSAnalysisHandlersFactory.forLanguage(dialect);
    }

    @NotNull
    public static JSAnalysisHandlersFactory forLanguage(@Nullable Language dialect) {
        JSAnalysisHandlersFactory dialectSpecificFactory = dialect != null ? (JSAnalysisHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSAnalysisHandlersFactory == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public JSAnnotatingVisitor createAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(2);
        }
        return new JavaScriptAnnotatingVisitor(psiElement, holder);
    }

    public JSKeywordHighlighterVisitor createKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull DialectOptionHolder dialectOptionHolder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(3);
        }
        if (dialectOptionHolder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(4);
        }
        return new JSKeywordHighlighterVisitor(holder, dialectOptionHolder);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public JSReferenceChecker getReferenceChecker(@NotNull JSReferenceInspectionProblemReporter reporter) {
        if (reporter == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public JSReferenceChecker getReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(6);
        }
        return new JSReferenceChecker(reporter);
    }

    @NotNull
    public JSProblemReporter<Void> getProblemReporter(final ProblemsHolder holder) {
        return new JSProblemReporter<Void>(){

            @Override
            @Nullable
            public Void registerProblem(PsiElement place, TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                TextRange range = JSAnnotatorProblemReporter.shortenTextRange(place, place.getTextRange());
                JSReferenceProblemReporter.registerFixes(place, fixes);
                if (highlightType == null) {
                    highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                holder.registerProblem(place, message, highlightType, range.shiftRight(-place.getTextRange().getStartOffset()), fixes);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/JSAnalysisHandlersFactory$1", "registerProblem"));
            }
        };
    }

    @NotNull
    public JSTypeChecker getTypeChecker(ProblemsHolder holder) {
        return new JSTypeChecker(this.getProblemReporter(holder));
    }

    @NotNull
    public JSFunctionSignatureChecker getFunctionSignatureChecker(final @NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(7);
        }
        JSTypeChecker typeChecker = this.getTypeChecker(holder);
        return new JavaScriptFunctionSignatureChecker(typeChecker){

            @Override
            protected void registerProblem(JSCallExpression callExpression, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
                holder.registerProblem(place, message, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/JSAnalysisHandlersFactory$2", "registerProblem"));
            }
        };
    }

    @NotNull
    public InspectionSuppressor getInspectionSuppressor() {
        JSDefaultInspectionSuppressor jSDefaultInspectionSuppressor = JSDefaultInspectionSuppressor.INSTANCE;
        if (jSDefaultInspectionSuppressor == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(8);
        }
        return jSDefaultInspectionSuppressor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotatingVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordHighlighterVisitor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceChecker";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

