/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeCommandLineOwner;
import com.intellij.javascript.nodejs.debug.NodeLocalDebuggableRunProfileStateSync;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.library.yarn.YarnPnpNodePackage;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntCoreTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTargetTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTask;
import com.intellij.lang.javascript.buildTools.grunt.GruntTaskStructureUtil;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileManager;
import com.intellij.lang.javascript.buildTools.grunt.GruntfileStructure;
import com.intellij.lang.javascript.buildTools.grunt.execution.GruntWatchTaskListener;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntNonSharedSettings;
import com.intellij.lang.javascript.buildTools.grunt.rc.GruntRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.LocalFileFinder;

public class GruntRunProfileState
extends NodeLocalDebuggableRunProfileStateSync
implements NodeCommandLineOwner {
    private static final String WATCH_TASK_NAME = "watch";
    private final ExecutionEnvironment myEnvironment;
    private final GruntRunSettings myRunSettings;
    private final GruntNonSharedSettings myNonSharedSettings;

    public GruntRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull GruntRunSettings runSettings, @NotNull GruntNonSharedSettings nonSharedSettings) {
        if (environment == null) {
            GruntRunProfileState.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            GruntRunProfileState.$$$reportNull$$$0(1);
        }
        if (nonSharedSettings == null) {
            GruntRunProfileState.$$$reportNull$$$0(2);
        }
        this.myEnvironment = environment;
        this.myRunSettings = runSettings;
        this.myNonSharedSettings = nonSharedSettings;
    }

    @Override
    @NotNull
    protected ExecutionResult executeSync(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveNotNull(this.myEnvironment.getProject());
        GeneralCommandLine commandLine = NodeCommandLineUtil.createCommandLine();
        NodeCommandLineUtil.configureCommandLine(commandLine, configurator, interpreter, (ThrowableConsumer<? super Boolean, ? extends ExecutionException>)((ThrowableConsumer)debugMode -> this.configureCommandLine(commandLine, interpreter)));
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, true);
        JsbtUtil.installBeepSupport((ProcessHandler)processHandler);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        this.installWatchHandler((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole((ProcessHandler)processHandler, commandLine.getWorkDirectory());
        console.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(console, (ProcessHandler)processHandler);
        return new DefaultExecutionResult((ExecutionConsole)console, (ProcessHandler)processHandler);
    }

    private void installWatchHandler(final @NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(3);
        }
        GruntfileManager gruntfileManager = GruntfileManager.getInstance(this.myEnvironment.getProject());
        VirtualFile gruntfile = LocalFileFinder.findFile((String)FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        if (gruntfile != null) {
            GruntfileStructure gruntfileStructure = gruntfileManager.getCachedStructure(gruntfile);
            if (gruntfileStructure != null) {
                GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, gruntfileStructure, this.myRunSettings.getTasks());
            } else {
                gruntfileManager.fetchGruntStructure(gruntfile, (CatchingConsumer<? super GruntfileStructure, ? super JsbtTaskFetchException>)new CatchingConsumer<GruntfileStructure, JsbtTaskFetchException>(){

                    public void consume(JsbtTaskFetchException e) {
                    }

                    public void consume(GruntfileStructure structure) {
                        GruntRunProfileState.installWatchHandler(GruntRunProfileState.this.myEnvironment.getProject(), processHandler, structure, GruntRunProfileState.this.myRunSettings.getTasks());
                    }
                });
            }
        } else {
            GruntRunProfileState.installWatchHandler(this.myEnvironment.getProject(), processHandler, null, this.myRunSettings.getTasks());
        }
    }

    private static void installWatchHandler(@NotNull Project project, @NotNull ProcessHandler processHandler, @Nullable GruntfileStructure gruntfileStructure, @NotNull List<String> taskNames) {
        if (project == null) {
            GruntRunProfileState.$$$reportNull$$$0(4);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(5);
        }
        if (taskNames == null) {
            GruntRunProfileState.$$$reportNull$$$0(6);
        }
        for (String taskName : taskNames) {
            String watchTaskName = GruntRunProfileState.findWatchTaskNameFor(gruntfileStructure, taskName);
            if (watchTaskName == null) continue;
            processHandler.addProcessListener((ProcessListener)new GruntWatchTaskListener(project, watchTaskName));
            return;
        }
    }

    @Nullable
    private static String findWatchTaskNameFor(@Nullable GruntfileStructure structure, @NotNull String taskName) {
        GruntTask task;
        if (taskName == null) {
            GruntRunProfileState.$$$reportNull$$$0(7);
        }
        if (structure != null && (task = structure.findTaskByName(taskName)) != null) {
            Collection<GruntTask> dependentTasks = GruntTask.listAllDependentTasksFor(task);
            for (GruntTask dependentTask : dependentTasks) {
                GruntTargetTask dependentTargetTask;
                if (dependentTask instanceof GruntCoreTask && dependentTask.getName().contains(WATCH_TASK_NAME)) {
                    return dependentTask.getName();
                }
                if (!(dependentTask instanceof GruntTargetTask) || !(dependentTargetTask = (GruntTargetTask)dependentTask).getCoreTask().getName().contains(WATCH_TASK_NAME)) continue;
                return dependentTargetTask.getName();
            }
        }
        return taskName.equals(WATCH_TASK_NAME) || taskName.startsWith("watch:") ? taskName : null;
    }

    @NotNull
    private ConsoleView createConsole(@NotNull ProcessHandler processHandler, @Nullable File cwd) {
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(8);
        }
        ConsoleView console = NodeCommandLineUtil.createConsole(processHandler, this.myEnvironment.getProject(), false);
        console.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), cwd));
        console.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(this.myEnvironment.getProject(), cwd));
        ConsoleView consoleView = console;
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(9);
        }
        return consoleView;
    }

    private void configureCommandLine(@NotNull GeneralCommandLine commandLine, @NotNull NodeJsInterpreter interpreter) throws ExecutionException {
        if (commandLine == null) {
            GruntRunProfileState.$$$reportNull$$$0(10);
        }
        if (interpreter == null) {
            GruntRunProfileState.$$$reportNull$$$0(11);
        }
        commandLine.withCharset(StandardCharsets.UTF_8);
        File workingDirectory = new File(this.myRunSettings.getGruntfilePath()).getParentFile();
        commandLine.withWorkDirectory(workingDirectory.getAbsolutePath());
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.addParameters(ParametersListUtil.parse((String)this.myRunSettings.getNodeOptions().trim()));
        if (this.myNonSharedSettings.getGruntCliPackage() instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)this.myNonSharedSettings.getGruntCliPackage()).addYarnRunToCommandLine(commandLine, this.myEnvironment.getProject(), interpreter, null);
        } else {
            commandLine.addParameter(GruntTaskStructureUtil.getGruntCliMainFilePath(this.myNonSharedSettings.getGruntCliPackage()));
        }
        commandLine.addParameter("--gruntfile");
        commandLine.addParameter(FileUtil.toSystemDependentName((String)this.myRunSettings.getGruntfilePath()));
        String arguments = this.myRunSettings.getArguments().trim();
        if (StringUtil.isNotEmpty((String)arguments)) {
            commandLine.addParameters(ParametersList.parse((String)arguments));
        }
        commandLine.addParameters(this.myRunSettings.getTasks());
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        BaseOSProcessHandler osProcessHandler;
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(12);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(13);
        }
        if ((osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class)) != null) {
            ArrayList args = ContainerUtil.newArrayList((Object[])new String[]{"grunt"});
            String arguments = this.myRunSettings.getArguments().trim();
            if (StringUtil.isNotEmpty((String)arguments)) {
                args.addAll(ParametersListUtil.parse((String)arguments));
            }
            args.addAll(this.myRunSettings.getTasks());
            GruntRunProfileState.doFoldCommandLine(consoleView, osProcessHandler, ParametersListUtil.join((List)args));
        }
    }

    private static void doFoldCommandLine(final @NotNull ConsoleView consoleView, final @NotNull BaseOSProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        String commandLine;
        if (consoleView == null) {
            GruntRunProfileState.$$$reportNull$$$0(14);
        }
        if (processHandler == null) {
            GruntRunProfileState.$$$reportNull$$$0(15);
        }
        if (foldedCommandLineText == null) {
            GruntRunProfileState.$$$reportNull$$$0(16);
        }
        if ((commandLine = processHandler.getCommandLine()) != null) {
            if (processHandler.isStartNotified()) {
                JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
            } else {
                processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                    public void startNotified(@NotNull ProcessEvent event) {
                        if (event == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        processHandler.removeProcessListener((ProcessListener)this);
                        JsbtUtil.foldMatchingTextAtOffset(consoleView, 0, commandLine, foldedCommandLineText);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState$2", "startNotified"));
                    }
                });
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonSharedSettings";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldedCommandLineText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunProfileState";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "installWatchHandler";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findWatchTaskNameFor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "configureCommandLine";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doFoldCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

