/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.ES6ClassExpression;
import com.intellij.lang.ecmascript6.psi.ES6ExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.ecmascript6.psi.Es6MetaProperty;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.JSCompletionKeywordsContributor;
import com.intellij.lang.javascript.completion.JSKeywordsCompletionProvider;
import com.intellij.lang.javascript.completion.JSLookupPriority;
import com.intellij.lang.javascript.completion.KeywordCompletionConsumer;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.typescript.completion.TypeScriptCompletionKeywordsContributor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6CompletionKeywordsContributor
extends JSCompletionKeywordsContributor {
    private static final TokenSet FILE_REFERENCES = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.FROM_CLAUSE, JSTokenTypes.STRING_LITERAL});

    @Override
    public boolean process(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context) {
        JSClass containingClass;
        PsiElement grandParentParent;
        PsiElement parent;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(1);
        }
        if (ES6CompletionKeywordsContributor.addMetaKeyword(consumer, parent = context.getParent())) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addFromOrAsKeyword(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addExtendsImplements(consumer, context)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExportDefault(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.addAfterExtendsImplements(consumer, parent)) {
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterExport(parent)) {
            this.appendKeywordsAfterExport(consumer);
            return false;
        }
        if (ES6CompletionKeywordsContributor.isAfterImport(parent)) {
            this.appendKeywordsAfterImport(consumer);
            return false;
        }
        if (parent instanceof ES6ImportExportSpecifier || parent instanceof ES6ImportedBinding) {
            return false;
        }
        PsiElement grandParent = parent != null ? parent.getParent() : null;
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent) && !TypeScriptCompletionKeywordsContributor.shouldAppendExtendsForGenerics(parent)) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPORT, JSCompletionKeyword.EXPORT);
        }
        if (!ES6CompletionKeywordsContributor.processClassMemberContext(parent, grandParent, consumer)) {
            return false;
        }
        JSPsiElementBase parentFunction = JSPsiImplUtils.getParentFunctionThroughLambdas(parent);
        if (parentFunction == null) {
            parentFunction = (JSPsiElementBase)PsiTreeUtil.getParentOfType((PsiElement)parent, JSField.class);
        }
        if ((containingClass = JSUtils.getMemberContainingClass((PsiElement)parentFunction)) != null && parentFunction.getJSContext() != JSContext.STATIC && !containingClass.isInterface() && containingClass.getExtendsList() != null && !(grandParent instanceof ES6Property)) {
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)parent).SPACE_BEFORE_METHOD_CALL_PARENTHESES, JSCompletionKeyword.SUPER);
        }
        return super.process(consumer, context);
    }

    protected void appendKeywordsAfterImport(KeywordCompletionConsumer consumer) {
    }

    private static boolean isAfterImport(PsiElement parent) {
        return parent instanceof ES6ImportedBinding && parent.getParent() instanceof ES6ImportDeclaration;
    }

    private static boolean addMetaKeyword(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(2);
        }
        if (parent instanceof Es6MetaProperty) {
            String parentText = parent.getText();
            if (parentText.startsWith("new.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.TARGET);
                return true;
            }
            if (parentText.startsWith("import.")) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, false, JSCompletionKeyword.META);
                return true;
            }
        }
        return false;
    }

    private static boolean processClassMemberContext(@NotNull PsiElement parent, @Nullable PsiElement grandParent, @NotNull KeywordCompletionConsumer consumer) {
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(4);
        }
        if (parent instanceof JSField && grandParent instanceof JSVarStatement && grandParent.getParent() instanceof ES6Class) {
            if (!ES6CompletionKeywordsContributor.checkClassMemberPrevSibling(grandParent)) {
                return false;
            }
            consumer.consume(JSLookupPriority.SMART_PRIORITY, JSCodeStyleSettings.getCommonSettings((PsiElement)parent).SPACE_BEFORE_METHOD_PARENTHESES, JSCompletionKeyword.CONSTRUCTOR);
            consumer.consume(JSLookupPriority.SMART_PRIORITY, true, JSCompletionKeyword.STATIC);
            return false;
        }
        return true;
    }

    protected static boolean checkClassMemberPrevSibling(@NotNull PsiElement grandParent) {
        PsiElement sibling;
        PsiElement prev;
        if (grandParent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(5);
        }
        return !((prev = grandParent.getPrevSibling()) instanceof PsiWhiteSpace) || prev.textContains('\n') || !((sibling = prev.getPrevSibling()) instanceof JSVarStatement) || !(sibling.getLastChild() instanceof PsiErrorElement);
    }

    private static boolean isModuleContext(@Nullable PsiElement parent, @Nullable PsiElement grandParent, @Nullable PsiElement grandParentParent) {
        return parent instanceof JSReferenceExpression && grandParent instanceof JSExpressionStatement && !JSKeywordsCompletionProvider.isContextForOperation(PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent)) && ES6PsiUtil.isExportScope(grandParentParent);
    }

    public static boolean isAfterExport(@Nullable PsiElement parent) {
        PsiElement grandParentParent;
        if (parent == null) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        PsiElement psiElement = grandParentParent = grandParent != null ? grandParent.getParent() : null;
        if (ES6CompletionKeywordsContributor.isModuleContext(parent, grandParent, grandParentParent)) {
            PsiElement prevPrevSibling;
            assert (grandParent != null);
            PsiElement prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
            if (prevSibling instanceof PsiErrorElement && JavaScriptBundle.message("javascript.parser.message.expected.declaration", new Object[0]).equals(((PsiErrorElement)prevSibling).getErrorDescription()) && (prevPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevSibling)) instanceof JSAttributeList && ((JSAttributeList)prevPrevSibling).hasModifier(JSAttributeList.ModifierType.EXPORT)) {
                return true;
            }
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAfterExportDefault(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(6);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prev instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.DEFAULT_KEYWORD) {
            return false;
        }
        if (!((prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev)) instanceof LeafPsiElement)) {
            return false;
        }
        if (((LeafPsiElement)prev).getElementType() != JSTokenTypes.EXPORT_KEYWORD) {
            return false;
        }
        consumer.consume(JSLookupPriority.SMART_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.ASYNC);
        return true;
    }

    public static boolean addAfterExtendsImplements(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        JSExpression expression;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(7);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement grandParent = parent.getParent();
        if (grandParent instanceof JSReferenceListMember && (expression = ((JSReferenceListMember)grandParent).getExpression()) == parent) {
            consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS);
            return true;
        }
        return false;
    }

    public static boolean addExtendsImplements(@Nullable KeywordCompletionConsumer consumer, @NotNull PsiElement position) {
        if (position == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(8);
        }
        PsiElement parent = position.getParent();
        if (position instanceof LeafPsiElement && parent instanceof ES6ClassExpression && ((ES6ClassExpression)parent).getNameIdentifier() == position) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsForAnonymousClassExpression(consumer, position);
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return false;
        }
        PsiElement expression = ES6CompletionKeywordsContributor.getBeforeExtendsExpression(parent);
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (expression != null && JSKeywordSets.IDENTIFIER_NAMES.contains(expression.getNode().getElementType())) {
            PsiElement prevPrev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)expression);
            if (prevPrev instanceof LeafPsiElement) {
                IElementType type = ((LeafPsiElement)prevPrev).getElementType();
                if (type == JSTokenTypes.CLASS_KEYWORD) {
                    return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, parent);
                }
                if (type == JSTokenTypes.INTERFACE_KEYWORD) {
                    if (consumer != null) {
                        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
                    }
                    return true;
                }
                if (type == JSTokenTypes.ENUM_KEYWORD) {
                    return true;
                }
            }
        } else if (expression instanceof JSReferenceList) {
            IElementType type;
            PsiElement child = expression.getParent().getFirstChild();
            PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)child);
            if (hasInterfaces && possibleClassKeyword instanceof LeafPsiElement && (type = ((LeafPsiElement)possibleClassKeyword).getElementType()) == JSTokenTypes.CLASS_KEYWORD) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
                }
                return true;
            }
        } else if (expression instanceof TypeScriptTypeParameter) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            }
            return true;
        }
        return false;
    }

    private static boolean addExtendsImplementsKeywords(@Nullable KeywordCompletionConsumer consumer, @NotNull PsiElement parent) {
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(9);
        }
        boolean hasInterfaces = DialectDetector.hasFeature(parent, JSLanguageFeature.INTERFACES);
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.EXTENDS);
            if (hasInterfaces) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.IMPLEMENTS);
            }
        }
        return true;
    }

    private static boolean addExtendsImplementsForAnonymousClassExpression(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement position) {
        PsiElement possibleClassKeyword = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)position);
        if (possibleClassKeyword != null && possibleClassKeyword.getNode().getElementType() == JSTokenTypes.CLASS_KEYWORD) {
            return ES6CompletionKeywordsContributor.addExtendsImplementsKeywords(consumer, position);
        }
        return false;
    }

    @Contract(value="_, null -> false")
    public static boolean addFromOrAsKeyword(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        ASTNode node;
        if (!(parent instanceof JSReferenceExpression)) {
            return ES6CompletionKeywordsContributor.addAsKeywordForImportExportSpecifier(consumer, parent);
        }
        PsiElement grandParent = parent.getParent();
        if (!(grandParent instanceof JSExpressionStatement)) {
            return false;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return false;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        boolean isImport = prevSiblingPrevSibling instanceof ES6ImportDeclaration;
        boolean isExport = prevSiblingPrevSibling instanceof ES6ExportDeclaration;
        if (!isImport && !isExport) {
            return false;
        }
        PsiElement last = prevSiblingPrevSibling.getLastChild();
        if (last != null) {
            PsiElement prev;
            PsiElement lastLast = last.getLastChild();
            if (lastLast instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastLast)) != null && prev.getNode().getElementType() == JSTokenTypes.MULT) {
                if (consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, isImport ? JSCompletionKeyword.AS : JSCompletionKeyword.FROM);
                }
                return true;
            }
            prev = last.getPrevSibling();
            if (prev != null) {
                IElementType type = prev.getNode().getElementType();
                if (type == JSTokenTypes.COMMA) {
                    return true;
                }
                if (!isImport && type == JSTokenTypes.MULT && consumer != null) {
                    consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
                }
            }
        }
        if ((node = prevSiblingPrevSibling.getNode()).findChildByType(FILE_REFERENCES) == null) {
            if (consumer != null) {
                consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.FROM);
            }
            return !isExport || !prevSibling.textContains('\n');
        }
        return false;
    }

    @Contract(value="_, null -> false")
    private static boolean addAsKeywordForImportExportSpecifier(@Nullable KeywordCompletionConsumer consumer, @Nullable PsiElement parent) {
        if (!(parent instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        PsiElement prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)parent);
        if (!(prevNode instanceof PsiErrorElement)) {
            return false;
        }
        if (!((prevNode = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prevNode)) instanceof ES6ImportExportSpecifier)) {
            return false;
        }
        if (consumer != null) {
            consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.AS);
        }
        return true;
    }

    @Nullable
    private static PsiElement getBeforeExtendsExpression(@NotNull PsiElement parent) {
        PsiElement prev;
        PsiElement deepestLast;
        PsiElement grandParent;
        if (parent == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(10);
        }
        if (!((grandParent = parent.getParent()) instanceof JSExpressionStatement)) {
            return null;
        }
        PsiElement prevSibling = grandParent.getPrevSibling();
        if (!(prevSibling instanceof PsiWhiteSpace)) {
            return null;
        }
        PsiElement prevSiblingPrevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)grandParent);
        if (prevSiblingPrevSibling instanceof JSClass) {
            PsiElement lastChild = prevSiblingPrevSibling.getLastChild();
            if (!(lastChild instanceof PsiErrorElement)) {
                return null;
            }
            return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)lastChild);
        }
        if (prevSiblingPrevSibling instanceof JSStatement && (deepestLast = PsiTreeUtil.getDeepestLast((PsiElement)prevSiblingPrevSibling)) instanceof PsiErrorElement && (prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)deepestLast)) != null && JSKeywordSets.IDENTIFIER_NAMES.contains(prev.getNode().getElementType())) {
            return prev;
        }
        return null;
    }

    @Override
    public void appendSpecificKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context, PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(12);
        }
        super.appendSpecificKeywords(consumer, context, grandParent);
        this.appendAwaitYieldKeywords(consumer, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.ASYNC, JSCompletionKeyword.LET, JSCompletionKeyword.CONST);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, JSCompletionKeyword.IMPORT_WITH_BRACES);
    }

    @Override
    public void appendExpressionContextKeywords(@NotNull KeywordCompletionConsumer consumer, @NotNull PsiElement context, @Nullable PsiElement grandParent) {
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(13);
        }
        if (context == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(14);
        }
        super.appendExpressionContextKeywords(consumer, context, grandParent);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.ASYNC);
        consumer.consume(JSLookupPriority.NON_CONTEXT_KEYWORDS_PRIORITY, false, JSCompletionKeyword.IMPORT_WITH_BRACES);
        this.appendAwaitYieldKeywords(consumer, grandParent);
    }

    protected void appendAwaitYieldKeywords(@NotNull KeywordCompletionConsumer consumer, @Nullable PsiElement grandParent) {
        JSLookupPriority priority2;
        JSFunction function2;
        if (consumer == null) {
            ES6CompletionKeywordsContributor.$$$reportNull$$$0(15);
        }
        if ((function2 = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)grandParent, JSFunction.class)) != null && function2.isAsync()) {
            priority2 = ES6CompletionKeywordsContributor.isAwaitExpression(grandParent) ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
            consumer.consume(priority2, true, JSCompletionKeyword.AWAIT);
        }
        if (function2 != null && function2.isGenerator()) {
            priority2 = grandParent instanceof JSYieldExpression ? JSLookupPriority.LOWEST_PRIORITY : JSLookupPriority.SMART_KEYWORDS_PRIORITY;
            consumer.consume(priority2, true, JSCompletionKeyword.YIELD);
        }
    }

    private static boolean isAwaitExpression(@Nullable PsiElement grandParent) {
        return grandParent instanceof JSPrefixExpression && ((JSPrefixExpression)grandParent).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD;
    }

    protected void appendKeywordsAfterExport(KeywordCompletionConsumer consumer) {
        consumer.consume(JSLookupPriority.SMART_KEYWORDS_PRIORITY, true, JSCompletionKeyword.CLASS, JSCompletionKeyword.VAR, JSCompletionKeyword.CONST, JSCompletionKeyword.LET, JSCompletionKeyword.FUNCTION, JSCompletionKeyword.DEFAULT, JSCompletionKeyword.ASYNC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/completion/ES6CompletionKeywordsContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addMetaKeyword";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassMemberContext";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClassMemberPrevSibling";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExportDefault";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "addAfterExtendsImplements";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtendsImplements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtendsImplementsKeywords";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getBeforeExtendsExpression";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSpecificKeywords";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "appendExpressionContextKeywords";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "appendAwaitYieldKeywords";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

