/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.ml.JSMLCompletionRankingProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLContextFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLElementFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLTrackingCompletionProvider;
import com.intellij.lang.javascript.completion.ml.Origin;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "()V", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "getIdentifiersSimilarity", "", "identifierWords", "", "targetWords", "getName", "isAcceptable", "", "intellij.javascript.impl"})
public class JSMLElementFeaturesProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "js";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        Map result2;
        block13: {
            double initializedNameSimilarity;
            double expectedTypeSimilarity;
            PsiElement parent;
            VirtualFile elementFile;
            block15: {
                Object initializedElementWords;
                Object expectedTypeWords;
                block14: {
                    Object object;
                    PsiElement psiElement;
                    JSPostfixTemplateProvider.JSPostfixTemplateKind templateKind;
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    Intrinsics.checkNotNullParameter((Object)location, (String)"location");
                    Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
                    if (!this.isAcceptable(location)) {
                        return MapsKt.emptyMap();
                    }
                    boolean bl = false;
                    result2 = new LinkedHashMap();
                    JSMLTrackingCompletionProvider.Kind provider = (JSMLTrackingCompletionProvider.Kind)((Object)element.getUserData(JSMLTrackingCompletionProvider.JS_PROVIDER_KEY));
                    if (provider != null) {
                        result2.put("provider", MLFeatureValue.Companion.categorical((Enum)provider));
                    }
                    Object object2 = element.getObject();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element.`object`");
                    Object obj = object2;
                    if (obj instanceof JSCompletionKeyword) {
                        result2.put("keyword", MLFeatureValue.Companion.categorical((Enum)obj));
                    }
                    if (element instanceof PostfixTemplateLookupElement && (templateKind = JSPostfixTemplateProvider.findKindByTemplate(((PostfixTemplateLookupElement)element).getPostfixTemplate())) != null) {
                        result2.put("postfix_template", MLFeatureValue.Companion.categorical((Enum)templateKind));
                    }
                    if ((psiElement = element.getPsiElement()) == null) {
                        return result2;
                    }
                    Origin origin = TypeScriptPsiUtil.isAmbientDeclaration(psiElement) ? Origin.DTS : (PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{JSEmbeddedContent.class}) != null ? Origin.HTML : (DialectDetector.isTypeScript(psiElement) ? Origin.TS : Origin.JS));
                    result2.put("origin", MLFeatureValue.Companion.categorical((Enum)origin));
                    PsiFile psiFile = psiElement.getContainingFile();
                    elementFile = psiFile != null ? psiFile.getVirtualFile() : null;
                    boolean isFromCoreLibrary = elementFile != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(elementFile);
                    result2.put("is_from_core_library", MLFeatureValue.Companion.binary(isFromCoreLibrary));
                    result2.put("kind", MLFeatureValue.Companion.categorical((Enum)JSNamedElementKind.kind(psiElement)));
                    CompletionParameters completionParameters = location.getCompletionParameters();
                    PsiElement psiElement2 = completionParameters != null && (completionParameters = completionParameters.getPosition()) != null ? completionParameters.getParent() : (parent = null);
                    if (!(parent instanceof JSReferenceExpression)) break block13;
                    Object object3 = (SoftlyCachedValue)parent.getUserData(JSMLElementFeaturesProviderKt.getEXPECTED_TYPE_WORDS_KEY());
                    if (object3 == null || (object3 = (List)((SoftlyCachedValue)object3).getUpToDateOrNull()) == null) {
                        object3 = expectedTypeWords = CollectionsKt.emptyList();
                    }
                    if ((object = (SoftlyCachedValue)parent.getUserData(JSMLElementFeaturesProviderKt.getINITIALIZED_ELEMENT_WORDS_KEY())) == null || (object = (List)((SoftlyCachedValue)object).getUpToDateOrNull()) == null) {
                        object = CollectionsKt.emptyList();
                    }
                    initializedElementWords = object;
                    expectedTypeSimilarity = 0.0;
                    initializedNameSimilarity = 0.0;
                    Collection collection = (Collection)expectedTypeWords;
                    boolean bl2 = false;
                    if (!collection.isEmpty()) break block14;
                    collection = (Collection)initializedElementWords;
                    bl2 = false;
                    if (!(!collection.isEmpty())) break block15;
                }
                String string = element.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
                List<String> identifierWords = JSMLContextFeaturesProviderKt.wordsFromQualifiedName(string);
                expectedTypeSimilarity = this.getIdentifiersSimilarity(identifierWords, (List<String>)expectedTypeWords);
                initializedNameSimilarity = this.getIdentifiersSimilarity(identifierWords, (List<String>)initializedElementWords);
            }
            boolean isFromReferencedFile = false;
            boolean isFromReferencedModule = false;
            if (elementFile != null) {
                Object object = (SoftlyCachedValue)parent.getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_FILES_KEY());
                if (object == null || (object = (Set)((SoftlyCachedValue)object).getUpToDateOrNull()) == null) {
                    object = SetsKt.emptySet();
                }
                Object referencedFiles2 = object;
                isFromReferencedFile = referencedFiles2.contains(elementFile);
                Object object4 = (SoftlyCachedValue)parent.getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_MODULES_KEY());
                if (object4 == null || (object4 = (Set)((SoftlyCachedValue)object4).getUpToDateOrNull()) == null) {
                    object4 = SetsKt.emptySet();
                }
                Object referencedModules = object4;
                ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)location.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(location.project)");
                ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026cation.project).fileIndex");
                ProjectFileIndex fileIndex = projectFileIndex;
                isFromReferencedModule = CollectionsKt.contains((Iterable)((Iterable)referencedModules), (Object)JSMLContextFeaturesProviderKt.getLibrarySourceRootForFile(fileIndex, elementFile));
            }
            MapsKt.putAll((Map)result2, (Pair[])new Pair[]{TuplesKt.to((Object)"expected_type_similarity", (Object)MLFeatureValue.Companion.float(expectedTypeSimilarity)), TuplesKt.to((Object)"initialized_name_similarity", (Object)MLFeatureValue.Companion.float(initializedNameSimilarity)), TuplesKt.to((Object)"is_from_referenced_file", (Object)MLFeatureValue.Companion.binary(isFromReferencedFile)), TuplesKt.to((Object)"is_from_referenced_module", (Object)MLFeatureValue.Companion.binary(isFromReferencedModule))});
        }
        return result2;
    }

    public boolean isAcceptable(@NotNull CompletionLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompletionParameters completionParameters = location.getCompletionParameters();
        if (completionParameters == null || (completionParameters = completionParameters.getPosition()) == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)completionParameters, (String)"location.completionParam\u2026.position ?: return false");
        CompletionParameters position = completionParameters;
        Language language = DialectDetector.languageOfElement((PsiElement)position);
        if (!(language instanceof JSLanguageDialect)) {
            language = null;
        }
        JSLanguageDialect jSLanguageDialect = (JSLanguageDialect)language;
        if (jSLanguageDialect == null) {
            return false;
        }
        JSLanguageDialect language2 = jSLanguageDialect;
        return JSMLCompletionRankingProviderKt.isJSMLSupported(language2);
    }

    private final double getIdentifiersSimilarity(List<String> identifierWords, List<String> targetWords) {
        int n;
        if (identifierWords.isEmpty() || targetWords.isEmpty()) {
            return 0.0;
        }
        Iterable $this$count$iv = identifierWords;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String p1 = (String)element$iv;
                boolean bl = false;
                if (!targetWords.contains(p1)) continue;
                int n2 = ++count$iv;
                boolean bl2 = false;
                if (n2 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int n3 = identifierWords.size();
        int n4 = targetWords.size();
        boolean bl = false;
        return (double)n / (double)Math.max(n3, n4);
    }
}

