/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSPredefinedLibraryManager;
import com.intellij.lang.javascript.psi.resolve.JSResolveScopeProvider;
import com.intellij.lang.javascript.scratch.JSScratchFileInfoProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptResolveScopeProvider
extends JSResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(1);
        }
        FileType type = file2.getFileType();
        if (!this.isApplicable(file2) && !TypeScriptResolveScopeProvider.isTypeScriptScratchFile(file2, project, type)) {
            return null;
        }
        TypeScriptLibraryProvider libraryService = TypeScriptLibraryProvider.getService(project);
        Set<VirtualFile> allLibraries = TypeScriptLibraryProvider.getAllLibraries(project);
        if (allLibraries.contains(file2)) {
            return GlobalSearchScope.filesScope((Project)project, libraryService.getPredefinedLibraries(file2));
        }
        GlobalSearchScope moduleAndLibraryScope = this.getModuleAndDefaultLibraryScope(file2, project);
        return this.restrictByFileType(file2, libraryService, moduleAndLibraryScope);
    }

    protected GlobalSearchScope restrictByFileType(@NotNull VirtualFile file2, @NotNull TypeScriptLibraryProvider libraryService, @NotNull GlobalSearchScope moduleAndLibraryScope) {
        if (file2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(2);
        }
        if (libraryService == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(3);
        }
        if (moduleAndLibraryScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(4);
        }
        return libraryService.getFileTypeRestrictedScope(moduleAndLibraryScope, file2);
    }

    @NotNull
    private GlobalSearchScope getModuleAndDefaultLibraryScope(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(5);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(6);
        }
        JSLanguageLevel level = DialectDetector.getConfiguredJSLevel(file2, project);
        Set<VirtualFile> includedFiles = JSPredefinedLibraryManager.getPredefinedLibraryManager(project).getRequiredLibraryFilesForResolve(level);
        Set<VirtualFile> excludedFiles = JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles();
        GlobalSearchScope globalSearchScope = this.getProjectAndLibrariesScope(file2, project, includedFiles, excludedFiles);
        if (globalSearchScope == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(7);
        }
        return globalSearchScope;
    }

    private static boolean isTypeScriptScratchFile(@NotNull VirtualFile file2, @NotNull Project project, @NotNull FileType type) {
        if (file2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(9);
        }
        if (type == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(10);
        }
        return type instanceof LanguageFileType && JSScratchFileInfoProvider.Provider.isScratchForLanguage(project, file2, type, JavaScriptSupportLoader.TYPESCRIPT);
    }

    protected boolean isApplicable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(11);
        }
        return TypeScriptUtil.isTypeScriptFile(file2);
    }

    @Override
    protected boolean isApplicablePredefinedLibraryFile(@NotNull VirtualFile predefinedLibraryFile) {
        if (predefinedLibraryFile == null) {
            TypeScriptResolveScopeProvider.$$$reportNull$$$0(12);
        }
        return this.isApplicable(predefinedLibraryFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleAndLibraryScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedLibraryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptResolveScopeProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleAndDefaultLibraryScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResolveScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "restrictByFileType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModuleAndDefaultLibraryScope";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptScratchFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isApplicablePredefinedLibraryFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

