/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flex;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTargetedInjector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.index.JSImplicitElementsIndex;
import com.intellij.lang.javascript.index.JSIndexContent;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassProvider;
import com.intellij.lang.javascript.psi.ecmal4.impl.ActionScriptClassBase;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSOffsetBasedImplicitElement;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import gnu.trove.THashMap;
import icons.JavaScriptPsiIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlBackedJSClassImpl
extends ActionScriptClassBase<JSClassStub<?>>
implements XmlBackedJSClass {
    @NonNls
    public static final String COMPONENT_TAG_NAME = "Component";
    @NonNls
    public static final String CLASS_NAME_ATTRIBUTE_NAME = "className";
    @NonNls
    public static final String SCRIPT_TAG_NAME = "Script";
    protected static final String CDATA_START = "<![CDATA[";
    protected static final String CDATA_END = "]]>";
    protected static final String IMPLEMENTS_ATTRIBUTE = "implements";
    public static final String SOURCE_ATTR = "source";
    protected volatile JSReferenceList myExtendsList;
    private volatile JSAttributeList myAttributeList;

    public XmlBackedJSClassImpl(XmlTag tag) {
        super(tag.getNode());
    }

    @Override
    @Nullable
    public JSReferenceList getExtendsList() {
        JSReferenceList refList = this.myExtendsList;
        if (refList == null && (refList = this.createReferenceList(this.getSuperClassName())) != null) {
            refList.getParent().putUserData(JSResolveUtil.contextKey, (Object)this);
            this.myExtendsList = refList;
        }
        return refList;
    }

    protected String getSuperClassName() {
        return this.getParent().getLocalName();
    }

    @Nullable
    protected JSReferenceList createReferenceList(String s) {
        if (s == null) {
            return null;
        }
        String text = "class C extends " + s + " {}";
        JSClass element = this.createDummyClass(text);
        return element != null ? element.getExtendsList() : null;
    }

    private JSClass createDummyClass(String text) {
        PsiElement psi = JSChangeUtil.createJSTreeFromText(this.getProject(), text, this.getClassLanguage()).getPsi();
        if (!(psi instanceof JSClass)) {
            return null;
        }
        JSClass element = (JSClass)psi;
        element.putUserData(JSResolveUtil.contextKey, this);
        element.getContainingFile().putUserData(JSResolveUtil.contextKey, (Object)this);
        return element;
    }

    protected JSLanguageDialect getClassLanguage() {
        return JavaScriptSupportLoader.ECMA_SCRIPT_6;
    }

    @Override
    protected Icon getBaseIcon() {
        return JavaScriptPsiIcons.Classes.XmlBackedClass;
    }

    @Override
    public int getTextOffset() {
        return 0;
    }

    @Override
    @Nullable
    public JSReferenceList getImplementsList() {
        return null;
    }

    public static boolean isImplementsAttribute(JSFile file2) {
        PsiElement context = file2.getContext();
        if (context instanceof XmlAttributeValue && IMPLEMENTS_ATTRIBUTE.equals(((XmlAttribute)context.getParent()).getName())) {
            return true;
        }
        return file2.getUserData(JSResolveUtil.contextKey) instanceof XmlBackedJSClassImpl;
    }

    public void addToImplementsList(String refText) {
        throw new UnsupportedOperationException();
    }

    public void removeFromImplementsList(String refText) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlTag xmlTag = this.getParent();
        if (xmlTag == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(0);
        }
        return xmlTag;
    }

    @Override
    public String getName() {
        PsiFile psi = this.getParent().getContainingFile().getOriginalFile();
        return FileUtilRt.getNameWithoutExtension((String)psi.getName());
    }

    @Override
    @Nullable
    public JSQualifiedName getNamespace() {
        PsiFile containingFile = this.getNode().getPsi().getContainingFile();
        String expectedPackageNameFromFile = JSResolveUtil.getExpectedPackageNameFromFile(containingFile.getOriginalFile().getVirtualFile(), containingFile.getProject());
        if (expectedPackageNameFromFile != null && !expectedPackageNameFromFile.isEmpty()) {
            return JSQualifiedNameImpl.fromQualifiedName(expectedPackageNameFromFile);
        }
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isDeprecated() {
        return ActionScriptPsiImplUtil.isDeprecatedFromAttribute(this);
    }

    @Override
    @Nullable
    public ASTNode findNameIdentifier() {
        return this.getParent().getNode();
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        int i2;
        if (name == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(1);
        }
        if ((i2 = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, i2);
        }
        ActionScriptPsiImplUtil.updateFileName(this, name, this.getName());
        return null;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        JSAttributeList attrList = this.myAttributeList;
        if (attrList == null) {
            JSClass element = this.createDummyClass("public class C {}");
            this.myAttributeList = attrList = element != null ? element.getAttributeList() : null;
        }
        return attrList;
    }

    public boolean processInjectedFiles(Processor<? super JSFile> processor) {
        List scripts = (List)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.getParent(), XmlBackedJSClassImpl::calcInjectedScripts);
        return ContainerUtil.process((List)scripts, processor);
    }

    @Override
    protected boolean processMembers(PsiScopeProcessor processor, ResolveState substitutor, PsiElement lastParent, PsiElement place) {
        boolean b = this.processInjectedFiles((Processor<? super JSFile>)((Processor)jsFile -> {
            ResolveState state2 = ResolveState.initial().put(PROCESS_XML_BACKED_CLASS_MEMBERS_HINT, (Object)Boolean.TRUE);
            return jsFile.processDeclarations(processor, state2, null, place);
        }));
        if (!b) {
            return false;
        }
        if (place instanceof JSReferenceExpression && place.getParent() instanceof JSCallExpression) {
            return true;
        }
        this.processImplicitMembers(processor);
        PsiFile xmlFile = this.getParent().getContainingFile();
        Map<String, Collection<JSImplicitElementsIndex.JSElementProxy>> implicitElements = JSIndexContent.get(xmlFile).getImplicitElements();
        for (JSImplicitElementsIndex.JSElementProxy jsElementProxy : ContainerUtil.concat(implicitElements.values())) {
            PsiElement elementAtOffset;
            XmlAttributeValue xmlAttributeValue;
            JSOffsetBasedImplicitElement implicitElement = jsElementProxy.toOffsetBasedImplicitElement(xmlFile);
            if (implicitElement.getType() != JSImplicitElement.Type.Tag || (xmlAttributeValue = (XmlAttributeValue)PsiTreeUtil.getParentOfType((PsiElement)(elementAtOffset = implicitElement.getElementAtOffset()), XmlAttributeValue.class, (boolean)false)) == null || !this.canResolveTo((XmlElement)xmlAttributeValue) || processor.execute((PsiElement)implicitElement, ResolveState.initial())) continue;
            return false;
        }
        return true;
    }

    protected void processImplicitMembers(PsiScopeProcessor processor) {
    }

    @Override
    public boolean processOuterDeclarations(PsiScopeProcessor processor) {
        return true;
    }

    @Override
    public void visitInjectedFiles(XmlBackedJSClass.InjectedFileVisitor visitor) {
        new InjectedScriptsVisitor(XmlBackedJSClassFactory.getRootTag((XmlFile)this.getContainingFile()), null, true, true, visitor, true).go();
    }

    protected boolean canResolveTo(XmlElement element) {
        return true;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState substitutor, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(2);
        }
        if (substitutor == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(3);
        }
        if (place == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(4);
        }
        boolean b = super.processDeclarations(processor, substitutor, lastParent, place);
        processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this.getParent());
        if (b && lastParent == this && ActionScriptResolveUtil.shouldProcessImports(place, processor)) {
            b = JSImportHandlingUtil.tryResolveImports(processor, this, place);
            if (!b) {
                return false;
            }
            b = this.doImportFromScripts(processor, place);
        }
        return b;
    }

    public boolean doImportFromScripts(PsiScopeProcessor processor, PsiElement place) {
        boolean notResolvingTypeViaImport;
        PsiElement context = place.getContainingFile().getContext();
        if (context instanceof XmlText) {
            context = context.getParent();
        }
        boolean bl = notResolvingTypeViaImport = !(place instanceof JSFile);
        if (context instanceof XmlAttributeValue && JSResolveUtil.getElementThatShouldBeQualified(place, null) == null || context instanceof XmlTag && (!SCRIPT_TAG_NAME.equals(((XmlTag)context).getLocalName()) || notResolvingTypeViaImport) || context == null) {
            boolean useImports = ActionScriptResolveUtil.shouldProcessImports(place, processor);
            Ref adequatePlace = new Ref((Object)false);
            if (processor instanceof ResolveProcessor && ((ResolveProcessor)processor).getName() != null && !this.resolveViaImplicitImports((ResolveProcessor)processor)) {
                return false;
            }
            boolean b = this.processInjectedFiles((Processor<? super JSFile>)((Processor)file2 -> {
                if (JSImportHandlingUtil.isAdequatePlaceForImport((PsiNamedElement)file2, place, processor)) {
                    JSImportHandler importHandler = JSDialectSpecificHandlersFactory.forElement(file2).getImportHandler();
                    if (useImports && !importHandler.importClass(processor, (PsiNamedElement)file2)) {
                        return false;
                    }
                    adequatePlace.set((Object)true);
                }
                return true;
            }));
            if (!b) {
                return false;
            }
            if (((Boolean)adequatePlace.get()).booleanValue() && processor instanceof ResolveProcessor && !this.processComponentNames((ResolveProcessor)processor)) {
                return false;
            }
        }
        return !(processor instanceof ResolveProcessor) || !ActionScriptResolveUtil.shouldProcessTopLevelGlobalContext(place, processor) || !notResolvingTypeViaImport || ActionScriptResolveUtil.processGlobalThings((ResolveProcessor)processor, ResolveState.initial(), place, this);
    }

    protected boolean resolveViaImplicitImports(ResolveProcessor processor) {
        return true;
    }

    private boolean processComponentNames(ResolveProcessor processor) {
        block5: {
            Map value;
            block3: {
                PsiElement clazz;
                block4: {
                    String s = processor.getName();
                    value = (Map)CachedValuesManager.getProjectPsiDependentCache((PsiElement)this.getParent(), XmlBackedJSClassImpl::calcComponentImports);
                    if (s == null) break block3;
                    String qName = (String)value.get(s);
                    if (qName == null) break block4;
                    PsiElement clazz2 = JSDialectSpecificHandlersFactory.forLanguage(this.getClassLanguage()).getClassResolver().findClassByQName(qName, this);
                    if (clazz2 != null) {
                        return processor.execute(clazz2, ResolveState.initial());
                    }
                    break block5;
                }
                String qualifiedNameToImport = processor.getQualifiedNameToImport();
                if (qualifiedNameToImport == null || (clazz = JSDialectSpecificHandlersFactory.forLanguage(this.getClassLanguage()).getClassResolver().findClassByQName(qualifiedNameToImport, this)) == null) break block5;
                for (String componentQName : value.values()) {
                    if (!StringUtil.getPackageName((String)componentQName).equals(StringUtil.getPackageName((String)qualifiedNameToImport)) || processor.execute(clazz, ResolveState.initial())) continue;
                    return false;
                }
                break block5;
            }
            for (String qName : value.values()) {
                PsiElement clazz = JSDialectSpecificHandlersFactory.forElement(this).getClassResolver().findClassByQName(qName, this);
                if (clazz == null || processor.execute(clazz, ResolveState.initial())) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static List<JSFile> calcInjectedScripts(XmlTag tag) {
        ArrayList<JSFile> injectedFiles = new ArrayList<JSFile>(2);
        PsiFile xmlFile = tag.getContainingFile();
        if (xmlFile instanceof XmlFile) {
            new InjectedScriptsVisitor(tag, XmlBackedJSClassProvider.forFile((XmlFile)xmlFile), false, false, (rootTag, file2) -> injectedFiles.add(file2), true).go();
        }
        ArrayList<JSFile> arrayList = injectedFiles;
        if (arrayList == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static Map<String, String> calcComponentImports(final XmlTag t) {
        THashMap cachedComponentImports = new THashMap();
        t.accept((PsiElementVisitor)new XmlRecursiveElementVisitor((Map)cachedComponentImports){
            final /* synthetic */ Map val$cachedComponentImports;
            {
                this.val$cachedComponentImports = map;
            }

            public void visitXmlTag(XmlTag tag) {
                if (tag != t && XmlBackedJSClassImpl.isComponentTag(tag)) {
                    return;
                }
                XmlElementDescriptor descriptor2 = tag.getDescriptor();
                if (descriptor2 != null) {
                    PsiElement declaration = descriptor2.getDeclaration();
                    if (declaration instanceof XmlFile) {
                        declaration = XmlBackedJSClassFactory.getXmlBackedClass((XmlFile)declaration);
                    }
                    if (declaration instanceof JSClass) {
                        JSClass jsClass = (JSClass)declaration;
                        this.val$cachedComponentImports.put(jsClass.getName(), jsClass.getQualifiedName());
                    }
                }
                super.visitXmlTag(tag);
            }
        });
        THashMap tHashMap = cachedComponentImports;
        if (tHashMap == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(6);
        }
        return tHashMap;
    }

    public boolean isValid() {
        return this.getNode().getPsi().isValid();
    }

    public static Collection<JSClass> getClasses(XmlFile file2) {
        XmlTag rootTag = XmlBackedJSClassFactory.getRootTag(file2);
        if (rootTag == null) {
            return Collections.emptyList();
        }
        ArrayList<JSClass> result2 = new ArrayList<JSClass>();
        result2.add(XmlBackedJSClassFactory.getInstance().getXmlBackedClass(rootTag));
        XmlBackedJSClassProvider provider = XmlBackedJSClassProvider.forFile(file2);
        if (provider != null) {
            result2.addAll(provider.getChildClasses(file2));
        }
        return result2;
    }

    @Nullable
    public static XmlBackedJSClass getContainingComponent(XmlElement element) {
        if (element instanceof XmlTag && XmlBackedJSClassImpl.isComponentTag((XmlTag)element)) {
            XmlTag[] subtags = ((XmlTag)element).getSubTags();
            return subtags.length > 0 ? XmlBackedJSClassFactory.getInstance().getXmlBackedClass(subtags[0]) : null;
        }
        XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class);
        if (parentTag != null) {
            return XmlBackedJSClassImpl.getContainingComponent((XmlElement)parentTag);
        }
        if (element instanceof XmlFile) {
            XmlDocument document2 = ((XmlFile)element).getDocument();
            XmlTag xmlTag = element = document2 != null ? document2.getRootTag() : null;
        }
        if (!(element instanceof XmlTag)) {
            return null;
        }
        return XmlBackedJSClassFactory.getInstance().getXmlBackedClass((XmlTag)element);
    }

    public XmlTag getParent() {
        return (XmlTag)this.getNode().getPsi();
    }

    public boolean isPhysical() {
        return false;
    }

    public boolean isEquivalentTo(PsiElement element2) {
        return this == element2 || element2 == this.getContainingFile().getOriginalFile() || element2 instanceof XmlBackedJSClassImpl && this.getContainingFile().getOriginalFile() == element2.getContainingFile().getOriginalFile();
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        JSFile jsFile;
        if (element == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(7);
        }
        if ((element instanceof JSFunction || element instanceof JSVarStatement) && (jsFile = this.createOrGetFirstScriptTag()) != null) {
            String text;
            PsiElement child = jsFile.getLastChild();
            if (child instanceof PsiWhiteSpace && (text = child.getText()).contains(CDATA_END)) {
                String marker = CDATA_START;
                int cdataAt = text.indexOf(marker);
                if (cdataAt == -1) {
                    element = jsFile.addBefore(element, child);
                } else {
                    int markerEnd = cdataAt + marker.length();
                    ASTNode fromText = JSChangeUtil.createJSTreeFromText(this.getProject(), text.substring(0, markerEnd) + element.getText() + text.substring(markerEnd), (JSLanguageDialect)element.getContainingFile().getLanguage());
                    jsFile.getNode().replaceAllChildrenToChildrenOf(fromText.getTreeParent());
                    element = PsiTreeUtil.getParentOfType((PsiElement)jsFile.findElementAt(markerEnd + 1), element.getClass());
                }
            } else {
                element = jsFile.add(element);
            }
            CodeStyleManager.getInstance((Project)this.getProject()).reformatNewlyAddedElement((ASTNode)jsFile.getNode(), element.getNode());
            return element;
        }
        return super.add(element);
    }

    public JSFile createScriptTag() throws IncorrectOperationException {
        throw new IncorrectOperationException();
    }

    @Override
    public PsiElement addBefore(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(8);
        }
        if (anchor == null) {
            return this.add(element);
        }
        return anchor.getParent().addBefore(element, anchor);
    }

    @Override
    public PsiElement addAfter(@NotNull PsiElement element, PsiElement anchor) throws IncorrectOperationException {
        if (element == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(9);
        }
        if (anchor == null) {
            return this.add(element);
        }
        return anchor.getParent().addAfter(element, anchor);
    }

    @Nullable
    public JSFile findFirstScriptTag() {
        Ref result2 = new Ref();
        this.processInjectedFiles((Processor<? super JSFile>)((Processor)jsFile -> {
            result2.set(jsFile);
            return false;
        }));
        return (JSFile)result2.get();
    }

    public JSFile createOrGetFirstScriptTag() throws IncorrectOperationException {
        JSFile jsFile = this.findFirstScriptTag();
        if (jsFile == null) {
            jsFile = this.createScriptTag();
        }
        return jsFile;
    }

    public static boolean isComponentTag(XmlTag tag) {
        return COMPONENT_TAG_NAME.equals(tag.getLocalName()) && JavaScriptSupportLoader.isLanguageNamespace(tag.getNamespace()) && !(tag.getParent() instanceof XmlDocument);
    }

    protected static boolean isInsideTag(XmlTag tag, Condition<? super XmlTag> tagCondition) {
        if (tag == null) {
            return false;
        }
        XmlTag parent = tag;
        while ((parent = parent.getParentTag()) != null) {
            if (!tagCondition.value((Object)parent)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    static void syncInjectedFiles(@NotNull XmlFile file2) {
        XmlBackedJSClass jsClass;
        if (file2 == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(10);
        }
        if ((jsClass = XmlBackedJSClassFactory.getXmlBackedClass(file2)) != null) {
            jsClass.visitInjectedFiles((rootTag, file1) -> {});
        }
    }

    static void getLanguagesToInjectStatic(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        if (registrar == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(11);
        }
        if (host == null) {
            XmlBackedJSClassImpl.$$$reportNull$$$0(12);
        }
        for (MultiHostInjector injector2 : MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)host.getProject())) {
            if (!(injector2 instanceof JSTargetedInjector)) continue;
            injector2.getLanguagesToInject(registrar, host);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInjectedScripts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcComponentImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addBefore";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addAfter";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "syncInjectedFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInjectStatic";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class InjectedScriptsVisitor
    implements PsiElementProcessor {
        private final XmlBackedJSClassProvider myProvider;
        private final boolean myVisitAttributes;
        private final XmlTag myRootTag;
        private final boolean myVisitInnerComponents;
        private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
        private final Processor<? super XmlTag> myXmlTagProcessor;
        private final boolean myIsPhysical;

        public InjectedScriptsVisitor(XmlTag rootTag, @Nullable XmlBackedJSClassProvider provider, boolean visitAttributes, boolean visitInnerComponents, XmlBackedJSClass.InjectedFileVisitor visitor, Processor<? super XmlTag> processor, boolean physical) {
            this.myProvider = provider;
            this.myVisitAttributes = visitAttributes;
            this.myRootTag = rootTag;
            this.myVisitInnerComponents = visitInnerComponents;
            this.myVisitor = visitor;
            this.myXmlTagProcessor = processor;
            this.myIsPhysical = physical;
        }

        public InjectedScriptsVisitor(XmlTag rootTag, @Nullable XmlBackedJSClassProvider provider, boolean visitAttributes, boolean visitInnerComponents, XmlBackedJSClass.InjectedFileVisitor visitor, boolean physical) {
            this(rootTag, provider, visitAttributes, visitInnerComponents, visitor, new InjectingProcessor(visitor, rootTag, physical), physical);
        }

        public void go() {
            this.execute((PsiElement)this.myRootTag);
        }

        public boolean execute(@NotNull PsiElement element) {
            XmlAttributeValue value;
            if (element == null) {
                InjectedScriptsVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof XmlTag) {
                XmlTag tag = (XmlTag)element;
                if (this.myProvider == null || this.myProvider.isScriptTag(tag)) {
                    XmlAttribute src = tag.getAttribute(XmlBackedJSClassImpl.SOURCE_ATTR);
                    if (src != null) {
                        PsiFile file2;
                        if (this.myIsPhysical && (file2 = FileReferenceUtil.findFile((PsiElement)src.getValueElement())) instanceof JSFile) {
                            file2.putUserData(JSResolveUtil.contextKey, (Object)tag);
                            this.myVisitor.visit(this.myRootTag, (JSFile)file2);
                        }
                    } else {
                        this.myXmlTagProcessor.process((Object)tag);
                    }
                }
                if (XmlBackedJSClassImpl.isComponentTag(tag)) {
                    if (this.myVisitInnerComponents) {
                        new InjectedScriptsVisitor(tag, this.myProvider, this.myVisitAttributes, true, this.myVisitor, this.myXmlTagProcessor, this.myIsPhysical).goFromChildren();
                    }
                } else {
                    tag.processElements((PsiElementProcessor)this, null);
                }
            }
            if (this.myVisitAttributes && element instanceof XmlAttribute && (value = ((XmlAttribute)element).getValueElement()) != null) {
                if (this.myIsPhysical) {
                    InjectedLanguageManager manager2 = InjectedLanguageManager.getInstance((Project)value.getProject());
                    manager2.enumerate((PsiElement)value, (injectedPsi, places) -> {
                        if (((PsiLanguageInjectionHost.Shred)places.get(0)).getHost() instanceof XmlAttributeValue && injectedPsi instanceof JSFile) {
                            this.myVisitor.visit(this.myRootTag, (JSFile)injectedPsi);
                        }
                    });
                } else {
                    XmlBackedJSClassImpl.getLanguagesToInjectStatic(new MyRegistrar(this.myRootTag, this.myVisitor), (PsiElement)value);
                }
            }
            return true;
        }

        private void goFromChildren() {
            this.myRootTag.processElements((PsiElementProcessor)this, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor", "execute"));
        }

        public static class MyRegistrar
        implements MultiHostRegistrar {
            private boolean myIsECMAScript;
            private final XmlTag myRootTag;
            private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
            private StringBuilder myOutChars;
            private PsiLanguageInjectionHost myHost;

            public MyRegistrar(XmlTag rootTag, XmlBackedJSClass.InjectedFileVisitor visitor) {
                this.myRootTag = rootTag;
                this.myVisitor = visitor;
            }

            @NotNull
            public MultiHostRegistrar startInjecting(@NotNull Language language) {
                if (language == null) {
                    MyRegistrar.$$$reportNull$$$0(0);
                }
                this.myIsECMAScript = language.isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                this.myOutChars = new StringBuilder();
                MyRegistrar myRegistrar = this;
                if (myRegistrar == null) {
                    MyRegistrar.$$$reportNull$$$0(1);
                }
                return myRegistrar;
            }

            @NotNull
            public MultiHostRegistrar addPlace(@NonNls @Nullable String prefix, @NonNls @Nullable String suffix, @NotNull PsiLanguageInjectionHost host, @NotNull TextRange rangeInsideHost) {
                if (host == null) {
                    MyRegistrar.$$$reportNull$$$0(2);
                }
                if (rangeInsideHost == null) {
                    MyRegistrar.$$$reportNull$$$0(3);
                }
                this.myHost = host;
                if (!this.myIsECMAScript) {
                    MyRegistrar myRegistrar = this;
                    if (myRegistrar == null) {
                        MyRegistrar.$$$reportNull$$$0(4);
                    }
                    return myRegistrar;
                }
                TextRange hostTextRange = host.getTextRange();
                if (!hostTextRange.contains(rangeInsideHost.shiftRight(hostTextRange.getStartOffset()))) {
                    throw new IllegalArgumentException("rangeInsideHost must lie within host text range. rangeInsideHost:" + rangeInsideHost + "; host textRange:" + hostTextRange);
                }
                if (prefix == null) {
                    prefix = "";
                }
                if (suffix == null) {
                    suffix = "";
                }
                this.myOutChars.append(prefix);
                LiteralTextEscaper textEscaper = host.createLiteralTextEscaper();
                TextRange relevantRange = textEscaper.getRelevantTextRange().intersection(rangeInsideHost);
                if (relevantRange != null) {
                    textEscaper.decode(relevantRange, this.myOutChars);
                }
                this.myOutChars.append(suffix);
                MyRegistrar myRegistrar = this;
                if (myRegistrar == null) {
                    MyRegistrar.$$$reportNull$$$0(5);
                }
                return myRegistrar;
            }

            public void doneInjecting() {
                this.myIsECMAScript = false;
                if (StringUtil.isNotEmpty((String)this.myOutChars.toString())) {
                    ASTNode node = JSChangeUtil.createJSTreeFromText(this.myRootTag.getProject(), this.myOutChars.toString(), JavaScriptSupportLoader.ECMA_SCRIPT_L4);
                    PsiFile file2 = node.getPsi().getContainingFile();
                    file2.putUserData(FileContextUtil.INJECTED_IN_ELEMENT, (Object)SmartPointerManager.getInstance((Project)file2.getProject()).createSmartPsiElementPointer((PsiElement)this.myHost));
                    if (file2 instanceof JSFile) {
                        this.myVisitor.visit(this.myRootTag, (JSFile)file2);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "language";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "host";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "rangeInsideHost";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/flex/XmlBackedJSClassImpl$InjectedScriptsVisitor$MyRegistrar";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startInjecting";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "addPlace";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "startInjecting";
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "addPlace";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 5: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }

        public static class InjectingProcessor
        implements Processor<XmlTag> {
            private final XmlBackedJSClass.InjectedFileVisitor myVisitor;
            private final XmlTag myRootTag;
            private final boolean myPhysical;

            public InjectingProcessor(XmlBackedJSClass.InjectedFileVisitor visitor, XmlTag rootTag, boolean isPhysical) {
                this.myVisitor = visitor;
                this.myRootTag = rootTag;
                this.myPhysical = isPhysical;
            }

            public boolean process(XmlTag tag) {
                if (this.myPhysical) {
                    JSResolveUtil.processInjectedFileForTag(tag, new JSResolveUtil.JSInjectedFilesVisitor(){

                        @Override
                        protected void process(JSFile file2) {
                            myVisitor.visit(myRootTag, file2);
                        }
                    });
                } else {
                    for (XmlTagChild child : tag.getValue().getChildren()) {
                        if (!(child instanceof XmlText)) continue;
                        XmlBackedJSClassImpl.getLanguagesToInjectStatic(new MyRegistrar(this.myRootTag, this.myVisitor), (PsiElement)child);
                    }
                }
                return true;
            }
        }
    }
}

