/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.flow.FlowJSAnnotation;
import com.intellij.lang.javascript.flow.FlowJSErrorInspection;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FlowJSCoverageInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FlowJSCoverageInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(){

            public void visitFile(@NotNull PsiFile file2) {
                VirtualFile virtualFile;
                Document document2;
                FlowJSServerService serverService;
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((serverService = FlowJSServerManager.getService(file2)) == null) {
                    return;
                }
                if (!FlowJSAnnotation.hasFlowAnnotation(file2)) {
                    return;
                }
                List<JSAnnotationError> errors = serverService.getCoverageOfFile(file2);
                if (!errors.isEmpty() && (document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2)) != null && (virtualFile = file2.getVirtualFile()) != null) {
                    FlowJSErrorInspection.reportErrors(errors, file2, document2, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection$1", "visitFile"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/flow/FlowJSCoverageInspection", "buildVisitor"));
    }
}

