/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.formatter.JSCodeStyleConfigurable;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSIndentOptionsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    public static final int[] ALIGN_OBJECT_PROPERTIES_VALUES = new int[]{0, 2, 1};
    public static final String[] ALIGN_OBJECT_PROPERTIES_OPTIONS = new String[]{JavaScriptBundle.message("js.align.properties.none", new Object[0]), JavaScriptBundle.message("js.align.properties.on.colon", new Object[0]), JavaScriptBundle.message("js.align.properties.on.value", new Object[0])};
    public static final int[] ALIGN_VAR_STATEMENT_VALUES = new int[]{0, 1, 2};
    public static final String[] ALIGN_VAR_STATEMENT_OPTIONS = new String[]{JavaScriptBundle.message("js.code.style.do.not.align.var.statement", new Object[0]), JavaScriptBundle.message("js.code.style.align.var.statements", new Object[0]), JavaScriptBundle.message("js.code.style.align.var.statements.and.assignments", new Object[0])};
    public static final String[] STANDARD_SPACING_OPTIONS = new String[]{"SPACE_AFTER_COLON", "SPACE_AFTER_COMMA", "SPACE_AFTER_QUEST", "SPACE_AROUND_ADDITIVE_OPERATORS", "SPACE_AROUND_ASSIGNMENT_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_BITWISE_OPERATORS", "SPACE_AROUND_EQUALITY_OPERATORS", "SPACE_AROUND_LOGICAL_OPERATORS", "SPACE_AROUND_MULTIPLICATIVE_OPERATORS", "SPACE_AROUND_RELATIONAL_OPERATORS", "SPACE_BEFORE_CATCH_LBRACE", "SPACE_BEFORE_COLON", "SPACE_BEFORE_COMMA", "SPACE_BEFORE_ELSE_LBRACE", "SPACE_BEFORE_FINALLY_LBRACE", "SPACE_BEFORE_FOR_LBRACE", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_BEFORE_IF_LBRACE", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_LBRACE", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_BEFORE_QUEST", "SPACE_BEFORE_SEMICOLON", "SPACE_BEFORE_SWITCH_LBRACE", "SPACE_BEFORE_SWITCH_PARENTHESES", "SPACE_BEFORE_TRY_LBRACE", "SPACE_BEFORE_TYPE", "SPACE_BEFORE_WHILE_LBRACE", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_WITHIN_CATCH_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_WITHIN_SWITCH_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_WITHIN_PARENTHESES", "SPACE_WITHIN_BRACKETS", "SPACE_BEFORE_CATCH_PARENTHESES", "SPACE_AROUND_SHIFT_OPERATORS", "SPACE_AROUND_UNARY_OPERATOR", "SPACE_BEFORE_DO_LBRACE", "SPACE_BEFORE_WHILE_KEYWORD", "SPACE_BEFORE_ELSE_KEYWORD", "SPACE_BEFORE_CATCH_KEYWORD", "SPACE_BEFORE_FINALLY_KEYWORD"};
    public static final String[] STANDARD_BLANK_LINES_OPTIONS = new String[]{"KEEP_BLANK_LINES_IN_CODE", "BLANK_LINES_AFTER_IMPORTS", "BLANK_LINES_AROUND_FIELD", "BLANK_LINES_AROUND_METHOD", "BLANK_LINES_AROUND_CLASS"};
    public static final String[] STANDARD_WRAPPING_OPTIONS = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING", "KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT", "KEEP_SIMPLE_BLOCKS_IN_ONE_LINE", "KEEP_SIMPLE_METHODS_IN_ONE_LINE", "BRACE_STYLE", "METHOD_BRACE_STYLE", "METHOD_PARAMETERS_WRAP", "METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE", "METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS", "CALL_PARAMETERS_WRAP", "CALL_PARAMETERS_LPAREN_ON_NEXT_LINE", "CALL_PARAMETERS_RPAREN_ON_NEXT_LINE", "ALIGN_MULTILINE_PARAMETERS_IN_CALLS", "METHOD_CALL_CHAIN_WRAP", "ALIGN_MULTILINE_CHAINED_METHODS", "PREFER_PARAMETERS_WRAP", "IF_BRACE_FORCE", "ELSE_ON_NEW_LINE", "FOR_STATEMENT_WRAP", "ALIGN_MULTILINE_FOR", "FOR_STATEMENT_LPAREN_ON_NEXT_LINE", "FOR_STATEMENT_RPAREN_ON_NEXT_LINE", "FOR_BRACE_FORCE", "WHILE_BRACE_FORCE", "DOWHILE_BRACE_FORCE", "WHILE_ON_NEW_LINE", "INDENT_CASE_FROM_SWITCH", "CATCH_ON_NEW_LINE", "BINARY_OPERATION_WRAP", "BINARY_OPERATION_SIGN_ON_NEXT_LINE", "ALIGN_MULTILINE_BINARY_OPERATION", "PARENTHESES_EXPRESSION_LPAREN_WRAP", "PARENTHESES_EXPRESSION_RPAREN_WRAP", "ASSIGNMENT_WRAP", "PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE", "ALIGN_MULTILINE_TERNARY_OPERATION", "TERNARY_OPERATION_WRAP", "TERNARY_OPERATION_SIGNS_ON_NEXT_LINE", "ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION", "ARRAY_INITIALIZER_WRAP", "ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", "ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", "SPECIAL_ELSE_IF_TREATMENT", "FINALLY_ON_NEW_LINE", "WRAP_COMMENTS", "EXTENDS_LIST_WRAP", "ALIGN_MULTILINE_EXTENDS_LIST", "EXTENDS_KEYWORD_WRAP", "CLASS_BRACE_STYLE"};
    public static final String GENERAL_CODE_SAMPLE = "import {Component} from 'react'\n\nfunction foo(){\n  ct(a,b)\n\n\n  c0=c0+1\n   if (c0 >= 2)cl0.left=-100\n  TC=TC+1\n  if (Fm >= Fl){Fm=Fl}\n  while (TC != Bl){Bo+=1;x++}\n  if (Bo >= 1){\n   x=x-5\n   if (x >= 0){\n    if (s!=\"C\") return\n   }\n   if (x == 0){\n    if (x <= 0){\n     if (s!=\"C\"){\n      x=1\n     }else{\n      x=10\n     }\n    }\n   }\n   x=0\n   for (x1=0; x1<10; x1++) if (EX[x1] >= -50){x=1}\n   if (x == 0) B(\"a\",\"b\")\n  }\n}";
    public static final String WRAPPING_CODE_SAMPLE = "import {Component} from 'react'\nimport {Rx} from 'rxjs/Observable'\nimport {property1, property2, property3} from './myModule.js'\n\nclass Foo extends BarComponent implements BazService, QuuxProvider {\n}\n\nfunction buzz() { return 0; }\nvar x = 1, y = 2, foregroundColor = 'transparent', highlightColor = 'lime', font = 'Arial';\n/*\n Multiline\n   C-style\n     Comment\n */\nvar myLink  = {img: \"btn.gif\"},\n    local   = true,\n    initial = -1;\nwidth = 400\nheight = 300\n\nvar foo = {\n    numbers:['one', 'two', 'three', 'four', 'five', 'six'],\n    data : {a:{id: 123, type: \"String\", isAvailable: true},\nb:{id: 456, type:\"Int\"}},\n// fBar : function (x,y);\n    fOne:function(a, b, c, d, e, f, g, h) {\n        var x = a + b + c + d + e + f + g + h;\n        fTwo(a, b, c, fThree(d, e, f, g, h));\n        var z = a == 'Some string' ? 'yes' : 'no';\n        z = a == 10 ? 'yes' : 'no';\n        var colors = ['red', 'green', 'blue', 'black', 'white', 'gray'];\n        for (j = 0; j < 2; j ++) i = a;        for (var i = 0; i < colors.length; i++)\n             var colorString = this.numbers[i];\n    },\n\n chainedCallSample: function(a,b,c,d,e,f) {\n        chainRoot.firstCall(a,b,c,d,e,f,g).secondCall(a,b,c,d).thirdCall(a,b,c,d).fourthCall().q(a).r(a,b).s();\n        chainRoot.x().y()\n        .z();     },\n callArgumentsSample: function () {\n    this.fTwo(\"one\", \"two\", \"three\", \"four\");\n    this.fThree({\n      strA: 'a',\n      strB: 'b',\n      strC: 'c',\n      strD: 'd'\n    }, 'strE');\n    [1, 2, 3].reduce(function (previousValue, currentValue) {\n      return previousValue + currentValue;\n    }, 10);\n  },\n    /**\n     * Function JSDoc. Long lines can be wrapped with 'Comments'/'Wrap at right margin' option\n     * @param {string} a Parameter A description.\n     * @param {string} b Parameter B description. Can extend beyond the right margin.\n     */\n    fTwo:function(a, b, c, d) {\n        foo(a, b, c, d); // Line comment which can be wrapped if long.\n        if (true)\n            return c;\n        if (a == 'one' && (b == 'two' || c == 'three')) {\n            return a + b + c + d;\n        } else return strD;\n        if (a == 'one') {\n            return 1;\n        }\n        else if(a == 'two') {\n            return 2;\n        }\n        var number = -10;\n        while (x < 0) {\n            number = number + 1;\n        }\n        do {\n            number = number + 1;\n        } while (number < 10);\n        return d;\n    },\n\n    fThree:function({strA, strB, strC, strD}, strE) {\n        var number = prompt(\"Enter a number:\", 0);\n        switch (number) {\n            case 0 :\n                alert(\"Zero\");\n                break;\n            case 1:\n                alert(\"One\");\n                break;\n        }\n        try {\n            a[2]= 10;\n        }\n        catch(e) {\n            alert(\"Failure: \" + e.message);\n        }\n        return strA + strB + strC + strD + strE;\n    }\n};";
    public static final String BLANK_LINES_CODE_SAMPLE = "/**\n * This is a sample file\n */\nimport {Component} from 'React'\nimport {add, subtract} from 'utils';\nclass Foo {\n    field1 = 1;\n    field2 = 2;\n    foo() {\n        console.log('foo')\n    }\n    static bar() {\n        function hello(n) {\n            console.log('hello ' + n)\n        }\n        var x = 1;\n\n\n        while (x < 10) {\n            hello(x)\n        }\n    }\n}";
    private static final String ES6_SPACING_CODE_SAMPLE = "import {Component} from 'react'\nexport class Greeter {\n    greetNTimes(to, {from, times}) {\n        return range(times).map(item => this.greet(to, from))\n    }\n}\n\nexport class ConsoleGreeter extends Greeter {\n    greet(to, from) {\n        return `Hello, ${to} from ${from.join(',')}`\n    }\n}\n\nexport class ReactGreeter extends Greeter {\n    greet(to, from) {\n        return (<div className=\"greeting\">\n            Hello, {to} from\n            {from.map(name => <Name>{name}</Name>)}\n        </div>)\n    }\n}\n\nnew ConsoleGreeter().greetNTimes('World', {name: ['Webstorm'], times: 3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n";
    public static final String SIMPLE_SPACING_CODE_SAMPLE = "function foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}";
    public static final String INDENTS_CODE_SAMPLE = "foo(\n        \"demo\",\n        {\n            title:\"Demo\",\n            width:100\n        },\n        function() {\n            object.firstCall({\n            a:'a',\n            b:'b'})\n            .secondCall();\n        }\n);";

    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(0);
        }
        return javascriptLanguage;
    }

    @Nullable
    public PsiFile createFileFromText(Project project, String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("dummy", (Language)JavaScriptSupportLoader.ECMA_SCRIPT_6, (CharSequence)text, false, false);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(1);
        }
        switch (settingsType) {
            case WRAPPING_AND_BRACES_SETTINGS: {
                return WRAPPING_CODE_SAMPLE;
            }
            case BLANK_LINES_SETTINGS: {
                return BLANK_LINES_CODE_SAMPLE;
            }
            case SPACING_SETTINGS: {
                return "import {Component} from 'react'\nexport class Greeter {\n    greetNTimes(to, {from, times}) {\n        return range(times).map(item => this.greet(to, from))\n    }\n}\n\nexport class ConsoleGreeter extends Greeter {\n    greet(to, from) {\n        return `Hello, ${to} from ${from.join(',')}`\n    }\n}\n\nexport class ReactGreeter extends Greeter {\n    greet(to, from) {\n        return (<div className=\"greeting\">\n            Hello, {to} from\n            {from.map(name => <Name>{name}</Name>)}\n        </div>)\n    }\n}\n\nnew ConsoleGreeter().greetNTimes('World', {name: ['Webstorm'], times: 3})\nfunction *fibonacci(current = 1, next = 1) {\n    yield current;\n    yield *fibonacci(next, current + next);\n}\n\nlet [first, second, ...rest] = take(fibonacci(), 10)\n\nfunction foo(x,y,z) {\n    var i = 0;\n    var x = {0:\"zero\",1:\"one\"};\n    var a = [0,1,2];\n    var foo = function () {}\n    var asyncFoo = async (x, y, z) => { }\n    var v = x.map( s => s.length );\n    if (!i > 10) {\n        for (var j = 0; j < 10; j++) {\n            switch (j) {\n                case 0:\n                    value = \"zero\";\n                    break;\n                case 1:\n                    value = \"one\";\n                    break;\n            }\n            var c = j > 5 ? \"GT 5\" : \"LE 5\";\n        }\n    } else {\n        var j = 0;\n        try {\n            while (j < 10) {\n                if (i == j || j > 5) {\n                    a[j] = i + j * 12;\n                }\n                i = (j << 2) & 4;\n                j++;\n            }\n            do {\n                j--;\n            } while (j > 0)\n        } catch (e) {\n            alert(\"Failure: \" + e.message);\n        } finally {\n            reset(a,i);\n        }\n    }\n}";
            }
            case INDENT_SETTINGS: {
                return INDENTS_CODE_SAMPLE;
            }
        }
        return GENERAL_CODE_SAMPLE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(2);
        }
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(3);
        }
        JSLanguageCodeStyleSettingsProvider.addJSOrTSCommonSettings(consumer, JSCodeStyleSettings.class, settingsType);
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_CLASS_LBRACE", JavaScriptBundle.message("space.before.class.lbrace", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_LEFT_BRACE, new Object[0]);
        }
        JSLanguageCodeStyleSettingsProvider.addFlowSpecificSettings(consumer, settingsType);
    }

    public static void addJSOrTSCommonSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull Class<? extends JSCodeStyleSettings> settingsClass, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(4);
        }
        if (settingsClass == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(5);
        }
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(6);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(STANDARD_SPACING_OPTIONS);
            consumer.showCustomOption(settingsClass, "SPACE_BEFORE_PROPERTY_COLON", JavaScriptBundle.message("space.before.name.value.separator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_AFTER_PROPERTY_COLON", JavaScriptBundle.message("space.after.name.value.separator", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_AFTER_DOTS_IN_REST_PARAMETER", JavaScriptBundle.message("space.after.dots.in.rest.spread", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_BEFORE_GENERATOR_MULT", JavaScriptBundle.message("space.before.generator.mult", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_AFTER_GENERATOR_MULT", JavaScriptBundle.message("space.after.generator.mult", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_OTHER, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_BEFORE_FUNCTION_LEFT_PARENTH", JavaScriptBundle.message("space.before.function.left.parenth", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACES_WITHIN_OBJECT_LITERAL_BRACES", JavaScriptBundle.message("spaces.within.object.literal.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACES_WITHIN_IMPORTS", JavaScriptBundle.message("spaces.within.import.braces", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_WITHIN_ARRAY_INITIALIZER_BRACKETS", JavaScriptBundle.message("spaces.within.array.initializer", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
            consumer.renameStandardOption("SPACE_WITHIN_BRACKETS", JavaScriptBundle.message("spaces.within.indexer.brackets", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", JavaScriptBundle.message("js.function.call.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", JavaScriptBundle.message("js.function.declaration.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", JavaScriptBundle.message("js.function.call.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", JavaScriptBundle.message("js.function.declaration.parentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_LBRACE", JavaScriptBundle.message("js.space.before.function.left.brace", new Object[0]));
            consumer.renameStandardOption("SPACE_AROUND_UNARY_OPERATOR", JavaScriptBundle.message("spaces.within.unary.additive", new Object[0]));
            consumer.showCustomOption(settingsClass, "SPACE_AROUND_ARROW_FUNCTION_OPERATOR", JavaScriptBundle.message("spaces.arrow.function", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_BEFORE_UNARY_NOT", JavaScriptBundle.message("spaces.before.unary.not", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_AFTER_UNARY_NOT", JavaScriptBundle.message("spaces.after.unary.not", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_AROUND_OPERATORS, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACE_BEFORE_ASYNC_ARROW_LPAREN", JavaScriptBundle.message("spaces.async.arrow.function", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_BEFORE_PARENTHESES, new Object[0]);
            consumer.showCustomOption(settingsClass, "SPACES_WITHIN_INTERPOLATION_EXPRESSIONS", JavaScriptBundle.message("spaces.within.interpolation.expressions", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().SPACES_WITHIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_BLANK_LINES_OPTIONS);
            consumer.renameStandardOption("BLANK_LINES_AROUND_METHOD", JavaScriptBundle.message("js.blank.lines.around.method", new Object[0]));
            consumer.showCustomOption(settingsClass, "BLANK_LINES_AROUND_FUNCTION", JavaScriptBundle.message("js.blank.lines.around.function", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(STANDARD_WRAPPING_OPTIONS);
            consumer.renameStandardOption("ARRAY_INITIALIZER_WRAP", JavaScriptBundle.message("js.code.style.array.group.name", new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE", JavaScriptBundle.message("js.array.new.line.after.left.bracket", new Object[0]));
            consumer.renameStandardOption("ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE", JavaScriptBundle.message("js.array.new.line.before.right.bracket", new Object[0]));
            consumer.renameStandardOption("METHOD_BRACE_STYLE", JavaScriptBundle.message("js.function.brace.style", new Object[0]));
            consumer.showCustomOption(settingsClass, "FUNCTION_EXPRESSION_BRACE_STYLE", JavaScriptBundle.message("js.function.expression.brace.style", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_BRACES, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "METHOD_BRACE_STYLE", new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().BRACE_PLACEMENT_OPTIONS, CodeStyleSettingsCustomizable.BRACE_PLACEMENT_VALUES});
            consumer.renameStandardOption("METHOD_PARAMETERS_WRAP", JavaScriptBundle.message("js.function.parameters.wrap", new Object[0]));
            consumer.renameStandardOption("CALL_PARAMETERS_WRAP", JavaScriptBundle.message("js.function.call.wrap", new Object[0]));
            consumer.renameStandardOption("EXTENDS_LIST_WRAP", JavaScriptBundle.message("js.extends.list.wrap", new Object[0]));
            consumer.renameStandardOption("ALIGN_MULTILINE_EXTENDS_LIST", JavaScriptBundle.message("js.align.multiline.extends.list", new Object[0]));
            consumer.renameStandardOption("EXTENDS_KEYWORD_WRAP", JavaScriptBundle.message("js.extends.keyword.wrap", new Object[0]));
            consumer.showCustomOption(settingsClass, "REFORMAT_C_STYLE_COMMENTS", JavaScriptBundle.message("js.format.cstyle.comments", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_COMMENTS, new Object[0]);
            consumer.showCustomOption(settingsClass, "OBJECT_LITERAL_WRAP", JavaScriptBundle.message("js.code.style.object.literals.category.name", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(settingsClass, "ALIGN_OBJECT_PROPERTIES", JavaScriptBundle.message("js.code.style.align.caption", new Object[0]), JavaScriptBundle.message("js.code.style.object.literals.category.name", new Object[0]), new Object[]{ALIGN_OBJECT_PROPERTIES_OPTIONS, ALIGN_OBJECT_PROPERTIES_VALUES});
            consumer.showCustomOption(settingsClass, "VAR_DECLARATION_WRAP", JavaScriptBundle.message("js.wrap.settings.var.group.name", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(settingsClass, "ALIGN_VAR_STATEMENTS", JavaScriptBundle.message("js.code.style.align.caption", new Object[0]), JavaScriptBundle.message("js.wrap.settings.var.group.name", new Object[0]), new Object[]{ALIGN_VAR_STATEMENT_OPTIONS, ALIGN_VAR_STATEMENT_VALUES});
            consumer.showCustomOption(settingsClass, "IMPORTS_WRAP", JavaScriptBundle.message("js.wrap.settings.import", new Object[0]), null, new Object[]{CodeStyleSettingsCustomizableOptions.getInstance().WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES});
            consumer.showCustomOption(settingsClass, "ALIGN_IMPORTS", JavaScriptBundle.message("js.code.style.align.from.clause.caption", new Object[0]), JavaScriptBundle.message("js.wrap.settings.import", new Object[0]), new Object[0]);
            consumer.showCustomOption(settingsClass, "CHAINED_CALL_DOT_ON_NEW_LINE", JavaScriptBundle.message("js.chained.call.dot.on.next.line", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_CALL_CHAIN, new Object[0]);
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.COMMENTER_SETTINGS) {
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_AT_FIRST_COLUMN"});
            consumer.showStandardOptions(new String[]{"LINE_COMMENT_ADD_SPACE"});
        }
    }

    private static void addFlowSpecificSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (consumer == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(7);
        }
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(8);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_BEFORE_TYPE_COLON", JavaScriptBundle.message("space.before.type.colon", new Object[0]), JSLanguageCodeStyleSettingsProvider.getFlowCategoryName(), new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACE_AFTER_TYPE_COLON", JavaScriptBundle.message("space.after.type.colon", new Object[0]), JSLanguageCodeStyleSettingsProvider.getFlowCategoryName(), new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_OBJECT_TYPE_BRACES", JavaScriptBundle.message("spaces.within.object.type.braces", new Object[0]), JSLanguageCodeStyleSettingsProvider.getFlowCategoryName(), new Object[0]);
            consumer.showCustomOption(JSCodeStyleSettings.class, "SPACES_WITHIN_UNION_TYPES", JavaScriptBundle.message("js.wrap.settings.union.and.intersection.types", new Object[0]), JSLanguageCodeStyleSettingsProvider.getFlowCategoryName(), new Object[0]);
        }
    }

    protected void customizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(9);
        }
        if (indentOptions == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(10);
        }
        JSLanguageCodeStyleSettingsProvider.doCustomizeDefaults(commonSettings, indentOptions);
    }

    public static void doCustomizeDefaults(@NotNull CommonCodeStyleSettings commonSettings, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        if (commonSettings == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(11);
        }
        if (indentOptions == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(12);
        }
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        commonSettings.LINE_COMMENT_AT_FIRST_COLUMN = false;
        commonSettings.LINE_COMMENT_ADD_SPACE = true;
    }

    public IndentOptionsEditor getIndentOptionsEditor() {
        return new JSIndentOptionsEditor(null);
    }

    @Nullable
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new JSCodeStyleSettings(settings);
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        if (baseSettings == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(13);
        }
        if (modelSettings == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(14);
        }
        return new JSCodeStyleConfigurable(baseSettings, modelSettings);
    }

    public int getRightMargin(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == null) {
            JSLanguageCodeStyleSettingsProvider.$$$reportNull$$$0(15);
        }
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            return 40;
        }
        return super.getRightMargin(settingsType);
    }

    @NlsContexts.Label
    public static String getFlowCategoryName() {
        return JavaScriptBundle.message("js.spaces.in.flow.category", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/JSLanguageCodeStyleSettingsProvider";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsType";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsClass";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseSettings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/JSLanguageCodeStyleSettingsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCodeSample";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customizeSettings";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addJSOrTSCommonSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFlowSpecificSettings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "customizeDefaults";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCustomizeDefaults";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRightMargin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

