/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.commonjs;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSNamedExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSDocModulesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.evaluable.JSRequireCallExpressionType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommonJSUtil {
    private static final Logger LOG = Logger.getInstance(CommonJSUtil.class);
    public static final String MJS_EXTENSION = "mjs";
    public static final String MJS_WITH_DOT_EXTENSION = ".mjs";
    public static final String CJS_EXTENSION = "cjs";
    private static final Condition<JSPsiElementBase> EXPORTED_ELEMENTS_FILTER = element -> !(element instanceof JSNamedExpression);

    public static boolean calculateIsRequireCall(@NotNull JSCallExpression callExpression) {
        JSReferenceExpression methodExpression;
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(0);
        }
        return (methodExpression = (JSReferenceExpression)ObjectUtils.tryCast((Object)callExpression.getMethodExpression(), JSReferenceExpression.class)) != null && callExpression.getArguments().length == 1 && methodExpression.getQualifier() == null && "require".equals(methodExpression.getReferenceName());
    }

    @Nullable
    public static String getRequireCallModulePath(@NotNull JSCallExpression call) {
        if (call == null) {
            CommonJSUtil.$$$reportNull$$$0(1);
        }
        assert (call.isRequireCall());
        JSExpression[] arguments = call.getArguments();
        assert (arguments.length == 1);
        JSExpression argument = arguments[0];
        if (!(argument instanceof JSLiteralExpression) || !((JSLiteralExpression)argument).isQuotedLiteral()) {
            return null;
        }
        return StringUtil.unquoteString((String)argument.getText());
    }

    @NotNull
    public static String unifyModuleName(@NotNull String text) {
        if (text == null) {
            CommonJSUtil.$$$reportNull$$$0(2);
        }
        String string = "module:" + CommonJSUtil.unifyModuleNameShortened(text);
        if (string == null) {
            CommonJSUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String unifyModuleNameShortened(@NotNull String text) {
        if (text == null) {
            CommonJSUtil.$$$reportNull$$$0(4);
        }
        String toProcess = JSStringUtil.unquoteAndUnescapeStringLiteralValue(text);
        String string = toProcess = JSStringUtil.wrapQualifiedNameComponent(toProcess);
        if (string == null) {
            CommonJSUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static Collection<PsiElement> resolveJSDocCommentModules(@NotNull JSType type) {
        String typeText;
        PsiElement context;
        if (type == null) {
            CommonJSUtil.$$$reportNull$$$0(6);
        }
        if ((context = type.getSource().getSourceElement()) == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                CommonJSUtil.$$$reportNull$$$0(7);
            }
            return list2;
        }
        if (type instanceof JSTypeImpl && type.isJavaScript() && ((typeText = type.getTypeText()).startsWith("module:") || typeText.startsWith("import("))) {
            Collection<PsiElement> collection = ((JSTypeImpl)type).getDeclarations();
            if (collection == null) {
                CommonJSUtil.$$$reportNull$$$0(8);
            }
            return collection;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            CommonJSUtil.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    public static Collection<PsiElement> resolveJSDocCommentModules(@NotNull PsiElement context, @NotNull String moduleNameWithoutPrefix) {
        if (context == null) {
            CommonJSUtil.$$$reportNull$$$0(10);
        }
        if (moduleNameWithoutPrefix == null) {
            CommonJSUtil.$$$reportNull$$$0(11);
        }
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        SmartHashSet files = new SmartHashSet();
        StubIndex.getInstance().processElements(JSDocModulesIndex.KEY, (Object)moduleNameWithoutPrefix, context.getProject(), scope, JSDocComment.class, arg_0 -> CommonJSUtil.lambda$resolveJSDocCommentModules$1((Collection)files, arg_0));
        SmartHashSet smartHashSet = files;
        if (smartHashSet == null) {
            CommonJSUtil.$$$reportNull$$$0(12);
        }
        return smartHashSet;
    }

    public static Collection<JSFile> resolveReferencedElements(@NotNull PsiElement context, @NotNull String path2) {
        if (context == null) {
            CommonJSUtil.$$$reportNull$$$0(13);
        }
        if (path2 == null) {
            CommonJSUtil.$$$reportNull$$$0(14);
        }
        return JSFileReferencesUtil.resolveModuleReference((PsiElement)context.getContainingFile(), path2).stream().filter(el -> el instanceof JSFile).map(el -> (JSFile)el).collect(Collectors.toList());
    }

    public static boolean isExportNamespace(@Nullable JSNamespace namespace) {
        return namespace != null && CommonJSUtil.isExportNamespace(namespace.getQualifiedName());
    }

    public static boolean isExportNamespace(@Nullable JSQualifiedName qName) {
        return qName != null && "exports".equals(qName.getName()) && (qName.getParent() == null || "module".equals(qName.getParent().getName()) && qName.getParent().getParent() == null);
    }

    public static boolean isExportsDefinition(@Nullable PsiElement element) {
        if (!(element instanceof JSDefinitionExpression)) {
            return false;
        }
        String name = ((JSDefinitionExpression)element).getQualifiedName();
        return name != null && name.equals("exports");
    }

    public static boolean isModuleExportsAssigmentTarget(@NotNull JSElementBase element) {
        if (element == null) {
            CommonJSUtil.$$$reportNull$$$0(15);
        }
        if (!"exports".equals(element.getName())) {
            return false;
        }
        JSNamespace jsNamespace = element.getJSNamespace();
        JSQualifiedName qName = jsNamespace.getQualifiedName();
        return qName != null && "module".equals(qName.getName()) && qName.getParent() == null && jsNamespace.getJSContext() == JSContext.STATIC;
    }

    @NotNull
    public static Collection<PsiElement> findReferencedModulesIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(16);
        }
        if (!callExpression.isRequireCall()) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                CommonJSUtil.$$$reportNull$$$0(17);
            }
            return list2;
        }
        JSExpression[] arguments = callExpression.getArguments();
        if (arguments.length > 0 && arguments[0] instanceof JSLiteralExpression) {
            Collection<PsiElement> collection = JSFileReferencesUtil.resolveModuleReferences((PsiElement)arguments[0]);
            if (collection == null) {
                CommonJSUtil.$$$reportNull$$$0(18);
            }
            return collection;
        }
        List list3 = ContainerUtil.emptyList();
        if (list3 == null) {
            CommonJSUtil.$$$reportNull$$$0(19);
        }
        return list3;
    }

    @Nullable
    public static PsiElement findReferencedModuleIfRequireCall(@NotNull JSCallExpression callExpression) {
        if (callExpression == null) {
            CommonJSUtil.$$$reportNull$$$0(20);
        }
        return (PsiElement)ContainerUtil.getFirstItem(CommonJSUtil.findReferencedModulesIfRequireCall(callExpression));
    }

    @Nullable
    public static JSRequireCallExpressionType getTypeIfRequireCall(@NotNull JSCallExpression requireCall) {
        if (requireCall == null) {
            CommonJSUtil.$$$reportNull$$$0(21);
        }
        if (!requireCall.isRequireCall()) {
            return null;
        }
        String path2 = CommonJSUtil.getRequireCallModulePath(requireCall);
        return path2 != null ? new JSRequireCallExpressionType(path2, JSTypeSourceFactory.createTypeSource((PsiElement)requireCall, true)) : null;
    }

    @NotNull
    public static List<JSPsiElementBase> getModuleExports(@NotNull JSExecutionScope module) {
        if (module == null) {
            CommonJSUtil.$$$reportNull$$$0(22);
        }
        if (module instanceof TypeScriptModule) {
            List<JSPsiElementBase> list2 = Collections.emptyList();
            if (list2 == null) {
                CommonJSUtil.$$$reportNull$$$0(23);
            }
            return list2;
        }
        if (!(module instanceof JSFile) && !ES6PsiUtil.isEmbeddedModule((PsiElement)module)) {
            LOG.error((Throwable)new IllegalStateException("Expected JSFile or an embedded module"));
            List<JSPsiElementBase> list3 = Collections.emptyList();
            if (list3 == null) {
                CommonJSUtil.$$$reportNull$$$0(24);
            }
            return list3;
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            List<JSPsiElementBase> list4 = Collections.emptyList();
            if (list4 == null) {
                CommonJSUtil.$$$reportNull$$$0(25);
            }
            return list4;
        }
        List<JSPsiElementBase> candidates = JSClassResolver.getInstance().findElementsByQNameIncludingImplicit("module.exports", module.getContainingFile());
        Condition filter = module instanceof JSFile ? EXPORTED_ELEMENTS_FILTER : element -> EXPORTED_ELEMENTS_FILTER.value(element) && PsiTreeUtil.isContextAncestor((PsiElement)module, (PsiElement)element, (boolean)false);
        List list5 = ContainerUtil.filter(candidates, (Condition)filter);
        if (list5 == null) {
            CommonJSUtil.$$$reportNull$$$0(26);
        }
        return list5;
    }

    public static boolean isExportedWithModuleExports(@NotNull JSPsiElementBase element) {
        JSFile file2;
        if (element == null) {
            CommonJSUtil.$$$reportNull$$$0(27);
        }
        if ((file2 = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class)) == null) {
            return false;
        }
        JSModuleStatusOwner.ModuleStatus status = file2.getModuleStatus();
        if (status == JSModuleStatusOwner.ModuleStatus.NONE || status == JSModuleStatusOwner.ModuleStatus.ES6) {
            return false;
        }
        List<JSPsiElementBase> exports = CommonJSUtil.getModuleExports(file2);
        String name = element.getName();
        for (JSPsiElementBase export : exports) {
            PsiElement resolved;
            String ref;
            if (!(export instanceof JSDefinitionExpression)) continue;
            JSExpression stub = ((JSDefinitionExpression)export).getInitializerOrStub();
            if (element == stub) {
                return true;
            }
            if (name == null || !Objects.equals(name, ref = JSPsiImplUtils.getInitializerReference((JSDefinitionExpression)export)) || (resolved = JSStubBasedPsiTreeUtil.resolveLocally(name, (PsiElement)export)) != element) continue;
            return true;
        }
        return false;
    }

    public static boolean isMjsFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            CommonJSUtil.$$$reportNull$$$0(28);
        }
        return MJS_EXTENSION.equals(FileUtilRt.getExtension((String)file2.getName()));
    }

    private static /* synthetic */ boolean lambda$resolveJSDocCommentModules$1(Collection files, JSDocComment element) {
        files.add(element.getContainingFile());
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleNameWithoutPrefix";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 15: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireCall";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/commonjs/CommonJSUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyModuleName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unifyModuleNameShortened";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveJSDocCommentModules";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleExports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateIsRequireCall";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRequireCallModulePath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "unifyModuleName";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unifyModuleNameShortened";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveJSDocCommentModules";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferencedElements";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isModuleExportsAssigmentTarget";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModulesIfRequireCall";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedModuleIfRequireCall";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getTypeIfRequireCall";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleExports";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isExportedWithModuleExports";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isMjsFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

