/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.lang.javascript.ActionScriptFileType;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.flex.JSResolveHelper;
import com.intellij.lang.javascript.index.JSPackageIndexInfo;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.stubs.JSAttributeNameValuePairStub;
import com.intellij.lang.javascript.psi.stubs.JSAttributeStub;
import com.intellij.lang.javascript.psi.stubs.JSClassStub;
import com.intellij.lang.javascript.psi.stubs.JSDefinitionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSFunctionStub;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceDeclarationStub;
import com.intellij.lang.javascript.psi.stubs.JSPackageStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSParameterStub;
import com.intellij.lang.javascript.psi.stubs.JSPropertyStub;
import com.intellij.lang.javascript.psi.stubs.JSQualifiedStub;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.StringTokenizer;
import gnu.trove.THashMap;
import gnu.trove.TObjectObjectProcedure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPackageIndex
extends FileBasedIndexExtension<String, List<JSPackageIndexInfo>> {
    private static final int myVersion = 12;
    public static final ID<String, List<JSPackageIndexInfo>> INDEX_ID = ID.create((String)"js.package.index");
    private static final int KIND_MASK = 15;
    private static final int PUBLIC_MASK = 4;
    private final DataIndexer<String, List<JSPackageIndexInfo>, FileContent> myIndexer = new DataIndexer<String, List<JSPackageIndexInfo>, FileContent>(){

        @NotNull
        public Map<String, List<JSPackageIndexInfo>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            THashMap map = new THashMap();
            StubTree tree = JSPackageIndex.getStubTree(inputData);
            if (tree == null) {
                Map<String, List<JSPackageIndexInfo>> map2 = Collections.emptyMap();
                if (map2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return map2;
            }
            List elementList = tree.getPlainList();
            int size = elementList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                StubElement parentStub;
                StubElement e = (StubElement)elementList.get(i2);
                JSQualifiedStub element = null;
                boolean isPublic = false;
                if (e instanceof JSQualifiedStub) {
                    element = (JSQualifiedStub)e;
                }
                if (e instanceof JSParameterStub || e instanceof JSFunctionExpressionStub || e instanceof JSDefinitionExpressionStub || e instanceof JSPropertyStub) {
                    element = null;
                } else if (e instanceof JSFunctionStub || e instanceof JSVariableStub) {
                    parentStub = e.getParentStub();
                    if (parentStub instanceof JSVarStatementStub) {
                        parentStub = parentStub.getParentStub();
                    }
                    if (!(parentStub instanceof JSPackageStatementStub) && !(parentStub instanceof PsiFileStub)) {
                        element = null;
                    }
                    if (i2 + 1 < size && elementList.get(i2 + 1) instanceof JSAttributeListStub) {
                        isPublic = ((JSAttributeListStub)elementList.get(i2 + 1)).getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC;
                    }
                } else if (e instanceof JSClassStub) {
                    if (i2 + 1 < size && elementList.get(i2 + 1) instanceof JSAttributeListStub) {
                        isPublic = ((JSAttributeListStub)elementList.get(i2 + 1)).getExplicitAccessType() == JSAttributeList.AccessType.PUBLIC;
                        i2 += 2;
                        while (i2 < size) {
                            StubElement maybeAttrStub = (StubElement)elementList.get(i2);
                            if (maybeAttrStub instanceof JSAttributeNameValuePairStub) {
                                ++i2;
                                continue;
                            }
                            if (!(maybeAttrStub instanceof JSAttributeStub)) {
                                --i2;
                                break;
                            }
                            if ("ExcludeClass".equals(((JSAttributeStub)maybeAttrStub).getName())) {
                                isPublic = false;
                            }
                            ++i2;
                        }
                    }
                    if ((parentStub = e.getParentStub()) instanceof PsiFileStub && (element.getName() == null || StringUtil.getPackageName((String)element.getQualifiedName()).length() == 0 && !isPublic)) continue;
                }
                if (element == null) continue;
                this.indexQualifiedElement(element, (Map<String, List<JSPackageIndexInfo>>)map, isPublic);
            }
            THashMap tHashMap = map;
            if (tHashMap == null) {
                1.$$$reportNull$$$0(2);
            }
            return tHashMap;
        }

        private void indexQualifiedElement(JSQualifiedStub element, Map<String, List<JSPackageIndexInfo>> map, boolean isPublic) {
            String qName = element.getQualifiedName();
            if (qName != null) {
                JSPackageIndexInfo.Kind kind = element instanceof JSClassStub ? (((JSClassStub)element).isInterface() ? JSPackageIndexInfo.Kind.INTERFACE : JSPackageIndexInfo.Kind.CLASS) : (element instanceof JSFunctionStub ? JSPackageIndexInfo.Kind.FUNCTION : (element instanceof JSVariableStub || element instanceof JSNamespaceDeclarationStub ? JSPackageIndexInfo.Kind.VARIABLE : JSPackageIndexInfo.Kind.PACKAGE));
                StringTokenizer tokenizer = new StringTokenizer(qName, ".");
                StringBuilder builder = new StringBuilder(qName.length());
                String el = null;
                while (tokenizer.hasMoreElements()) {
                    if (el != null) {
                        if (builder.length() != 0) {
                            builder.append('.');
                        }
                        builder.append(el);
                    }
                    el = tokenizer.nextElement();
                    JSPackageIndexInfo.Kind currentKind = tokenizer.hasMoreElements() ? JSPackageIndexInfo.Kind.PACKAGE : kind;
                    String key = builder.length() != 0 ? builder.toString() : "";
                    SmartList infoList = map.get(key);
                    boolean toAdd = true;
                    if (infoList == null) {
                        infoList = new SmartList();
                        map.put(key, (List<JSPackageIndexInfo>)infoList);
                    } else {
                        int size = infoList.size();
                        for (int i2 = 0; i2 < size; ++i2) {
                            if (!((JSPackageIndexInfo)infoList.get(i2)).isEquivalentTo(el, currentKind, isPublic)) continue;
                            toAdd = false;
                            break;
                        }
                    }
                    if (!toAdd) continue;
                    infoList.add(new JSPackageIndexInfo(el, currentKind, isPublic));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/index/JSPackageIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/index/JSPackageIndex$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private static final NullableLazyValue<FileType> ourSwfFileType = NullableLazyValue.createValue(() -> {
        FileType result2 = FileTypeRegistry.getInstance().getFileTypeByExtension("swf");
        return result2 == UnknownFileType.INSTANCE ? null : result2;
    });
    private final DataExternalizer<List<JSPackageIndexInfo>> myDataExternalizer = new DataExternalizer<List<JSPackageIndexInfo>>(){
        private final JSPackageIndexInfo.Kind[] kinds = JSPackageIndexInfo.Kind.values();

        public void save(@NotNull DataOutput out, List<JSPackageIndexInfo> value) throws IOException {
            if (out == null) {
                2.$$$reportNull$$$0(0);
            }
            out.writeInt(value.size());
            for (JSPackageIndexInfo s : value) {
                out.writeByte(s.kind.ordinal() & 0xF | (s.isPublic ? 1 : 0) << 4);
                IOUtil.writeUTF((DataOutput)out, (String)s.name);
            }
        }

        public List<JSPackageIndexInfo> read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                2.$$$reportNull$$$0(1);
            }
            int size = in.readInt();
            ArrayList<JSPackageIndexInfo> strings = new ArrayList<JSPackageIndexInfo>(size);
            while (size-- > 0) {
                byte b = in.readByte();
                JSPackageIndexInfo.Kind kind = this.kinds[b & 0xF];
                String s = IOUtil.readUTF((DataInput)in);
                strings.add(new JSPackageIndexInfo(s, kind, b >>> 4 == 1));
            }
            return strings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JSPackageIndex$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    @Nullable
    public static StubTree getStubTree(FileContent inputData) {
        Stub rootStub = StubTreeBuilder.buildStubTree((FileContent)inputData);
        if (!(rootStub instanceof PsiFileStub)) {
            return null;
        }
        return new StubTree((PsiFileStub)rootStub);
    }

    public static String buildQualifiedName(String packageName, String className2) {
        return (String)(packageName != null && packageName.length() > 0 ? packageName + "." : "") + className2;
    }

    @NotNull
    public ID<String, List<JSPackageIndexInfo>> getName() {
        ID<String, List<JSPackageIndexInfo>> iD = INDEX_ID;
        if (iD == null) {
            JSPackageIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public Collection<FileType> getFileTypesWithSizeLimitNotApplicable() {
        List list2 = ContainerUtil.createMaybeSingletonList((Object)((FileType)ourSwfFileType.getValue()));
        if (list2 == null) {
            JSPackageIndex.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @NotNull
    public DataIndexer<String, List<JSPackageIndexInfo>, FileContent> getIndexer() {
        DataIndexer<String, List<JSPackageIndexInfo>, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JSPackageIndex.$$$reportNull$$$0(2);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JSPackageIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<JSPackageIndexInfo>> getValueExternalizer() {
        DataExternalizer<List<JSPackageIndexInfo>> dataExternalizer = this.myDataExternalizer;
        if (dataExternalizer == null) {
            JSPackageIndex.$$$reportNull$$$0(4);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{ActionScriptFileType.INSTANCE, (FileType)ourSwfFileType.getValue()}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return file2.getFileType() != ourSwfFileType.getValue() || file2.getFileSystem().getProtocol().equals("jar");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/index/JSPackageIndex$3", "acceptInput"));
            }
        };
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 12;
    }

    public static boolean processElementsInScope(@NotNull String packageName, final @Nullable String targetName, final PackageElementsProcessor processor, GlobalSearchScope searchScope, Project project) {
        if (packageName == null) {
            JSPackageIndex.$$$reportNull$$$0(5);
        }
        THashMap indexValues = new THashMap();
        FileBasedIndex.ValueProcessor indexProcessor = (file2, members) -> {
            indexValues.put((Object)file2, members);
            return true;
        };
        if (targetName == null) {
            FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)packageName, null, indexProcessor, searchScope);
        } else {
            String target = JSPackageIndex.buildQualifiedName(packageName, targetName);
            FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)target, null, indexProcessor, searchScope);
        }
        boolean b = indexValues.forEachEntry((TObjectObjectProcedure)new TObjectObjectProcedure<VirtualFile, List<JSPackageIndexInfo>>(){

            public boolean execute(VirtualFile file2, List<JSPackageIndexInfo> members) {
                if (targetName != null) {
                    return processor.process(file2, targetName, JSPackageIndexInfo.Kind.PACKAGE, true);
                }
                for (JSPackageIndexInfo className2 : members) {
                    if (processor.process(file2, className2.name, className2.kind, className2.isPublic)) continue;
                    return false;
                }
                return true;
            }
        });
        if (b) {
            Processor vfileProcessor = virtualFile -> {
                JSPackageIndexInfo.Kind kind = null;
                if (virtualFile.isDirectory()) {
                    if (StringUtil.isJavaIdentifier((String)virtualFile.getName())) {
                        kind = JSPackageIndexInfo.Kind.PACKAGE;
                    }
                } else if (JavaScriptSupportLoader.isMxmlOrFxgFile(virtualFile)) {
                    kind = JSPackageIndexInfo.Kind.CLASS;
                }
                if (kind == null) {
                    return true;
                }
                return processor.process((VirtualFile)virtualFile, virtualFile.getNameWithoutExtension(), kind, true);
            };
            for (JSResolveHelper helper : JSResolveHelper.EP_NAME.getExtensionList()) {
                if (helper.processPackage(packageName, targetName, (Processor<? super VirtualFile>)vfileProcessor, searchScope, project)) continue;
                return false;
            }
        }
        return b;
    }

    public static boolean processElementsInScopeRecursive(@NotNull String packageName, final PackageQualifiedElementsProcessor processor, GlobalSearchScope searchScope, Project project) {
        if (packageName == null) {
            JSPackageIndex.$$$reportNull$$$0(6);
        }
        final HashSet<String> packagesToProcess = new HashSet<String>();
        packagesToProcess.add(packageName);
        while (!packagesToProcess.isEmpty()) {
            final String currentPackage = (String)ContainerUtil.getFirstItem(packagesToProcess, null);
            if (!JSPackageIndex.processElementsInScope(currentPackage, null, new PackageElementsProcessor(){

                @Override
                public boolean process(VirtualFile file2, @NotNull String name, JSPackageIndexInfo.Kind kind, boolean isPublic) {
                    String qualifiedName;
                    if (name == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (!processor.process(qualifiedName = JSPackageIndex.buildQualifiedName(currentPackage, name), kind, isPublic)) {
                        return false;
                    }
                    if (kind == JSPackageIndexInfo.Kind.PACKAGE) {
                        packagesToProcess.add(qualifiedName);
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/index/JSPackageIndex$5", "process"));
                }
            }, searchScope, project)) {
                return false;
            }
            packagesToProcess.remove(currentPackage);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/index/JSPackageIndex";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesWithSizeLimitNotApplicable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/index/JSPackageIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processElementsInScope";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElementsInScopeRecursive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface PackageQualifiedElementsProcessor {
        public boolean process(String var1, JSPackageIndexInfo.Kind var2, boolean var3);
    }

    public static interface PackageElementsProcessor {
        public boolean process(VirtualFile var1, @NotNull String var2, JSPackageIndexInfo.Kind var3, boolean var4);
    }
}

