/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageNamesValidation;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.CreateJSFieldFromParameterAction;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignParameterToFieldAction
extends FixAndIntentionAction {
    public static final String VAR_NAME = "__var_name";
    private final FixAndIntentionAction myAction;
    private final String myFieldName;
    private final String myParameterName;
    private final String myClassName;

    public AssignParameterToFieldAction(FixAndIntentionAction action, String fieldName, String parameterName, String className2) {
        this.myAction = action;
        this.myFieldName = fieldName;
        this.myParameterName = parameterName;
        this.myClassName = className2;
    }

    @NotNull
    public String getName() {
        String string = this.myAction != null ? this.myAction.getName() : JavaScriptBundle.message("javascript.assign.parameter.to.field.intention.name", this.myParameterName);
        if (string == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void applyFix(final Project project, PsiElement psiElement, final @NotNull PsiFile file2, final @Nullable Editor editor) {
        int ourParameterIndex;
        JSFunction fun;
        if (file2 == null) {
            AssignParameterToFieldAction.$$$reportNull$$$0(1);
        }
        if ((fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)psiElement, JSFunction.class)) == null) {
            return;
        }
        JSBlockStatement functionBlockStatement = fun.getBlock();
        if (functionBlockStatement == null) {
            return;
        }
        boolean isES6ClassImpl = JSClassUtils.isES6ClassImplementation((PsiElement)fun);
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        PsiElement insertBefore = functionBlockStatement.getFirstChild();
        List<JSParameter> parameters = Arrays.asList(fun.getParameterVariables());
        if ((insertBefore = JSChangeUtil.findInsertionPlaceStartingFrom(insertBefore, true, (Function<? super PsiElement, Boolean>)((Function)arg_0 -> AssignParameterToFieldAction.lambda$applyFix$0(parameters, ourParameterIndex = parameters.indexOf(psiElement.getParent()), arg_0)))) == null) {
            insertBefore = functionBlockStatement.getLastChild();
        }
        boolean staticContext = JSResolveUtil.calculateStaticFromContext(psiElement);
        if (!ArrayUtil.isEmpty((Object[])functionBlockStatement.getStatementListItems())) {
            template.addTextSegment("\n");
        }
        if (isES6ClassImpl || this.myFieldName.equals(this.myParameterName) || staticContext) {
            Object res = staticContext ? this.myClassName + "." : "this.";
            template.addTextSegment((String)res);
            ConstantNode expression = new ConstantNode(this.myFieldName);
            template.addVariable(VAR_NAME, (Expression)expression, (Expression)expression, true);
        } else {
            template.addTextSegment(this.myFieldName);
        }
        template.addTextSegment(" = " + this.myParameterName + JSCodeStyleSettings.getSemicolon((PsiElement)fun));
        template.addEndVariable();
        editor.getCaretModel().moveToOffset(insertBefore.getTextRange().getStartOffset());
        template.setToReformat(true);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){
            String newFieldName;
            {
                this.newFieldName = AssignParameterToFieldAction.this.myFieldName;
            }

            public void beforeTemplateFinished(@NotNull TemplateState state2, Template template) {
                TextResult variableValue;
                if (state2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((variableValue = state2.getVariableValue(AssignParameterToFieldAction.VAR_NAME)) == null) {
                    return;
                }
                String fieldName = variableValue.getText();
                if (!LanguageNamesValidation.isIdentifier((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4, (String)fieldName, (Project)project)) {
                    return;
                }
                this.newFieldName = fieldName;
            }

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (AssignParameterToFieldAction.this.myAction != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        CreateJSFieldFromParameterAction createFieldFromParameterAction = new CreateJSFieldFromParameterAction(this.newFieldName);
                        createFieldFromParameterAction.sharePointer(AssignParameterToFieldAction.this.myAction);
                        createFieldFromParameterAction.invoke(project, editor, file2);
                    }, project.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "template";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeTemplateFinished";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "templateFinished";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ Boolean lambda$applyFix$0(List parameters, int ourParameterIndex, PsiElement psiElement1) {
        if (psiElement1 instanceof JSExpressionStatement) {
            int i2;
            PsiElement resolve;
            JSExpression rOperand;
            JSExpression expression = ((JSExpressionStatement)psiElement1).getExpression();
            if (expression instanceof JSCallExpression && ((JSCallExpression)expression).getMethodExpression() instanceof JSSuperExpression) {
                return Boolean.TRUE;
            }
            if (expression instanceof JSAssignmentExpression && (rOperand = ((JSAssignmentExpression)expression).getROperand()) instanceof JSReferenceExpression && (resolve = ((JSReferenceExpression)rOperand).resolve()) instanceof JSParameter && (i2 = parameters.indexOf((JSParameter)resolve)) != -1 && i2 < ourParameterIndex) {
                return Boolean.TRUE;
            }
        }
        return Boolean.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/AssignParameterToFieldAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

