/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonFileType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertRequireIntoImportInspection
extends JSInspection {
    public static final String ES6_CONVERT_REQUIRE_INTO_IMPORT = "ES6ConvertRequireIntoImport";
    public boolean myScopeOption;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSCallExpression(JSCallExpression call) {
                boolean isBatch;
                if (!DialectDetector.hasFeature((PsiElement)call, JSLanguageFeature.IMPORT_DECLARATIONS)) {
                    return;
                }
                if (!call.isRequireCall()) {
                    return;
                }
                JSExpression[] arguments = call.getArguments();
                boolean bl = isBatch = !holder.isOnTheFly();
                if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                    if (!ES6ConvertRequireIntoImportInspection.checkArgument(StringUtil.unquoteString((String)arguments[0].getText())) || isBatch && !ES6ConvertRequireIntoImportInspection.this.myScopeOption && !ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel(call)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)call, JavaScriptBundle.message("js.convert.require.into.es6.import.inspection.text", new Object[0]), new LocalQuickFix[]{new ES6ConvertRequireIntoImportQuickFix(call)});
                }
            }
        };
    }

    private static boolean checkArgument(@NotNull String requireArgument) {
        String extension;
        if (requireArgument == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(2);
        }
        if ((extension = FileUtilRt.getExtension((String)ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireArgument))).isEmpty() || "node".equals(extension)) {
            return true;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        return fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || JsonFileType.INSTANCE.equals(fileType);
    }

    @NotNull
    public static String cutRelativePathStartAndForwardSlash(@NotNull String argument) {
        if (argument == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(3);
        }
        String[] parts = argument.replace('\\', '/').split("/");
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        for (String part : parts) {
            if (!(".".equals(part) || "..".equals(part) || part.isEmpty())) {
                if (!started) {
                    started = true;
                }
            } else if (!started) continue;
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(part);
        }
        String string = sb.toString();
        if (string == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    static boolean checkElementIsOnTopLevel(@NotNull JSElement element) {
        JSSourceElement immediateSourceElement;
        if (element == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(5);
        }
        if ((immediateSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSSourceElement.class)) == null) {
            return false;
        }
        if (immediateSourceElement.getParent() instanceof PsiFile && element.getContainingFile().equals(immediateSourceElement.getParent())) {
            return true;
        }
        return immediateSourceElement.getParent() instanceof JSEmbeddedContent;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.createSingleCheckboxOptionsPanelWithHint(JavaScriptBundle.message("js.convert.require.into.es6.import.inspection.withConditional.option", new Object[0]), JavaScriptBundle.message("js.convert.require.into.es6.import.inspection.withConditional.option.description", new Object[0]), "myScopeOption");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireArgument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cutRelativePathStartAndForwardSlash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cutRelativePathStartAndForwardSlash";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElementIsOnTopLevel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

