/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclarationPart;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.FileHeaderKeeper;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.LastImportRequireInScope;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSPsiNamedElementBase;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.usageView.BaseUsageViewDescriptor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertRequireIntoImportQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction,
BatchQuickFix<CommonProblemDescriptor> {
    @NotNull
    private final SmartPsiElementPointer<JSCallExpression> myPointer;

    public ES6ConvertRequireIntoImportQuickFix(@NotNull JSCallExpression call) {
        if (call == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(0);
        }
        this.myPointer = SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer((PsiElement)call);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message("js.convert.require.into.es6.import.text", new Object[0]);
        if (string == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("js.convert.require.into.es6.import.family.name", new Object[0]);
        if (string == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(4);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        JSCallExpression element;
        if (project == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(5);
        }
        if ((element = (JSCallExpression)this.myPointer.getElement()) != null && element.isValid()) {
            new Worker(element).executeWithWriteAction();
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        if (currentFile == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(6);
        }
        return currentFile;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        JSCallExpression element;
        if (project == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor2 == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(8);
        }
        if ((element = (JSCallExpression)this.myPointer.getElement()) != null && element.isValid()) {
            new Worker(element).executeWithWriteAction();
        }
    }

    public void applyFix(@NotNull Project project, CommonProblemDescriptor @NotNull [] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(9);
        }
        if (psiElementsToIgnore == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(10);
        }
        if (descriptors == null) {
            ES6ConvertRequireIntoImportQuickFix.$$$reportNull$$$0(11);
        }
        MultiMap map = new MultiMap();
        block0: for (CommonProblemDescriptor descriptor2 : descriptors) {
            QuickFix[] fixes = descriptor2.getFixes();
            if (fixes == null) continue;
            for (QuickFix fix : fixes) {
                if (!(fix instanceof ES6ConvertRequireIntoImportQuickFix)) continue;
                map.putValue((Object)((ES6ConvertRequireIntoImportQuickFix)fix).myPointer.getVirtualFile(), (Object)descriptor2);
                continue block0;
            }
        }
        for (VirtualFile file2 : map.keySet()) {
            Collection fileDescriptors = map.get((Object)file2);
            new MyBatchRefactoringProcessor(project, fileDescriptors.toArray(CommonProblemDescriptor.EMPTY_ARRAY), this.getFamilyName()).run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToMakeWritable";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBatchRefactoringProcessor
    extends BaseRefactoringProcessor {
        private final CommonProblemDescriptor[] myDescriptors;
        private final @NlsContexts.Command String myName;
        private PsiElement topElement;
        private JSCallExpression topCall;

        MyBatchRefactoringProcessor(Project project, CommonProblemDescriptor[] descriptors, @NlsContexts.Command String name) {
            super(project);
            this.myDescriptors = descriptors;
            this.myName = name;
        }

        @NotNull
        protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
            if (usages == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(0);
            }
            return new BaseUsageViewDescriptor(new PsiElement[0]);
        }

        protected UsageInfo @NotNull [] findUsages() {
            UsageInfo[] usageInfoArray;
            for (CommonProblemDescriptor descriptor2 : this.myDescriptors) {
                QuickFix[] fixes = descriptor2.getFixes();
                if (fixes == null) continue;
                for (QuickFix fix : fixes) {
                    JSCallExpression call;
                    if (!(fix instanceof ES6ConvertRequireIntoImportQuickFix) || (call = (JSCallExpression)((ES6ConvertRequireIntoImportQuickFix)fix).myPointer.getElement()) == null || !call.isValid() || this.topCall != null && this.topCall.getTextRange().getStartOffset() <= call.getTextRange().getStartOffset()) continue;
                    this.topCall = call;
                    this.topElement = JSChangeUtil.getScopeElementInFile((PsiElement)call);
                }
            }
            if (this.topElement == null) {
                usageInfoArray = UsageInfo.EMPTY_ARRAY;
            } else {
                UsageInfo[] usageInfoArray2 = new UsageInfo[1];
                usageInfoArray = usageInfoArray2;
                usageInfoArray2[0] = new UsageInfo(this.topElement);
            }
            if (usageInfoArray == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(1);
            }
            return usageInfoArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performRefactoring(UsageInfo @NotNull [] usages) {
            FileHeaderKeeper headerKeeper;
            if (usages == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(2);
            }
            FileHeaderKeeper fileHeaderKeeper = headerKeeper = this.topElement == null ? null : new FileHeaderKeeper(this.topElement);
            if (headerKeeper != null) {
                headerKeeper.saveStateAndCutHeader();
            }
            try {
                ImportInsertPlace insertPlace = this.topElement == null ? null : new ImportInsertPlace(this.topElement, this.topCall);
                boolean firstInFile = insertPlace != null && !insertPlace.isAddAfterAnchor();
                List<CommonProblemDescriptor> list2 = Arrays.asList(this.myDescriptors);
                Collections.reverse(list2);
                boolean changed = false;
                ArrayList<PsiElement> touchedElements = new ArrayList<PsiElement>();
                for (CommonProblemDescriptor descriptor2 : list2) {
                    QuickFix[] fixes = descriptor2.getFixes();
                    if (fixes == null) continue;
                    for (QuickFix fix : fixes) {
                        Worker worker;
                        JSCallExpression element;
                        if (!(fix instanceof ES6ConvertRequireIntoImportQuickFix) || (element = (JSCallExpression)((ES6ConvertRequireIntoImportQuickFix)fix).myPointer.getElement()) == null || !element.isValid()) continue;
                        if (changed && firstInFile) {
                            insertPlace = new ImportInsertPlace(this.topElement, element);
                        }
                        if ((worker = new Worker(element).setImportInsertPlace(insertPlace)).execute()) {
                            touchedElements.addAll(worker.getTouchedElements());
                        }
                        changed = true;
                    }
                }
                MyBatchRefactoringProcessor.reformatGroup(touchedElements);
            }
            finally {
                if (headerKeeper != null) {
                    headerKeeper.restoreHeaderForSavedState();
                }
            }
        }

        private static void reformatGroup(List<PsiElement> elements) {
            if (elements.isEmpty()) {
                return;
            }
            int start = Integer.MAX_VALUE;
            int end = 0;
            PsiFile file2 = null;
            for (PsiElement element : elements) {
                if (!element.isValid()) continue;
                file2 = element.getContainingFile();
                TextRange range = element.getTextRange();
                start = Math.min(start, range.getStartOffset());
                end = Math.max(end, range.getEndOffset());
            }
            if (file2 == null) {
                return;
            }
            Document document2 = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
            if (document2 != null) {
                FormatFixer.create(elements.get(0).getContainingFile(), new TextRange(start, end), document2, FormatFixer.Mode.Reformat).fixFormat();
            }
        }

        @NotNull
        protected String getCommandName() {
            String string = this.myName;
            if (string == null) {
                MyBatchRefactoringProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "usages";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$MyBatchRefactoringProcessor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findUsages";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommandName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createUsageViewDescriptor";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "performRefactoring";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImportInsertPlace {
        @NotNull
        private final PsiElement myTopElement;
        @Nullable
        private final PsiElement myAnchor;
        private final boolean myAddAfterAnchor;

        ImportInsertPlace(@NotNull PsiElement topElement, @NotNull JSCallExpression callExpression) {
            if (topElement == null) {
                ImportInsertPlace.$$$reportNull$$$0(0);
            }
            if (callExpression == null) {
                ImportInsertPlace.$$$reportNull$$$0(1);
            }
            this.myTopElement = topElement;
            PsiElement lastImportAnchor = new LastImportRequireInScope(true).withNoticeRequire(false).findAndSelect(topElement);
            if (lastImportAnchor != null && lastImportAnchor.getTextOffset() < callExpression.getTextOffset()) {
                this.myAnchor = lastImportAnchor;
                this.myAddAfterAnchor = true;
            } else {
                Pair<Boolean, PsiElement> placeInfo = ES6ImportPsiUtil.findPlaceForImport(this.myTopElement);
                this.myAnchor = (PsiElement)placeInfo.second;
                this.myAddAfterAnchor = (Boolean)placeInfo.first;
            }
        }

        public boolean isAddAfterAnchor() {
            return this.myAddAfterAnchor;
        }

        public ES6ImportDeclaration insert(ES6ImportDeclaration importStatement) {
            if (this.myAnchor != null) {
                ES6ImportDeclaration added;
                if (this.myAddAfterAnchor) {
                    PsiElement sibling = PsiTreeUtil.getNextSiblingOfType((PsiElement)this.myAnchor, JSSourceElement.class);
                    if (sibling != null) {
                        added = ImportInsertPlace.addBeforeWithNewline(importStatement, sibling);
                    } else {
                        this.myAnchor.getParent().getNode().addChild(importStatement.getNode());
                        added = (ES6ImportDeclaration)importStatement.getNode().getPsi();
                    }
                } else {
                    added = ImportInsertPlace.addBeforeWithNewline(importStatement, this.myAnchor);
                }
                return added;
            }
            return (ES6ImportDeclaration)this.myTopElement.add((PsiElement)importStatement);
        }

        private static ES6ImportDeclaration addBeforeWithNewline(@NotNull ES6ImportDeclaration importStatement, @NotNull PsiElement anchor) {
            if (importStatement == null) {
                ImportInsertPlace.$$$reportNull$$$0(2);
            }
            if (anchor == null) {
                ImportInsertPlace.$$$reportNull$$$0(3);
            }
            ES6ImportDeclaration added = (ES6ImportDeclaration)JSChangeUtil.doDoAddBeforePure(anchor.getParent(), (PsiElement)importStatement, anchor);
            anchor.getParent().addBefore(JSChangeUtil.createNewLine(anchor), anchor);
            return added;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$ImportInsertPlace";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addBeforeWithNewline";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Worker {
        private final JSCallExpression myCallExpression;
        private JSVariable myOwnerVariable;
        private PsiElement myFirstReference;
        private String myFirstReferenceText;
        private PsiElement myTopElement;
        private CommentsMover myCommentsMover;
        private final Set<PsiElement> myTouchedElements;
        private boolean myShouldMoveComments;
        private boolean myHasReferenceTail;
        private JSDestructuringElement myDestructuringElement;
        private ImportInsertPlace myImportInsertPlace;

        Worker(@NotNull JSCallExpression callExpression) {
            if (callExpression == null) {
                Worker.$$$reportNull$$$0(0);
            }
            this.myCallExpression = callExpression;
            this.myTouchedElements = new HashSet<PsiElement>();
        }

        public Worker setImportInsertPlace(ImportInsertPlace importInsertPlace) {
            this.myImportInsertPlace = importInsertPlace;
            return this;
        }

        public void executeWithWriteAction() {
            WriteAction.run(() -> this.execute());
        }

        public Set<PsiElement> getTouchedElements() {
            return this.myTouchedElements;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean execute() {
            this.init();
            if (this.myTopElement == null) {
                return false;
            }
            FileHeaderKeeper headerKeeper = null;
            if (this.myImportInsertPlace == null) {
                headerKeeper = new FileHeaderKeeper(this.myTopElement);
                headerKeeper.saveStateAndCutHeader();
            }
            try {
                JSExpression[] arguments = this.myCallExpression.getArguments();
                if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                    JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)this.myCallExpression, JSSourceElement.class);
                    boolean bl = this.myShouldMoveComments = sourceElement != null && this.shouldMoveComments(sourceElement);
                    if (sourceElement != null) {
                        this.myCommentsMover = new CommentsMover(sourceElement);
                    }
                    String requireText = StringUtil.unquoteString((String)arguments[0].getText());
                    if (this.myDestructuringElement != null && this.tryProcessAsDestructuring(requireText)) {
                        this.moveComments();
                        this.reformatAfterFix();
                        boolean bl2 = true;
                        return bl2;
                    }
                    Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing = ES6ImportsWorker.getExistingImport(this.myTopElement, requireText, this.myFirstReferenceText, false);
                    if (existing != null && this.useExistingImport(requireText, existing)) {
                        this.reformatAfterFix();
                        boolean bl3 = true;
                        return bl3;
                    }
                    ES6ImportDeclaration importDeclaration = this.createImport(requireText);
                    if (importDeclaration == null) {
                        boolean bl4 = false;
                        return bl4;
                    }
                    this.myTouchedElements.add((PsiElement)importDeclaration);
                    PsiElement createdReferenceTarget = Worker.getReferencedElement(importDeclaration);
                    if (createdReferenceTarget == null) {
                        boolean bl5 = false;
                        return bl5;
                    }
                    this.moveComments();
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, createdReferenceTarget, createdReferenceTarget.getText(), (PsiElement)ObjectUtils.coalesce((Object)this.myFirstReference, (Object)this.myCallExpression));
                    this.reformatAfterFix();
                    boolean bl6 = true;
                    return bl6;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (headerKeeper != null) {
                    headerKeeper.restoreHeaderForSavedState();
                }
            }
        }

        private void reformatAfterFix() {
            if (this.myImportInsertPlace == null) {
                this.myTouchedElements.forEach(el -> FormatFixer.create(el, FormatFixer.Mode.Reformat).fixFormat());
            }
        }

        private void moveComments() {
            if (this.myCommentsMover != null && this.myShouldMoveComments) {
                this.myCommentsMover.move(this.myTouchedElements, this.myTouchedElements);
            }
        }

        private boolean tryProcessAsDestructuring(@NotNull String requireText) {
            JSDestructuringProperty[] properties2;
            if (requireText == null) {
                Worker.$$$reportNull$$$0(1);
            }
            if (this.myDestructuringElement == null) {
                return false;
            }
            PsiElement grand = this.myDestructuringElement.getParent();
            if (!(grand instanceof JSVarStatement)) {
                return false;
            }
            JSDestructuringContainer container = this.myDestructuringElement.getTarget();
            if (!(container instanceof JSDestructuringObject)) {
                return false;
            }
            JSDestructuringObject object = (JSDestructuringObject)container;
            for (JSDestructuringProperty property : properties2 = object.getProperties()) {
                if (property.getDestructuringElement() == null || property.getDestructuringElement().getName() == null || StringUtil.isEmptyOrSpaces((String)property.getName())) {
                    return false;
                }
                if (!"default".equals(property.getName()) || !"default".equals(property.getDestructuringElement().getName())) continue;
                return false;
            }
            ES6ImportPsiUtil.ES6ExistingImports existingImports = ES6ImportPsiUtil.getExistingImports(this.myTopElement, requireText);
            for (JSDestructuringProperty property : properties2) {
                Object declaration;
                ES6ImportSpecifier existingExactSpecifier;
                String reference = property.getName();
                assert (reference != null);
                JSInitializerOwner variable = property.getDestructuringElement();
                boolean isDefault = "default".equals(reference);
                assert (variable != null);
                ES6ImportPsiUtil.CreateImportExportInfo importData = new ES6ImportPsiUtil.CreateImportExportInfo(reference, variable.getName(), isDefault ? ES6ImportPsiUtil.ImportExportType.DEFAULT : ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                ES6ImportSpecifier eS6ImportSpecifier = existingExactSpecifier = isDefault ? null : existingImports.getSpecifiers().get(reference);
                if (existingExactSpecifier != null) {
                    if (variable.getName().equals(existingExactSpecifier.getDeclaredName())) continue;
                    JSPsiNamedElementBase replaceTarget = existingExactSpecifier.getAlias() != null ? existingExactSpecifier.getAlias() : existingExactSpecifier;
                    JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)replaceTarget, this.myTopElement);
                    continue;
                }
                if (!isDefault && !existingImports.getSpecifiers().isEmpty()) {
                    Map.Entry<String, ES6ImportSpecifier> entry = existingImports.getSpecifiers().entrySet().iterator().next();
                    assert (entry.getValue().getDeclaration() != null);
                    declaration = entry.getValue().getDeclaration();
                    if (this.insertImportIntoExistingRebind((ES6ImportDeclaration)declaration, importData, existingImports, variable)) continue;
                }
                boolean existingUsed = false;
                for (ES6ImportedBinding binding : existingImports.getBindings()) {
                    if (binding.isNamespaceImport() || !(binding.getParent() instanceof ES6ImportDeclaration)) continue;
                    if (isDefault) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)binding, this.myTopElement);
                        existingUsed = true;
                        break;
                    }
                    if (!this.insertImportIntoExistingRebind((ES6ImportDeclaration)binding.getParent(), importData, existingImports, variable)) continue;
                    existingUsed = true;
                    break;
                }
                if (existingUsed) continue;
                declaration = this.createImport(importData, requireText);
                assert (declaration != null);
                existingImports.addDeclaration((ES6ImportDeclaration)declaration);
                this.myTouchedElements.add((PsiElement)declaration);
                PsiElement toRebind = Worker.getReferencedElement((ES6ImportDeclaration)declaration);
                assert (toRebind != null);
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, toRebind, this.myTopElement);
            }
            JSDestructuringElement parent = this.myDestructuringElement;
            PsiElement current = parent.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = current.getNextSibling();
            }
            if (current != null && current.getNode().getElementType() == JSTokenTypes.COMMA) {
                parent.getParent().deleteChildRange((PsiElement)parent, current);
            } else {
                parent.delete();
            }
            if (((JSVarStatement)grand).getVariables().length == 0) {
                grand.delete();
            }
            return true;
        }

        @Nullable
        private static PsiElement getReferencedElement(ES6ImportDeclaration declaration) {
            Object[] bindings = declaration.getImportedBindings();
            if (bindings.length > 0) {
                return (PsiElement)ArrayUtil.getFirstElement((Object[])bindings);
            }
            ES6ImportSpecifier importSpecifier = (ES6ImportSpecifier)ArrayUtil.getFirstElement((Object[])declaration.getImportSpecifiers());
            if (importSpecifier == null) {
                return null;
            }
            ES6ImportSpecifierAlias alias = importSpecifier.getAlias();
            if (alias != null && alias.getNameIdentifier() != null) {
                return alias.getNameIdentifier();
            }
            return importSpecifier;
        }

        private boolean insertImportIntoExistingRebind(@NotNull ES6ImportDeclaration declaration, @NotNull ES6ImportPsiUtil.CreateImportExportInfo importData, @NotNull ES6ImportPsiUtil.ES6ExistingImports existingImports, @NotNull JSInitializerOwner variable) {
            if (declaration == null) {
                Worker.$$$reportNull$$$0(2);
            }
            if (importData == null) {
                Worker.$$$reportNull$$$0(3);
            }
            if (existingImports == null) {
                Worker.$$$reportNull$$$0(4);
            }
            if (variable == null) {
                Worker.$$$reportNull$$$0(5);
            }
            this.myTouchedElements.add((PsiElement)declaration);
            ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, importData);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                existingImports.addSpecifier(importSpecifier);
                JSPsiNamedElementBase nameElement = importSpecifier.getAlias() != null ? importSpecifier.getAlias() : importSpecifier;
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)nameElement, this.myTopElement);
                return true;
            }
            return false;
        }

        private boolean useExistingImport(String requireText, Pair<ES6ImportDeclaration, ES6ImportExportDeclarationPart> existing) {
            String elementName;
            ES6ImportExportDeclarationPart importElement = (ES6ImportExportDeclarationPart)existing.getSecond();
            ES6ImportDeclaration declaration = (ES6ImportDeclaration)existing.getFirst();
            String string = elementName = importElement == null ? null : importElement.getDeclaredName();
            if (elementName != null) {
                if (importElement instanceof ES6ImportedBinding && !"default".equals(this.myFirstReferenceText)) {
                    this.replaceWithReferenceToImport(this.myFirstReference != null, (PsiElement)importElement, elementName, (PsiElement)this.myCallExpression);
                } else {
                    ES6ImportSpecifierAlias alias;
                    JSElement toRebind = importElement;
                    if (importElement instanceof ES6ImportSpecifier && (alias = ((ES6ImportSpecifier)importElement).getAlias()) != null) {
                        toRebind = alias;
                    }
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)toRebind, elementName, this.myFirstReference);
                }
                return true;
            }
            if (declaration != null) {
                ES6ImportPsiUtil.CreateImportExportInfo info = this.getPrefixInfo(requireText, this.myCallExpression.getParent());
                if (info == null) {
                    return true;
                }
                ES6ImportSpecifier importSpecifier = ES6ImportPsiUtil.insertImportSpecifier(declaration, info);
                if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)importSpecifier, importSpecifier.getDeclaredName(), this.myFirstReference);
                    return true;
                }
            }
            return false;
        }

        private void replaceWithReferenceToImport(boolean hasReferenceTail, @NotNull PsiElement createdReferenceTarget, @NotNull String createdName, @Nullable PsiElement replacementTarget) {
            if (createdReferenceTarget == null) {
                Worker.$$$reportNull$$$0(6);
            }
            if (createdName == null) {
                Worker.$$$reportNull$$$0(7);
            }
            JSExpressionStatement statement = JSPsiElementFactory.createJSStatement(createdName, (PsiElement)this.myCallExpression, JSExpressionStatement.class);
            if (!hasReferenceTail) {
                if (this.myOwnerVariable != null) {
                    if (!createdName.equals(this.myOwnerVariable.getName())) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)this.myOwnerVariable, createdReferenceTarget, this.myTopElement);
                    }
                    if (this.myOwnerVariable.getParent() instanceof JSVarStatement && ((JSVarStatement)this.myOwnerVariable.getParent()).getVariables().length == 1) {
                        Worker.deleteWithSpaces(this.myOwnerVariable.getParent());
                    } else {
                        this.myOwnerVariable.delete();
                    }
                } else if (this.myCallExpression.getParent() instanceof JSExpressionStatement && ((JSExpressionStatement)this.myCallExpression.getParent()).getExpression() == this.myCallExpression) {
                    Worker.deleteWithSpaces(this.myCallExpression.getParent());
                } else if (this.myCallExpression.getParent() instanceof JSCommaExpression) {
                    JSExpression other;
                    JSCommaExpression comma = (JSCommaExpression)this.myCallExpression.getParent();
                    JSExpression jSExpression = other = comma.getLOperand() == this.myCallExpression ? comma.getROperand() : comma.getLOperand();
                    if (other != null) {
                        comma.replace((PsiElement)other);
                    }
                } else {
                    this.myCallExpression.replace(statement.getExpression());
                }
            } else if (replacementTarget != null && statement.getExpression() != null) {
                replacementTarget.replace((PsiElement)statement.getExpression());
            }
        }

        private static void deleteWithSpaces(@NotNull PsiElement element) {
            if (element == null) {
                Worker.$$$reportNull$$$0(8);
            }
            PsiElement forwardNonSpace = PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
            PsiElement backwardNonSpace = PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
            if (forwardNonSpace != null && backwardNonSpace != null) {
                if (element instanceof JSSourceElement) {
                    forwardNonSpace.getParent().getNode().removeRange(backwardNonSpace.getNextSibling().getNode(), forwardNonSpace.getNode());
                    JSChangeUtil.addWs(forwardNonSpace.getParent().getNode(), forwardNonSpace.getNode(), "\n");
                } else {
                    element.delete();
                }
                return;
            }
            JSRefactoringUtil.deleteSiblingWhitespace(element, true, true);
            element.delete();
        }

        private boolean shouldMoveComments(@NotNull JSSourceElement element) {
            if (element == null) {
                Worker.$$$reportNull$$$0(9);
            }
            if (this.myDestructuringElement != null && element instanceof JSVarStatement) {
                JSVariable[] variables;
                for (JSVariable variable : variables = ((JSVarStatement)element).getVariables()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.myDestructuringElement, (PsiElement)variable, (boolean)true)) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof JSVarStatement && ((JSVarStatement)element).getVariables().length == 1 && ((JSVarStatement)element).getVariables()[0] == this.myOwnerVariable) {
                return true;
            }
            return element instanceof JSExpressionStatement && ((JSExpressionStatement)element).getExpression() == this.myCallExpression;
        }

        @Nullable
        private ES6ImportDeclaration createImport(@NotNull String requireText) {
            PsiElement parent;
            ES6ImportPsiUtil.CreateImportExportInfo info;
            if (requireText == null) {
                Worker.$$$reportNull$$$0(10);
            }
            if ((info = this.getPrefixInfo(requireText, parent = this.myCallExpression.getParent())) == null) {
                return null;
            }
            return this.createImport(info, requireText);
        }

        @Nullable
        private ES6ImportDeclaration createImport(ES6ImportPsiUtil.CreateImportExportInfo importData, @NotNull String requireText) {
            if (requireText == null) {
                Worker.$$$reportNull$$$0(11);
            }
            JSSimpleImportDescriptor descriptor2 = new JSSimpleImportDescriptor(null, requireText, importData);
            ES6ImportDeclaration createdImport = (ES6ImportDeclaration)ES6ImportPsiUtil.createImportOrExport((PsiElement)this.myCallExpression, descriptor2);
            if (this.myImportInsertPlace == null) {
                this.myImportInsertPlace = new ImportInsertPlace(this.myTopElement, this.myCallExpression);
            }
            return this.myImportInsertPlace.insert(createdImport);
        }

        @Nullable
        private ES6ImportPsiUtil.CreateImportExportInfo getPrefixInfo(@NotNull String requireText, @Nullable PsiElement parent) {
            String prefixText;
            if (requireText == null) {
                Worker.$$$reportNull$$$0(12);
            }
            String string = prefixText = this.myOwnerVariable != null ? this.myOwnerVariable.getName() : this.calculateVariableName(requireText, true);
            if (parent instanceof JSReferenceExpression) {
                if (this.myFirstReferenceText == null) {
                    return null;
                }
                if ("default".equals(this.myFirstReferenceText)) {
                    return new ES6ImportPsiUtil.CreateImportExportInfo(prefixText);
                }
                ResolveResult[] results = ((JSReferenceExpression)parent).multiResolve(false);
                boolean isDefaultExport = Arrays.stream(results).anyMatch(result2 -> {
                    PsiElement element = result2.getElement();
                    if (!result2.isValidResult() || element == null) {
                        return false;
                    }
                    PsiElement resolvedParent = JSResolveUtil.findParent(element);
                    return resolvedParent != null && ES6ImportHandler.isExportedWithDefault(resolvedParent);
                });
                if (isDefaultExport) {
                    this.myHasReferenceTail = true;
                    this.myFirstReference = null;
                    return new ES6ImportPsiUtil.CreateImportExportInfo(this.calculateVariableName(requireText, false));
                }
                if (this.myHasReferenceTail || this.myFirstReferenceText.equals(prefixText)) {
                    return new ES6ImportPsiUtil.CreateImportExportInfo(this.myFirstReferenceText, null, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
                }
                return new ES6ImportPsiUtil.CreateImportExportInfo(this.myFirstReferenceText, prefixText, ES6ImportPsiUtil.ImportExportType.SPECIFIER);
            }
            return prefixText == null ? null : new ES6ImportPsiUtil.CreateImportExportInfo(prefixText);
        }

        private void init() {
            this.findTopElement();
            this.initFirstReference();
            this.lookupOwnerVariable();
        }

        private void initFirstReference() {
            PsiElement parent = this.myCallExpression.getParent();
            if (parent instanceof JSReferenceExpression) {
                String fullReferenceText = parent.getText();
                this.myFirstReference = parent;
                String callText = this.myCallExpression.getText();
                if (!fullReferenceText.startsWith(callText) || fullReferenceText.length() == callText.length()) {
                    return;
                }
                this.myFirstReferenceText = fullReferenceText.substring(callText.length() + 1);
            }
        }

        private void lookupOwnerVariable() {
            PsiElement current = this.myCallExpression.getParent();
            while (current instanceof JSReferenceExpression) {
                current = current.getParent();
            }
            if (current instanceof JSDestructuringElement && current.getParent() instanceof JSVarStatement && ((JSDestructuringElement)current).getInitializer() != null && PsiTreeUtil.isAncestor((PsiElement)((JSDestructuringElement)current).getInitializer(), (PsiElement)this.myCallExpression, (boolean)false)) {
                this.myDestructuringElement = (JSDestructuringElement)current;
            }
            PsiElement previous = null;
            current = this.myCallExpression.getParent();
            int refCnt = 0;
            while (current instanceof JSReferenceExpression || previous != null && current instanceof JSCallExpression && !Worker.isInCallArgumentsList(previous)) {
                if (current instanceof JSReferenceExpression) {
                    ++refCnt;
                }
                previous = current;
                current = current.getParent();
            }
            boolean bl = this.myHasReferenceTail = refCnt > 1 || refCnt == 1 && previous instanceof JSCallExpression;
            if (current instanceof JSVariable) {
                this.myOwnerVariable = (JSVariable)current;
            }
        }

        private static boolean isInCallArgumentsList(PsiElement current) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSCallExpression)current.getParent()).getArgumentList(), (PsiElement)current, (boolean)true);
        }

        private String calculateVariableName(@NotNull String requireText, boolean startWithFirstReference) {
            String varNameCandidate;
            if (requireText == null) {
                Worker.$$$reportNull$$$0(13);
            }
            if (this.myTopElement == null) {
                return null;
            }
            if (startWithFirstReference && this.myFirstReferenceText != null && !"default".equals(this.myFirstReferenceText)) {
                varNameCandidate = this.myFirstReferenceText;
            } else {
                String[] split = ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireText).split("/");
                varNameCandidate = split[0];
            }
            return JSChangeUtil.generateNewVarName(varNameCandidate, this.myTopElement);
        }

        private void findTopElement() {
            this.myTopElement = JSChangeUtil.getScopeElementInFile((PsiElement)this.myCallExpression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callExpression";
                    break;
                }
                case 1: 
                case 10: 
                case 11: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requireText";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingImports";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createdReferenceTarget";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "createdName";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryProcessAsDestructuring";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "insertImportIntoExistingRebind";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replaceWithReferenceToImport";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "deleteWithSpaces";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldMoveComments";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createImport";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPrefixInfo";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "calculateVariableName";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

