/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return !IntentionAndInspectionFilter.isInspectionSupportedForElement(toolId, element) || JSAnalysisHandlersFactory.forElement(element).getInspectionSuppressor().isSuppressedFor(element, toolId);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = JSAnalysisHandlersFactory.forElement(element).getInspectionSuppressor().getSuppressActions(element, toolId);
        if (suppressQuickFixArray == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @Nullable
    public static JSSuppressionHolder getHolderElement(@Nullable PsiElement element, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        PsiElement parent;
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(4);
        }
        if ((holder = (JSSuppressionHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{holderClass})) instanceof JSVarStatement && (parent = holder.getParent()) instanceof JSVariableDeclaringScope && parent instanceof JSSuppressionHolder) {
            holder = (JSSuppressionHolder)parent;
        }
        return holder;
    }

    @NotNull
    public static Class<? extends JSSuppressionHolder> getHolderClass(@Nullable PsiElement element) {
        return JSInspectionSuppressor.getHolderClass(element, JSSuppressionHolder.class);
    }

    @NotNull
    public static Class<? extends JSSuppressionHolder> getHolderClass(@Nullable PsiElement element, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(5);
        }
        Class<JSSuppressionHolder> clazz = (holder = JSInspectionSuppressor.getHolderElement(element, holderClass)) != null ? holder.getClass() : holderClass;
        if (clazz == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    @NotNull
    public static PsiElement getContainerToAnnotate(@NotNull JSSuppressionHolder holder) {
        if (holder == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(7);
        }
        JSSuppressionHolder container = holder instanceof JSExpression ? PsiTreeUtil.getParentOfType((PsiElement)holder, JSStatement.class) : holder;
        PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)container, (Object)holder);
        if (psiElement == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    public static boolean isSuppressedForElement(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(9);
        }
        return JSInspectionSuppressor.isSuppressedForElement(element, toolId, JSSuppressionHolder.class);
    }

    public static boolean isSuppressedForElement(@Nullable PsiElement element, @NotNull String toolId, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        String text;
        Matcher matcher;
        PsiElement prev;
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(10);
        }
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(11);
        }
        if ((prev = JSInspectionSuppressor.extractCommentFromHolder(element, holderClass)) == null) {
            return false;
        }
        return prev instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = prev.getText())).matches() && SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId);
    }

    @Nullable
    public static PsiElement extractCommentFromHolder(@Nullable PsiElement element, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(12);
        }
        if ((holder = JSInspectionSuppressor.getHolderElement(element, holderClass)) == null) {
            return null;
        }
        if (holder instanceof JSFile) {
            List<PsiComment> comments = JSInspectionSuppressor.getSuppressCandidatesForFile((JSFile)holder);
            for (PsiComment comment : comments) {
                if (!SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(comment.getText()).matches()) continue;
                return comment;
            }
            return null;
        }
        return PsiTreeUtil.skipWhitespacesBackward((PsiElement)JSInspectionSuppressor.getContainerToAnnotate(holder));
    }

    @NotNull
    public static List<PsiComment> getSuppressCandidatesForFile(@NotNull JSFile container) {
        PsiElement nextSibling;
        PsiElement child;
        if (container == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(13);
        }
        if ((child = container.getFirstChild()) instanceof PsiWhiteSpace && JSInspectionSuppressor.isAllowedElementBeforeFileSuppressComment(child)) {
            child = child.getNextSibling();
        }
        if (!(child instanceof PsiComment)) {
            List<PsiComment> list2 = Collections.emptyList();
            if (list2 == null) {
                JSInspectionSuppressor.$$$reportNull$$$0(14);
            }
            return list2;
        }
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        while (JSInspectionSuppressor.isAllowedElementBeforeFileSuppressComment(child)) {
            if (child instanceof PsiComment) {
                comments.add((PsiComment)child);
            }
            child = child.getNextSibling();
        }
        if (!comments.isEmpty() && (nextSibling = comments.get(comments.size() - 1).getNextSibling()) instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1) {
            comments.remove(comments.size() - 1);
        }
        ArrayList<PsiComment> arrayList = comments;
        if (arrayList == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    public static boolean isAllowedElementBeforeFileSuppressComment(PsiElement anchor) {
        return anchor instanceof PsiComment && !anchor.textContains('\n') || anchor instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)anchor.getText(), (char)'\n') <= 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSInspectionSuppressor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holderClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolderClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerToAnnotate";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressCandidatesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHolderElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHolderClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainerToAnnotate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedForElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractCommentFromHolder";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressCandidatesForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

