/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSwitchVariableDeclarationIssueInspection
extends JSInspection {
    public boolean ignoreNonBlockScope = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(JavaScriptBundle.message("js.variable.problems.ignore.desc", new Object[0]), (InspectionProfileEntry)this, "ignoreNonBlockScope");
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSwitchVariableDeclarationIssueInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSSwitchVariableDeclarationIssueInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSSwitchStatement(JSSwitchStatement node) {
                HashSet<String> varNames = new HashSet<String>();
                MultiMap declaredVars = MultiMap.createSet();
                for (JSCaseClause clause : node.getCaseClauses()) {
                    List<JSVariable> variables = this.collectDeclaredVars(clause, node);
                    for (JSVariable variable : variables) {
                        varNames.add(variable.getName());
                    }
                    declaredVars.put((Object)clause, variables);
                }
                for (JSCaseClause clause : node.getCaseClauses()) {
                    Set<JSVariable> usedVars = this.collectUsedVars(clause, varNames);
                    usedVars.removeAll(declaredVars.get((Object)clause));
                    if (usedVars.isEmpty()) continue;
                    for (JSVariable variable : usedVars) {
                        PsiElement nameIdentifier = variable.getNameIdentifier();
                        assert (nameIdentifier != null);
                        JSCaseClause clauseWhereDeclared = declaredVars.entrySet().stream().filter(e -> ((Collection)e.getValue()).contains(variable)).map(e -> (JSCaseClause)e.getKey()).findFirst().orElse(null);
                        if (clauseWhereDeclared == null) continue;
                        Object desc = JavaScriptBundle.message("js.variable.problems.inspection.desc", variable.getName(), this.getDesc(clauseWhereDeclared), this.getDesc(clause));
                        if (variable.hasBlockScope()) {
                            desc = (String)desc + ". " + JavaScriptBundle.message("js.variable.problems.inspection.desc.ref.error", new Object[0]);
                        }
                        holder.registerProblem(nameIdentifier, (String)desc, new LocalQuickFix[0]);
                    }
                }
            }

            private String getDesc(@Nullable JSCaseClause declared) {
                if (declared == null) {
                    return "???";
                }
                if (declared.isDefault()) {
                    return "default";
                }
                JSExpression expression = declared.getCaseExpression();
                return expression == null ? "???" : "case " + expression.getText();
            }

            private Set<JSVariable> collectUsedVars(JSCaseClause clause, Set<String> varNames) {
                HashSet<JSVariable> set = new HashSet<JSVariable>();
                for (JSSourceElement statement : clause.getStatementListItems()) {
                    SyntaxTraverser.psiTraverser((PsiElement)statement).filter(JSReferenceExpression.class).filter(e -> e.getQualifier() == null).filter(e -> varNames.contains(e.getReferenceName())).map(e -> e.resolve()).filter(JSVariable.class).forEach(set::add);
                }
                return set;
            }

            private List<JSVariable> collectDeclaredVars(JSCaseClause clause, JSSwitchStatement switchStatement) {
                ArrayList<JSVariable> allVars = new ArrayList<JSVariable>();
                for (JSSourceElement statement : clause.getStatementListItems()) {
                    List variables = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)statement).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSVariable.class).toList();
                    for (JSVariable variable : variables) {
                        if (!variable.hasBlockScope()) {
                            if (JSSwitchVariableDeclarationIssueInspection.this.ignoreNonBlockScope) continue;
                            allVars.add(variable);
                            continue;
                        }
                        PsiElement declarationScope = variable.getDeclarationScope();
                        if (declarationScope != switchStatement) continue;
                        allVars.add(variable);
                    }
                }
                return allVars;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSSwitchVariableDeclarationIssueInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

