/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.HtmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSUnresolvedLibraryURLInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(1);
        }
        return new XmlElementVisitor(){

            public void visitXmlAttribute(XmlAttribute attribute) {
                PsiReference libRef;
                XmlAttributeValue valueElement;
                if (("src".equals(attribute.getName()) && HtmlUtil.isScriptTag((XmlTag)attribute.getParent()) || "href".equals(attribute.getName()) && attribute.getParent() != null && "link".equals(attribute.getParent().getLocalName())) && (valueElement = attribute.getValueElement()) != null && JSLibraryUtil.containsLibURL(valueElement.getValue()) && ((libRef = JSLibReferenceResolver.getLibReference(valueElement)) == null || libRef.resolve() == null)) {
                    holder.registerProblem((PsiElement)valueElement, JSUnresolvedLibraryURLInspection.this.getDisplayName(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, attribute.getValueTextRange(), new LocalQuickFix[]{JSFixFactory.getInstance().downloadLibraryQuickFix()});
                }
            }
        };
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JavaScriptBundle.message("js.library.unresolved.url.inspection.name", new Object[0]);
        if (string == null) {
            JSUnresolvedLibraryURLInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSUnresolvedLibraryURLInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

