/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSPipeExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSPipeToCallChainIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(1);
        }
        JSPipeExpression pipe = JSPipeToCallChainIntention.findPipe(element);
        assert (pipe != null);
        while (pipe.getLOperand() instanceof JSPipeExpression) {
            pipe = (JSPipeExpression)pipe.getLOperand();
        }
        StringBuilder expressionBuilder = new StringBuilder(Objects.requireNonNull(pipe.getLOperand()).getText());
        JSPipeToCallChainIntention.appendPipe(pipe, expressionBuilder);
        JSPipeExpression parentPipe = JSPipeToCallChainIntention.findPipe(pipe.getParent());
        while (parentPipe != null && parentPipe.getLOperand() == pipe) {
            pipe = parentPipe;
            JSPipeToCallChainIntention.appendPipe(pipe, expressionBuilder);
            parentPipe = JSPipeToCallChainIntention.findPipe(parentPipe.getParent());
        }
        pipe.replace(JSPsiElementFactory.createJSExpression(expressionBuilder.toString(), element));
    }

    private static void appendPipe(JSPipeExpression pipeExpression, StringBuilder builder) {
        JSExpression rOperand = pipeExpression.getROperand();
        builder.insert(0, (String)(rOperand == null ? "" : rOperand.getText() + "("));
        builder.append(")");
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.intention.pipe.to.call.chain", new Object[0]);
        if (string == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        return JSPipeToCallChainIntention.findPipe(element) != null;
    }

    @Nullable
    private static JSPipeExpression findPipe(@NotNull PsiElement element) {
        JSPipeExpression pipeExpression;
        if (element == null) {
            JSPipeToCallChainIntention.$$$reportNull$$$0(6);
        }
        if ((pipeExpression = (JSPipeExpression)PsiTreeUtil.getParentOfType((PsiElement)element, JSPipeExpression.class, (boolean)false, (Class[])new Class[]{JSSourceElement.class})) == null || pipeExpression.getLOperand() == null || pipeExpression.getROperand() == null) {
            return null;
        }
        return pipeExpression;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSPipeToCallChainIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSPipeToCallChainIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPipe";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

