/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.nullPropagation;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElvisOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExpandNullPropagationIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        JSExpression expression;
        NullPropagationInfo nullPropagationInfo;
        if (project == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(1);
        }
        if ((nullPropagationInfo = JSExpandNullPropagationIntention.getNullPropagationInfo(expression = JSExpandNullPropagationIntention.findExpression(element))) == null) {
            return;
        }
        JSExpression thenExpr = nullPropagationInfo.thenExpr;
        JSExpression elseExpr = nullPropagationInfo.elseExpr;
        ArrayList<String> expressions = new ArrayList<String>();
        List<JSExpression> conditionExpressions = JSExpandNullPropagationIntention.getConditionExpressions(thenExpr);
        for (JSExpression expr : conditionExpressions) {
            JSExpression qualifier;
            if (!(expr instanceof JSElvisOwner) || !((JSElvisOwner)expr).isElvis() || (qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)expr)) == null) continue;
            expressions.add(qualifier.getText());
            JSChangeUtil.removeElvis((JSElvisOwner)expr);
        }
        if (nullPropagationInfo.isNullishCoalescing()) {
            String trailingExprText = ((JSExpression)ContainerUtil.getLastItem(conditionExpressions)).getText();
            if (nullPropagationInfo.isStrict) {
                expressions.add(String.format("%s != null", trailingExprText));
            } else {
                expressions.add(trailingExprText);
            }
        }
        String text = String.format("%s ? %s : %s", StringUtil.join(expressions, (String)" && "), thenExpr.getText(), elseExpr != null ? elseExpr.getText() : "undefined");
        expression.replace(JSPsiElementFactory.createJSExpression(text, (PsiElement)expression));
    }

    @NotNull
    private static List<JSExpression> getConditionExpressions(@NotNull JSExpression expression) {
        if (expression == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(2);
        }
        ArrayList<JSExpression> expressions = new ArrayList<JSExpression>();
        while (expression instanceof JSElvisOwner) {
            expressions.add(expression);
            expression = (JSExpression)ObjectUtils.tryCast((Object)JSPsiImplUtils.getElvisQualifier((JSElvisOwner)expression), JSElvisOwner.class);
        }
        if (expression instanceof JSThisExpression) {
            expressions.add(expression);
        }
        List list2 = ContainerUtil.reverse(expressions);
        if (list2 == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        String text;
        if (project == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(5);
        }
        if (!super.isAvailable(project, editor, element)) {
            return false;
        }
        JSExpression expression = JSExpandNullPropagationIntention.findExpression(element);
        NullPropagationInfo nullPropagationInfo = JSExpandNullPropagationIntention.getNullPropagationInfo(expression);
        if (nullPropagationInfo == null) {
            return false;
        }
        boolean isOptionalChaining = nullPropagationInfo.isOptionalChaining;
        boolean isNullishCoalescing = nullPropagationInfo.isNullishCoalescing();
        String string = text = nullPropagationInfo.isStrict ? JavaScriptBundle.message("javascript.intention.expand.opt.chain.and.nullish.coalescing", new Object[0]) : JavaScriptBundle.message("javascript.intention.expand.opt.chain.and.or.coalescing", new Object[0]);
        if (isOptionalChaining) {
            if (!isNullishCoalescing) {
                text = JavaScriptBundle.message("javascript.intention.expand.opt.chain", new Object[0]);
            }
        } else {
            text = nullPropagationInfo.isStrict ? JavaScriptBundle.message("javascript.intention.expand.nullish.coalescing", new Object[0]) : JavaScriptBundle.message("javascript.intention.expand.or.coalescing", new Object[0]);
        }
        this.setText(text);
        return true;
    }

    @Nullable
    private static JSExpression findExpression(@NotNull PsiElement element) {
        if (element == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(6);
        }
        PsiElement parent = element.getParent();
        JSExpression expression = null;
        if (parent instanceof JSLiteralExpression || parent instanceof JSArgumentList || parent instanceof JSThisExpression) {
            parent = parent.getParent();
        }
        if (parent instanceof JSElvisOwner) {
            expression = (JSExpression)ObjectUtils.tryCast((Object)PsiTreeUtil.findFirstParent((PsiElement)parent, el -> !(el.getParent() instanceof JSElvisOwner)), JSElvisOwner.class);
            if (expression == null) {
                return null;
            }
            parent = expression.getParent();
        }
        if (parent instanceof JSBinaryExpression) {
            IElementType sign = ((JSBinaryExpression)parent).getOperationSign();
            if (JSTokenTypes.ASSIGNMENT_OPERATIONS.contains(sign)) {
                return expression;
            }
            if (sign != JSTokenTypes.QUEST_QUEST && sign != JSTokenTypes.OROR) {
                return null;
            }
            if (((JSBinaryExpression)parent).getLOperand() instanceof JSBinaryExpression || ((JSBinaryExpression)parent).getROperand() instanceof JSBinaryExpression) {
                return null;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSBinaryExpression && !JSTokenTypes.ASSIGNMENT_OPERATIONS.contains(((JSBinaryExpression)grandParent).getOperationSign())) {
                return null;
            }
            expression = (JSBinaryExpression)parent;
        }
        return expression;
    }

    @Nullable
    private static NullPropagationInfo getNullPropagationInfo(@Nullable JSExpression expression) {
        if (expression == null) {
            return null;
        }
        JSExpression thenExpr = expression;
        JSExpression elseExpr = null;
        boolean isStrict = true;
        if (expression instanceof JSBinaryExpression) {
            thenExpr = ((JSBinaryExpression)expression).getLOperand();
            elseExpr = ((JSBinaryExpression)expression).getROperand();
            boolean bl = isStrict = ((JSBinaryExpression)expression).getOperationSign() == JSTokenTypes.QUEST_QUEST;
        }
        if (thenExpr == null) {
            return null;
        }
        boolean hasElvisOperators = false;
        JSExpression qualifier = thenExpr;
        while (qualifier instanceof JSElvisOwner) {
            if (qualifier instanceof JSCallExpression && (hasElvisOperators || elseExpr != null)) {
                return null;
            }
            if (((JSElvisOwner)qualifier).isElvis()) {
                hasElvisOperators = true;
            }
            qualifier = JSPsiImplUtils.getElvisQualifier((JSElvisOwner)qualifier);
        }
        return !(qualifier != null && !(qualifier instanceof JSThisExpression) || !hasElvisOperators && elseExpr == null) ? new NullPropagationInfo(thenExpr, elseExpr, hasElvisOperators, isStrict) : null;
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JavaScriptBundle.message("javascript.intention.expand.opt.chain.family", new Object[0]);
        if (string == null) {
            JSExpandNullPropagationIntention.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/nullPropagation/JSExpandNullPropagationIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/nullPropagation/JSExpandNullPropagationIntention";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionExpressions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConditionExpressions";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class NullPropagationInfo {
        @NotNull
        private final JSExpression thenExpr;
        @Nullable
        private final JSExpression elseExpr;
        private final boolean isOptionalChaining;
        private final boolean isStrict;

        private NullPropagationInfo(@NotNull JSExpression thenExpr, @Nullable JSExpression elseExpr, boolean isOptionalChaining, boolean isStrict) {
            if (thenExpr == null) {
                NullPropagationInfo.$$$reportNull$$$0(0);
            }
            this.thenExpr = thenExpr;
            this.elseExpr = elseExpr;
            this.isOptionalChaining = isOptionalChaining;
            this.isStrict = isStrict;
        }

        private boolean isNullishCoalescing() {
            return this.elseExpr != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thenExpr", "com/intellij/lang/javascript/intentions/nullPropagation/JSExpandNullPropagationIntention$NullPropagationInfo", "<init>"));
        }
    }
}

