/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.linter.AutodetectLinterPackage;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.lang.javascript.linter.eslint.EslintRequestData;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUnsavedConfigManager;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.LinterExecutionException;
import com.intellij.lang.javascript.linter.eslint.config.EslintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import icons.JavaScriptLanguageIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EsLintExternalRunner<TResult> {
    public static final Logger LOG = Logger.getInstance(EsLintExternalRunner.class);
    private final boolean myIsOnTheFly;
    private final EslintLanguageServiceClient myLanguageService;

    public EsLintExternalRunner(boolean isOnTheFly, @NotNull EslintLanguageServiceClient service) {
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(0);
        }
        this.myIsOnTheFly = isOnTheFly;
        this.myLanguageService = service;
    }

    @NotNull
    public static JSLinterAnnotationResult highlight(final @NotNull JSLinterInput<EslintState> input, final @NotNull EslintLanguageServiceClient service, boolean isOnTheFly) {
        JSLinterAnnotationResult jSLinterAnnotationResult;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(1);
        }
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(2);
        }
        final Ref bestGuessConfig = new Ref(null);
        EsLintExternalRunner<List<EslintError>> runner = new EsLintExternalRunner<List<EslintError>>(isOnTheFly, service){

            @Override
            @Nullable
            protected CompletableFuture<EslintLanguageServiceClient.Response<List<EslintError>>> performServiceRequest(@NotNull EslintRequestData requestData) {
                if (requestData == null) {
                    1.$$$reportNull$$$0(0);
                }
                bestGuessConfig.set((Object)((VirtualFile)ContainerUtil.getFirstItem(requestData.getPossibleConfigs())));
                return service.highlight(requestData, ((EslintState)input.getState()).getExtraOptions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner$1", "performServiceRequest"));
            }
        };
        try {
            List execute2 = (List)ObjectUtils.coalesce((Object)((List)runner.execute(input)), Collections.emptyList());
            jSLinterAnnotationResult = JSLinterAnnotationResult.createLinterResult(input, execute2, (VirtualFile)bestGuessConfig.get());
        }
        catch (LinterExecutionException e) {
            JSLinterAnnotationResult jSLinterAnnotationResult2 = JSLinterAnnotationResult.create(input, e.getAnnotation(), (VirtualFile)bestGuessConfig.get());
            if (jSLinterAnnotationResult2 == null) {
                EsLintExternalRunner.$$$reportNull$$$0(4);
            }
            return jSLinterAnnotationResult2;
        }
        if (jSLinterAnnotationResult == null) {
            EsLintExternalRunner.$$$reportNull$$$0(3);
        }
        return jSLinterAnnotationResult;
    }

    @Nullable
    public static String fixFile(final @NotNull JSLinterInput<EslintState> input, final @NotNull EslintLanguageServiceClient service) throws LinterExecutionException {
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(5);
        }
        if (service == null) {
            EsLintExternalRunner.$$$reportNull$$$0(6);
        }
        EsLintExternalRunner<String> runner = new EsLintExternalRunner<String>(false, service){

            @Override
            @Nullable
            protected Future<EslintLanguageServiceClient.Response<String>> performServiceRequest(@NotNull EslintRequestData requestData) {
                if (requestData == null) {
                    2.$$$reportNull$$$0(0);
                }
                return service.fixFile(requestData, ((EslintState)input.getState()).getExtraOptions());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestData", "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner$2", "performServiceRequest"));
            }
        };
        return (String)runner.execute(input);
    }

    @Nullable
    protected abstract Future<EslintLanguageServiceClient.Response<TResult>> performServiceRequest(@NotNull EslintRequestData var1);

    @Nullable
    private TResult eslint(@NotNull JSLinterInput<EslintState> input, @NotNull EslintRequestData requestData) throws LinterExecutionException {
        String error;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(7);
        }
        if (requestData == null) {
            EsLintExternalRunner.$$$reportNull$$$0(8);
        }
        Future<EslintLanguageServiceClient.Response<TResult>> future = this.performServiceRequest(requestData);
        EslintLanguageServiceClient.Response<TResult> result2 = null;
        try {
            result2 = JSLanguageServiceUtil.awaitLanguageService(future, this.myLanguageService, requestData.getFileToLint());
            error = result2 == null ? JavaScriptBundle.message("javascript.language.service.cannot.get.results", new Object[0]) : result2.globalError;
        }
        catch (ExecutionException e) {
            error = e.getMessage();
        }
        if (error != null && !EsLintExternalRunner.suppressNoConfigError(result2, input.getState().getNodePackageRef(), requestData)) {
            throw new LinterExecutionException(EsLintExternalRunner.createFileLevelAnnotation(input, error));
        }
        return result2 != null ? (TResult)result2.value : null;
    }

    private static boolean suppressNoConfigError(@Nullable EslintLanguageServiceClient.Response result2, @NotNull NodePackageRef configuredPackage, @NotNull EslintRequestData requestData) {
        if (configuredPackage == null) {
            EsLintExternalRunner.$$$reportNull$$$0(9);
        }
        if (requestData == null) {
            EsLintExternalRunner.$$$reportNull$$$0(10);
        }
        return result2 != null && result2.isNoConfigFile && (configuredPackage == AutodetectLinterPackage.INSTANCE || requestData.getFileKind() != EslintUtil.FileKind.JavaScriptAndOther);
    }

    @NotNull
    private static JSLinterFileLevelAnnotation createFileLevelAnnotation(@NotNull JSLinterInput input, @NotNull @InspectionMessage String error) {
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(11);
        }
        if (error == null) {
            EsLintExternalRunner.$$$reportNull$$$0(12);
        }
        ProcessOutput output = new ProcessOutput();
        output.appendStderr(error);
        List meaningfulLines = Arrays.stream(StringUtil.splitByLines((String)error)).map(s -> s.trim()).filter(string -> {
            if (StringUtil.isEmpty((String)string)) {
                return false;
            }
            return !FileUtil.isAbsolute((String)string) && (!string.endsWith(":") || !FileUtil.isAbsolute((String)string.substring(0, string.length() - 1)));
        }).collect(Collectors.toList());
        IntentionAction detailsAction = meaningfulLines.size() > 1 ? JSLinterUtil.createDetailsAction(input.getProject(), input.getVirtualFile(), null, output, JavaScriptLanguageIcons.FileTypes.Eslint) : null;
        JSLinterFileLevelAnnotation annotation = detailsAction == null ? new JSLinterFileLevelAnnotation(error) : new JSLinterFileLevelAnnotation(error, detailsAction);
        annotation.setShortMessage((String)ContainerUtil.getFirstItem(meaningfulLines));
        JSLinterFileLevelAnnotation jSLinterFileLevelAnnotation = annotation.withIcon(JavaScriptLanguageIcons.FileTypes.Eslint);
        if (jSLinterFileLevelAnnotation == null) {
            EsLintExternalRunner.$$$reportNull$$$0(13);
        }
        return jSLinterFileLevelAnnotation;
    }

    @Nullable
    public TResult execute(@NotNull JSLinterInput<EslintState> input) throws LinterExecutionException {
        VirtualFile specifiedConfigFile;
        NodePackage resolvedNodePackage;
        EslintState state2;
        NodeJsInterpreter nodeInterpreter;
        VirtualFile fileToLint;
        if (input == null) {
            EsLintExternalRunner.$$$reportNull$$$0(14);
        }
        if (!(fileToLint = input.getVirtualFile()).isValid() || fileToLint.getParent() == null) {
            return null;
        }
        Project project = input.getProject();
        JSLinterFileLevelAnnotation error = JSLinterUtil.validateInterpreterAndPackage(project, nodeInterpreter = (state2 = input.getState()).getInterpreterRef().resolve(project), resolvedNodePackage = this.myLanguageService.getNodePackage(), "eslint", fileToLint);
        if (error != null) {
            throw new LinterExecutionException(error);
        }
        SemVer packageVersion = resolvedNodePackage.getVersion();
        if (packageVersion != null && packageVersion.getMajor() < 1) {
            String message = JavaScriptBundle.message("eslint.version.0.is.not.supported.please.upgrade.eslint", packageVersion.getRawVersion());
            throw new LinterExecutionException(new JSLinterFileLevelAnnotation(message));
        }
        try {
            if (!StringUtil.isEmptyOrSpaces((String)state2.getAdditionalRulesDirPath())) {
                JSLinterUtil.checkPath(state2.getAdditionalRulesDirPath(), true, JavaScriptBundle.message("eslint.additional.rules.directory.field.name", new Object[0]));
            }
            specifiedConfigFile = state2.isCustomConfigFileUsed() ? JSLinterUtil.checkPath(state2.getCustomConfigFilePath(), false, JavaScriptBundle.message("eslint.configuration.file.field.name", new Object[0])) : null;
        }
        catch (ExecutionException e) {
            throw new LinterExecutionException(new JSLinterFileLevelAnnotation(e.getMessage()));
        }
        EslintRequestData requestData = (EslintRequestData)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            if (this.myIsOnTheFly) {
                EslintConfigFileChangeTracker.getInstance(project).startIfNeeded();
            }
            VirtualFile eslintIgnoreFile = EslintUtil.lookupIgnoreFile(fileToLint, this.myLanguageService.getWorkingDirectory());
            Collection<VirtualFile> possibleConfigs = EsLintExternalRunner.findPossibleConfigs(specifiedConfigFile, fileToLint, eslintIgnoreFile);
            if (this.myIsOnTheFly && !EslintUnsavedConfigManager.getInstance(project).requestSaveIfNeeded(possibleConfigs)) {
                LOG.debug("ESLint postponed because of unsaved configs");
                return null;
            }
            EslintUtil.FileKind fileKind = EslintUtil.getFileKind(input.getPsiFile());
            if (fileKind == null) {
                LOG.debug(String.format("Ignoring file %s because of unknown kind", input.getPsiFile().getName()));
                return null;
            }
            return new EslintRequestData(fileToLint, fileKind, input.getFileContent(), specifiedConfigFile, possibleConfigs, eslintIgnoreFile);
        });
        return requestData == null ? null : (TResult)this.eslint(input, requestData);
    }

    @NotNull
    private static Collection<VirtualFile> findPossibleConfigs(@Nullable VirtualFile specifiedConfigFile, @NotNull VirtualFile fileToLint, @Nullable VirtualFile eslintIgnoreFile) {
        if (fileToLint == null) {
            EsLintExternalRunner.$$$reportNull$$$0(15);
        }
        LinkedHashSet<VirtualFile> configs = new LinkedHashSet<VirtualFile>();
        if (specifiedConfigFile != null) {
            configs.add(specifiedConfigFile);
        } else {
            configs.addAll(EslintUtil.findAllConfigsWithPackageJsonUpFileSystem(fileToLint));
        }
        if (EslintUtil.isEslintConfigFile(fileToLint)) {
            configs.remove(fileToLint);
        }
        if (eslintIgnoreFile != null) {
            configs.add(eslintIgnoreFile);
        }
        LinkedHashSet<VirtualFile> linkedHashSet = configs;
        if (linkedHashSet == null) {
            EsLintExternalRunner.$$$reportNull$$$0(16);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestData";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuredPackage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintExternalRunner";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "highlight";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileLevelAnnotation";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findPossibleConfigs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "eslint";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suppressNoConfigError";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFileLevelAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findPossibleConfigs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

