/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.EslintUtil;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.lang.javascript.linter.eslint.LinterExecutionException;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.LineSeparator;
import icons.JavaScriptLanguageIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintFixAction
extends JSLinterFixAction {
    public EsLintFixAction() {
        super(JavaScriptBundle.messagePointer("settings.javascript.linters.eslint.configurable.name", new Object[0]), JavaScriptBundle.messagePointer("eslint.action.fix.problems.description", new Object[0]), JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    protected EsLintFixAction(@NotNull Supplier<String> message, @NotNull Supplier<String> description2) {
        if (message == null) {
            EsLintFixAction.$$$reportNull$$$0(0);
        }
        if (description2 == null) {
            EsLintFixAction.$$$reportNull$$$0(1);
        }
        super(message, description2, null);
    }

    @Override
    @NotNull
    protected JSLinterConfiguration getConfiguration(@NotNull Project project) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(2);
        }
        EslintConfiguration eslintConfiguration = EslintConfiguration.getInstance(project);
        if (eslintConfiguration == null) {
            EsLintFixAction.$$$reportNull$$$0(3);
        }
        return eslintConfiguration;
    }

    @Override
    protected boolean shouldSaveBeforeToolInvocation(@Nullable VirtualFile file2) {
        return file2 != null && (EslintUtil.isEslintConfigFile(file2) || PackageJsonUtil.isPackageJsonFile(file2));
    }

    @Override
    protected boolean isFileAccepted(@NotNull Project project, @NotNull VirtualFile file2) {
        PsiFile psiFile;
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            EsLintFixAction.$$$reportNull$$$0(5);
        }
        return (psiFile = PsiManager.getInstance((Project)project).findFile(file2)) != null && EslintUtil.isPossiblyAcceptableFileType(psiFile);
    }

    @Override
    protected boolean needRefreshFilesAfter() {
        return false;
    }

    @Nullable
    protected String fixFile(@NotNull PsiFile psiFile) throws LinterExecutionException {
        if (psiFile == null) {
            EsLintFixAction.$$$reportNull$$$0(6);
        }
        EslintState state2 = (EslintState)EslintConfiguration.getInstance(psiFile.getProject()).getExtendedState().getState();
        JSLinterInput<EslintState> input = JSLinterInput.create(psiFile, state2, null);
        EslintLanguageServiceManager languageServiceManager = EslintLanguageServiceManager.getInstance(input.getProject());
        return languageServiceManager.useService(input.getVirtualFile(), input.getState().getNodePackageRef(), service -> {
            if (service == null) {
                return null;
            }
            return EsLintExternalRunner.fixFile(input, service);
        });
    }

    @Override
    protected Task createTask(final @NotNull Project project, final @NotNull Collection<? extends VirtualFile> filesToProcess, @NotNull Runnable completeCallback, boolean modalProgress) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(7);
        }
        if (filesToProcess == null) {
            EsLintFixAction.$$$reportNull$$$0(8);
        }
        if (completeCallback == null) {
            EsLintFixAction.$$$reportNull$$$0(9);
        }
        final String linterName = JavaScriptBundle.message("settings.javascript.linters.eslint.configurable.name", new Object[0]);
        return new JSLinterReformatterTask(project, linterName, filesToProcess, completeCallback){
            private final List<Pair<PsiFile, String>> myFilesAndResults;
            {
                super(project3, linterName2, roots, completeCallback);
                this.myFilesAndResults = new ArrayList<Pair<PsiFile, String>>(filesToProcess.size());
            }

            @Override
            protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document2) {
                if (psiFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                VirtualFile file2 = psiFile.getVirtualFile();
                try {
                    this.myFilesAndResults.add((Pair<PsiFile, String>)Pair.create((Object)psiFile, (Object)EsLintFixAction.this.fixFile(psiFile)));
                }
                catch (LinterExecutionException e) {
                    this.error(file2, e.getAnnotation().getMessage(), new IntentionAction[0]);
                }
            }

            @Override
            protected void doOnSuccess() {
                String message = JavaScriptBundle.message("javascript.linter.action.fix.problems.name", linterName);
                for (Pair<PsiFile, String> fileAndResult : this.myFilesAndResults) {
                    PsiFile psiFile = (PsiFile)fileAndResult.first;
                    String result2 = (String)fileAndResult.second;
                    VirtualFile file2 = psiFile.getVirtualFile();
                    Document document2 = FileDocumentManager.getInstance().getDocument(file2);
                    if (result2 == null || document2 == null) continue;
                    LineSeparator newLineSeparator = StringUtil.detectSeparators((CharSequence)result2);
                    String newLineSeparatorString = newLineSeparator != null ? newLineSeparator.getSeparatorString() : null;
                    String documentContent = StringUtil.convertLineSeparators((String)result2);
                    WriteCommandAction.runWriteCommandAction((Project)project, (String)message, null, () -> {
                        document2.setText((CharSequence)documentContent);
                        if (newLineSeparatorString != null && !StringUtil.equals((CharSequence)file2.getDetectedLineSeparator(), (CharSequence)newLineSeparatorString)) {
                            AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)file2, (String)newLineSeparatorString);
                            DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                        }
                    }, (PsiFile[])new PsiFile[0]);
                }
                super.doOnSuccess();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "psiFile";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "document";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction$1";
                objectArray[2] = "runLinter";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.createTask(modalProgress);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fixFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

