/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.linter.JSLinterFixSingleErrorBaseAction;
import com.intellij.lang.javascript.linter.eslint.EslintError;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EslintFixSingleErrorAction
extends JSLinterFixSingleErrorBaseAction {
    @NotNull
    private final EslintError.FixInfo myFixInfo;

    public EslintFixSingleErrorAction(@NotNull @IntentionName String toolName, @NotNull PsiFile file2, @NotNull EslintError.FixInfo fixInfo, @Nullable String errorCode, long modificationStamp) {
        if (toolName == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(1);
        }
        if (fixInfo == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(2);
        }
        super(toolName, file2, errorCode, modificationStamp);
        this.myFixInfo = fixInfo;
    }

    @Override
    @NotNull
    public String getText() {
        if (this.myFixInfo.description != null) {
            String string = this.myToolName + ": " + this.myFixInfo.description;
            if (string == null) {
                EslintFixSingleErrorAction.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = super.getText();
        if (string == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(5);
        }
        return super.isAvailable(project, editor, file2) && !StringUtil.equals((CharSequence)this.myErrorCode, (CharSequence)"linebreak-style");
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(6);
        }
        if (!this.isAvailable(project, editor, file2)) {
            return;
        }
        Document document2 = editor.getDocument();
        String separator = FileDocumentManager.getInstance().getLineSeparator(file2.getViewProvider().getVirtualFile(), project);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)this.getText(), null, () -> EslintFixSingleErrorAction.applyReplacement(document2, separator, this.myFixInfo), (PsiFile[])new PsiFile[0]);
        DaemonCodeAnalyzer.getInstance((Project)project).restart(file2);
    }

    private static void applyReplacement(@NotNull Document document2, @NotNull String separator, @NotNull EslintError.FixInfo fixInfo) {
        String lf;
        if (document2 == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(7);
        }
        if (separator == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(8);
        }
        if (fixInfo == null) {
            EslintFixSingleErrorAction.$$$reportNull$$$0(9);
        }
        if ((lf = LineSeparator.LF.getSeparatorString()).equals(separator)) {
            document2.replaceString(fixInfo.startOffset, fixInfo.endOffset, (CharSequence)fixInfo.replacementText);
        } else {
            StringBuilder result2 = new StringBuilder(StringUtil.convertLineSeparators((String)document2.getText(), (String)separator));
            result2.replace(fixInfo.startOffset, fixInfo.endOffset, fixInfo.replacementText);
            document2.setText((CharSequence)StringUtilRt.convertLineSeparators((String)result2.toString(), (String)lf));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixInfo";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintFixSingleErrorAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintFixSingleErrorAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

