/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint.filter;

import com.intellij.execution.filters.FileHyperlinkRawData;
import com.intellij.execution.filters.FileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternBasedFileHyperlinkRawDataFinder;
import com.intellij.execution.filters.PatternHyperlinkFormat;
import com.intellij.execution.filters.PatternHyperlinkPart;
import com.intellij.lang.javascript.linter.eslint.filter.EslintErrorFilterState;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EslintErrorLinkFinder
implements FileHyperlinkRawDataFinder {
    private static final PatternBasedFileHyperlinkRawDataFinder LINE_FINDER = new PatternBasedFileHyperlinkRawDataFinder(new PatternHyperlinkFormat[]{new PatternHyperlinkFormat(Pattern.compile("^\\s+((\\d+):(\\d+)\\s+(error|warning))\\s.*$"), false, false, new PatternHyperlinkPart[]{PatternHyperlinkPart.HYPERLINK, PatternHyperlinkPart.LINE, PatternHyperlinkPart.COLUMN, PatternHyperlinkPart.PATH})});

    @Nullable
    public EslintErrorFilterState nextState(@NotNull String line, @Nullable EslintErrorFilterState prevState) {
        List links;
        String filePath;
        if (line == null) {
            EslintErrorLinkFinder.$$$reportNull$$$0(0);
        }
        if (OSAgnosticPathUtil.isAbsolute((String)line)) {
            String filePath2 = line.trim();
            return new EslintErrorFilterState(line, filePath2, prevState, Collections.emptyList());
        }
        if (prevState != null && (filePath = prevState.getFilePath()) != null && !(links = LINE_FINDER.find(line)).isEmpty()) {
            return new EslintErrorFilterState(line, prevState.getFilePath(), prevState, ContainerUtil.map((Collection)links, data -> new FileHyperlinkRawData(filePath, data.getDocumentLine(), data.getDocumentColumn(), data.getHyperlinkStartInd(), data.getHyperlinkEndInd())));
        }
        if (prevState == null || prevState.getFilePath() == null) {
            return null;
        }
        return new EslintErrorFilterState(line, null, prevState, Collections.emptyList());
    }

    @NotNull
    public List<FileHyperlinkRawData> find(@NotNull String line) {
        if (line == null) {
            EslintErrorLinkFinder.$$$reportNull$$$0(1);
        }
        List<FileHyperlinkRawData> list2 = Collections.emptyList();
        if (list2 == null) {
            EslintErrorLinkFinder.$$$reportNull$$$0(2);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/filter/EslintErrorLinkFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/filter/EslintErrorLinkFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "nextState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

