/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports;

import com.intellij.lang.javascript.dialects.JSHandlersFactory;
import com.intellij.lang.javascript.modules.imports.JSAddImportExecutor;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public interface JSImportCandidate
extends Iconable {
    public static final int EXPORTED_CONTEXTLESS_PRIORITY = 0;
    public static final int DEFAULT_PRIORITY = 1;
    public static final int HARDCODED_PRIORITY = 2;
    public static final int EXISTING_IMPORT_PRIORITY = 3;

    @NlsSafe
    @NotNull
    public String getName();

    @Nullable
    public JSElement getElement();

    public boolean useAutoImport();

    @NotNull
    public List<JSImportDescriptor> getDescriptors();

    @NotNull
    public SourceType getSourceType();

    @Nullable
    default public VirtualFile getElementFile() {
        return PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
    }

    @Nullable
    default public Icon getIcon(@Iconable.IconFlags int flags) {
        JSElement element = this.getElement();
        return element != null ? element.getIcon(flags) : null;
    }

    default public int getPriority() {
        return 1;
    }

    @Nullable
    default public JSImportDescriptor getSingleDescriptorOrNull() {
        List<JSImportDescriptor> descriptors = this.getDescriptors();
        return descriptors.size() == 1 ? descriptors.get(0) : null;
    }

    @NotNull
    default public String getContainerText() {
        VirtualFile file2 = this.getElementFile();
        if (file2 == null) {
            return "";
        }
        List<JSImportDescriptor> descriptors = this.getDescriptors();
        JSImportDescriptor item = (JSImportDescriptor)ContainerUtil.getFirstItem(descriptors);
        if (item == null) {
            return "";
        }
        String suffix = descriptors.size() > 1 ? "." + this.getName() : "";
        String string = JSImportCandidate.getContainerForDescriptor(item) + suffix;
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    private static String getContainerForDescriptor(JSImportDescriptor item) {
        JSModuleDescriptor moduleDescriptor = item.getModuleDescriptor();
        PsiElement module = moduleDescriptor.getModule();
        if (module instanceof JSFile && !((JSFile)module).isCommonJSModule()) {
            String string = ((JSFile)module).getName();
            if (string == null) {
                JSImportCandidate.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = "\"" + item.getModuleName() + "\"";
        if (string == null) {
            JSImportCandidate.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    default public JSAddImportExecutor createExecutor(@Nullable Editor editor, @NotNull PsiElement place) {
        if (place == null) {
            JSImportCandidate.$$$reportNull$$$0(3);
        }
        JSAddImportExecutor jSAddImportExecutor = JSHandlersFactory.forElement(place).createAddImportExecutor(editor, place);
        if (jSAddImportExecutor == null) {
            JSImportCandidate.$$$reportNull$$$0(4);
        }
        return jSAddImportExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/JSImportCandidate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerForDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/JSImportCandidate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SourceType {
        COMMONJS,
        ES6;

    }
}

