/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.providers;

import com.intellij.lang.ecmascript6.psi.impl.JSImportScope;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.providers.ES6ExportedCandidatesProvider;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonJSCandidatesProvider
extends JSImportCandidatesBase {
    @Nullable
    private MultiMap<String, JSElement> myLocal;

    public CommonJSCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
    }

    @NotNull
    private MultiMap<String, JSElement> getLocals() {
        MultiMap<String, JSElement> local = this.myLocal;
        if (local == null) {
            PsiElement place = this.myPlaceInfo.getPlace();
            JSImportScope scope = new JSImportScope(place.getProject(), this.myPlaceInfo.getFile(), JSResolveUtil.getResolveScope(place), JSModuleStatusOwner.ModuleStatus.COMMONJS);
            Collection<JSPsiElementBase> candidates = JSClassResolver.getInstance().findNamespaceMembersIncludingLocal("exports", (GlobalSearchScope)scope);
            MultiMap<String, JSElement> multiMap = this.fillLocals(this.myPlaceInfo.getPlace(), candidates);
            if (multiMap == null) {
                CommonJSCandidatesProvider.$$$reportNull$$$0(1);
            }
            return multiMap;
        }
        MultiMap<String, JSElement> multiMap = local;
        if (multiMap == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @NotNull
    public MultiMap<String, JSElement> fillLocals(PsiElement place, Collection<JSPsiElementBase> candidates) {
        MultiMap local = MultiMap.create();
        for (JSPsiElementBase candidate : candidates) {
            ProgressManager.checkCanceled();
            String name = candidate.getName();
            if (!JSNamesValidation.isIdentifier(name, place)) continue;
            local.putValue((Object)name, (Object)candidate);
        }
        this.myLocal = local;
        MultiMap multiMap = local;
        if (multiMap == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(3);
        }
        return multiMap;
    }

    @Override
    public boolean processCandidates(@NotNull String ref, @NotNull JSCandidatesProcessor processor, boolean forCompletion) {
        if (ref == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(5);
        }
        Collection bases = this.getLocals().get((Object)ref);
        StreamEx.of((Collection)bases).nonNull().flatMap(el -> ES6ExportedCandidatesProvider.createCandidates(ref, el, this.myPlaceInfo, true)).forEach(processor::processCandidate);
        return true;
    }

    @Override
    @NotNull
    public Set<String> getNames(@NotNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(6);
        }
        Set set = ((StreamEx)StreamEx.of((Collection)this.getLocals().keySet()).filter(keyFilter)).nonNull().toSet();
        if (set == null) {
            CommonJSCandidatesProvider.$$$reportNull$$$0(7);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocals";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "fillLocals";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processCandidates";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Override
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.importContext() != JSImportPlaceInfo.ImportContext.SIMPLE || DialectDetector.isTypeScript(placeInfo.getPlace()) || placeInfo.isStrictTypeContext()) {
                return null;
            }
            return new CommonJSCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/lang/javascript/modules/imports/providers/CommonJSCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

