/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.impl.TypeScriptClassBase;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.stubs.TypeScriptInterfaceStub;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptInterfaceImpl
extends TypeScriptClassBase<TypeScriptInterfaceStub>
implements TypeScriptInterface {
    private static final String CALL_SIGNATURE_NAME_HOLDER = "CALL^SIGNATURE";
    private volatile String myName;

    public TypeScriptInterfaceImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptInterfaceImpl(TypeScriptInterfaceStub stub) {
        super(stub, JSStubElementTypes.TYPESCRIPT_INTERFACE);
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String newName) throws IncorrectOperationException {
        if (newName == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(0);
        }
        this.myName = null;
        return super.setName(newName);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(1);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptInterface(this);
        } else {
            super.accept(visitor);
        }
    }

    @Override
    public String getName() {
        TypeScriptInterfaceStub stub = (TypeScriptInterfaceStub)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        String name = this.myName;
        if (name != null) {
            return name;
        }
        this.myName = name = super.getName();
        return name;
    }

    @Override
    public int getTextOffset() {
        ASTNode node = this.findNameIdentifier();
        return node == null ? super.getTextOffset() : node.getStartOffset();
    }

    @Override
    @Nullable
    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Override
    public TypeScriptObjectType getBody() {
        return (TypeScriptObjectType)this.getStubOrPsiChild(TypeScriptElementTypes.OBJECT_TYPE);
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public JSClass @NotNull [] getSupers() {
        JSClass[] jSClassArray = this.getSuperClasses();
        if (jSClassArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(2);
        }
        return jSClassArray;
    }

    @Override
    public JSFunction @NotNull [] getFunctions() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSFunction.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(3);
            }
            return JSFunction.EMPTY_ARRAY;
        }
        JSFunction[] jSFunctionArray = (JSFunction[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSFunction).toArray(JSFunction[]::new);
        if (jSFunctionArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(4);
        }
        return jSFunctionArray;
    }

    @Override
    public JSField @NotNull [] getFields() {
        TypeScriptObjectType body = this.getBody();
        if (body == null) {
            if (JSField.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(5);
            }
            return JSField.EMPTY_ARRAY;
        }
        JSField[] jSFieldArray = (JSField[])Arrays.stream(body.getTypeMembers()).filter(el -> el instanceof JSField).toArray(JSField[]::new);
        if (jSFieldArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(6);
        }
        return jSFieldArray;
    }

    @Override
    protected TypeScriptIndexSignature @NotNull [] getIndexSignatures() {
        if (this.getBody() == null) {
            if (TypeScriptIndexSignature.EMPTY_ARRAY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(7);
            }
            return TypeScriptIndexSignature.EMPTY_ARRAY;
        }
        TypeScriptIndexSignature[] typeScriptIndexSignatureArray = this.getBody().getIndexSignatures();
        if (typeScriptIndexSignatureArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(8);
        }
        return typeScriptIndexSignatureArray;
    }

    @Override
    @Nullable
    public JSFunction findFunctionByNameAndKind(@Nullable String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            return null;
        }
        return super.findFunctionByNameAndKind(name, kind);
    }

    @Override
    public TypeScriptFunction @NotNull [] findFunctionsByNameAndKind(String name, JSFunction.FunctionKind kind) {
        if (kind != JSFunction.FunctionKind.SIMPLE) {
            if (TypeScriptFunction.EMPTY == null) {
                TypeScriptInterfaceImpl.$$$reportNull$$$0(9);
            }
            return TypeScriptFunction.EMPTY;
        }
        TypeScriptFunction[] typeScriptFunctionArray = super.findFunctionsByNameAndKind(name, kind);
        if (typeScriptFunctionArray == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(10);
        }
        return typeScriptFunctionArray;
    }

    @Override
    @Nullable
    public JSFunction getConstructor() {
        return null;
    }

    @Override
    @Nullable
    public JSAttributeList getAttributeList() {
        return (JSAttributeList)this.getStubOrPsiChild(JSStubElementTypes.ATTRIBUTE_LIST);
    }

    @Override
    @NotNull
    public Iterable<? extends JSElement> getMembers() {
        TypeScriptObjectType body = this.getBody();
        List<Object> list2 = body != null ? Arrays.asList(body.getTypeMembers()) : Collections.emptyList();
        if (list2 == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(11);
        }
        return list2;
    }

    @Override
    @NotNull
    public JSElementBase.ClassOrInterface isClassOrInterface() {
        JSElementBase.ClassOrInterface classOrInterface = JSElementBase.ClassOrInterface.INTERFACE;
        if (classOrInterface == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(12);
        }
        return classOrInterface;
    }

    @Override
    public boolean hasCallSignature() {
        return this.findFunctionByName(CALL_SIGNATURE_NAME_HOLDER) != null;
    }

    @Override
    protected String getMethodName(@NotNull JSFunction function2) {
        if (function2 == null) {
            TypeScriptInterfaceImpl.$$$reportNull$$$0(13);
        }
        if (function2 instanceof TypeScriptCallSignature) {
            return CALL_SIGNATURE_NAME_HOLDER;
        }
        return super.getMethodName(function2);
    }

    @Override
    protected void clearCachesSync() {
        super.clearCachesSync();
        this.myName = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptInterfaceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctions";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexSignatures";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findFunctionsByNameAndKind";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembers";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "isClassOrInterface";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

