/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.evaluation.JSCodeBasedTypeFactory;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.resolve.JSCompleteTypeEvaluationProcessor;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluableTypeResolver;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluatorComplexityTracker;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluationResultProcessor;
import com.intellij.lang.javascript.psi.types.JSPsiBasedTypeOfType;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluationCache {
    private static final Key<JSEvaluationCache> CACHE_KEY_EXPRESSION_TYPE = Key.create((String)"js.evaluator.expression.type");
    private static final CacheProviderExpressionType CACHE_PROVIDER_EXPRESSION_TYPE = new CacheProviderExpressionType();
    @NotNull
    private final Map<JSEvaluateContext, SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>>> myResults = ContainerUtil.createConcurrentSoftMap();

    @Nullable
    public static JSTypeEvaluationResult getElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context) {
        JSEvaluationCache data;
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(0);
        }
        if (context == null) {
            JSEvaluationCache.$$$reportNull$$$0(1);
        }
        if ((data = (JSEvaluationCache)element.getUserData(CACHE_KEY_EXPRESSION_TYPE)) == null) {
            data = new JSEvaluationCache();
            element.putUserData(CACHE_KEY_EXPRESSION_TYPE, (Object)data);
        }
        return data.doGetElementType(element, context);
    }

    @Nullable
    private JSTypeEvaluationResult doGetElementType(@NotNull PsiElement element, @NotNull JSEvaluateContext context) {
        if (element == null) {
            JSEvaluationCache.$$$reportNull$$$0(2);
        }
        if (context == null) {
            JSEvaluationCache.$$$reportNull$$$0(3);
        }
        JSEvaluationRecursionGuard.JSEvaluationKey evaluationKey = new JSEvaluationRecursionGuard.JSEvaluationKey(element, context, CACHE_PROVIDER_EXPRESSION_TYPE.getClass());
        return JSEvaluationRecursionGuard.getGuard().getCachedValue(evaluationKey, JSEvaluatorComplexityTracker.getDefaultInstance(), () -> {
            SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue<JSTypeEvaluationResult>> value = this.myResults.get(context);
            return value != null ? value.getUpToDateOrNull() : null;
        }, value -> this.myResults.put(context, new SoftlyCachedValue<JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue>((JSComplexityAwareRecursionGuard.JSComplexityAwareCachedValue)value, (ModificationTracker)PsiModificationTracker.SERVICE.getInstance((Project)element.getProject()))), key -> CACHE_PROVIDER_EXPRESSION_TYPE.apply((PsiElement)key.myElement, key.myContext));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doGetElementType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class CacheProviderExpressionType
    implements BiFunction<PsiElement, JSEvaluateContext, JSTypeEvaluationResult> {
        private CacheProviderExpressionType() {
        }

        @Override
        public JSTypeEvaluationResult apply(PsiElement element, JSEvaluateContext context) {
            JSPsiBasedTypeOfType type = JSCodeBasedTypeFactory.getPsiBasedType(element, context);
            JSTypeEvaluationResult result2 = JSEvaluableTypeResolver.FOR_CACHING.doUnwrapRecursively(type, false, context);
            JSTypeEvaluationResultProcessor processor = new JSTypeEvaluationResultProcessor();
            result2.applyToProcessor(new JSCompleteTypeEvaluationProcessor(processor, JSEvaluableTypeResolver.FOR_CACHING));
            return processor.getResult();
        }
    }
}

