/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSResolvedTypeId;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSComplexityAwareRecursionGuard;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSEvaluationLogger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSEvaluationRecursionGuard {
    private static final JSComplexityAwareRecursionGuard<JSEvaluationKey> ourRecursionGuard = new JSComplexityAwareRecursionGuard("js.type.evaluator");

    @NotNull
    public static JSComplexityAwareRecursionGuard<JSEvaluationKey> getGuard() {
        JSComplexityAwareRecursionGuard<JSEvaluationKey> jSComplexityAwareRecursionGuard = ourRecursionGuard;
        if (jSComplexityAwareRecursionGuard == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(0);
        }
        return jSComplexityAwareRecursionGuard;
    }

    @Nullable
    public static <T> T evaluateWithGuard(@NotNull JSType type, @NotNull JSEvaluateContext context, @NotNull Computable<T> runnable) {
        if (type == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(2);
        }
        if (runnable == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(3);
        }
        JSEvaluationKey node = new JSEvaluationKey(type.getResolvedTypeId(), context, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    @Nullable
    public static <T> T compute(@NotNull JSType type, @NotNull JSEvaluateContext context, @NotNull Computable<T> supplier) {
        if (type == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(4);
        }
        if (context == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(5);
        }
        if (supplier == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(6);
        }
        JSEvaluationKey node = new JSEvaluationKey(type.getResolvedTypeId(), context, supplier.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, true, supplier);
    }

    @Nullable
    public static <T> T compute(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull Computable<T> supplier) {
        if (element == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(7);
        }
        if (context == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(8);
        }
        if (supplier == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(9);
        }
        JSEvaluationKey node = new JSEvaluationKey(element, context, supplier.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, true, supplier);
    }

    @Nullable
    public static <T> T processWithEvaluationGuard(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull Computable<T> runnable) {
        if (element == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(10);
        }
        if (context == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(11);
        }
        if (runnable == null) {
            JSEvaluationRecursionGuard.$$$reportNull$$$0(12);
        }
        JSEvaluationKey node = new JSEvaluationKey(element, context, runnable.getClass());
        return ourRecursionGuard.doPreventingRecursion(node, false, runnable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuard";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateWithGuard";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processWithEvaluationGuard";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSEvaluationKey {
        @NotNull
        public final Object myElement;
        @NotNull
        public final JSEvaluateContext myContext;
        @NotNull
        public final Class<?> myProviderClass;

        public JSEvaluationKey(@NotNull PsiElement element, @NotNull JSEvaluateContext context, @NotNull Class<?> providerClass) {
            if (element == null) {
                JSEvaluationKey.$$$reportNull$$$0(0);
            }
            if (context == null) {
                JSEvaluationKey.$$$reportNull$$$0(1);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(2);
            }
            this.myElement = element;
            this.myContext = context;
            this.myProviderClass = providerClass;
        }

        public JSEvaluationKey(@NotNull JSResolvedTypeId typeId, @NotNull JSEvaluateContext context, @NotNull Class<?> providerClass) {
            if (typeId == null) {
                JSEvaluationKey.$$$reportNull$$$0(3);
            }
            if (context == null) {
                JSEvaluationKey.$$$reportNull$$$0(4);
            }
            if (providerClass == null) {
                JSEvaluationKey.$$$reportNull$$$0(5);
            }
            this.myElement = Pair.create((Object)typeId, (Object)new JSEvaluateContextObject(context));
            this.myContext = context;
            this.myProviderClass = providerClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JSEvaluationKey key = (JSEvaluationKey)o;
            return this.myElement.equals(key.myElement) && this.myContext.equals(key.myContext) && this.myProviderClass.equals(key.myProviderClass);
        }

        public int hashCode() {
            return Objects.hash(this.myElement, this.myContext, this.myProviderClass);
        }

        public String toString() {
            String element = this.myElement instanceof PsiElement ? JSEvaluationLogger.toPresentable(this.myElement) : this.myElement.getClass().getSimpleName();
            return String.format("JSEvaluationKey(%s, %s)", element, this.myProviderClass.getSimpleName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providerClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "typeId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard$JSEvaluationKey";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class JSEvaluateContextObject {
            @Nullable
            private final JSReferenceExpression myExpression;
            private final PsiElement mySource;

            private JSEvaluateContextObject(@NotNull JSEvaluateContext context) {
                if (context == null) {
                    JSEvaluateContextObject.$$$reportNull$$$0(0);
                }
                this.myExpression = context.getProcessedExpression();
                this.mySource = context.getSource();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                JSEvaluateContextObject that = (JSEvaluateContextObject)o;
                return Objects.equals(this.myExpression, that.myExpression) && Objects.equals(this.mySource, that.mySource);
            }

            public int hashCode() {
                return Objects.hash(this.myExpression, this.mySource);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/resolve/JSEvaluationRecursionGuard$JSEvaluationKey$JSEvaluateContextObject", "<init>"));
            }
        }
    }
}

