/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.stubs.ES6DecoratorStub;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSNamedObjectStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSStubBase;
import com.intellij.lang.typescript.psi.impl.ES6DecoratorImpl;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6DecoratorStubImpl
extends JSStubBase<ES6Decorator>
implements ES6DecoratorStub {
    @Nullable
    private final JSElementIndexingDataStructure myIndexingData;
    @Nullable
    private final String myDecoratorName;
    private static final BooleanStructureElement HAS_INDEXING_DATA_FLAG = JSPossiblyStoredStubImpl.HAS_INDEXING_DATA_FLAG;
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(JSNamedObjectStubBase.FLAGS_STRUCTURE, HAS_INDEXING_DATA_FLAG);

    public ES6DecoratorStubImpl(ES6Decorator clazz, StubElement parent) {
        super(clazz, parent, JSStubElementTypes.ES6_DECORATOR);
        JSElementIndexingData indexingData = clazz.getIndexingData();
        this.myIndexingData = indexingData != null && !indexingData.isEmpty() ? indexingData.toStructure() : null;
        this.myDecoratorName = clazz.getDecoratorName();
        this.writeFlag(HAS_INDEXING_DATA_FLAG, this.myIndexingData != null);
    }

    public ES6DecoratorStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        super(dataStream, parentStub, (IStubElementType)JSStubElementTypes.ES6_DECORATOR);
        this.myDecoratorName = dataStream.readNameString();
        this.myIndexingData = this.readFlag(HAS_INDEXING_DATA_FLAG) != false ? JSElementIndexingDataStructureImpl.deserialize(dataStream) : null;
    }

    @Override
    public ES6Decorator createPsi() {
        return new ES6DecoratorImpl(this);
    }

    @Override
    @Nullable
    public JSElementIndexingDataStructure getIndexingDataStructure() {
        return this.myIndexingData;
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        dataStream.writeName(this.myDecoratorName);
        if (this.readFlag(HAS_INDEXING_DATA_FLAG).booleanValue()) {
            JSElementIndexingDataStructureImpl.serialize(this.myIndexingData, dataStream);
        }
    }

    @Override
    @NotNull
    protected FlagsStructure getFlagsStructure() {
        FlagsStructure flagsStructure = FLAGS_STRUCTURE;
        if (flagsStructure == null) {
            ES6DecoratorStubImpl.$$$reportNull$$$0(0);
        }
        return flagsStructure;
    }

    @Override
    public void index(IndexSink sink) {
        super.index(sink);
        JSElementIndexingDataStructureImpl.index(this, sink);
    }

    @Override
    @Nullable
    public String getDecoratorName() {
        return this.myDecoratorName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/stubs/impl/ES6DecoratorStubImpl", "getFlagsStructure"));
    }
}

