/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSCallExpressionStub;
import com.intellij.lang.javascript.psi.stubs.JSLazyIndexedPackagesIndex;
import com.intellij.lang.javascript.psi.stubs.JSLiteralExpressionStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSPossiblyStoredStubImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class JSLiteralExpressionStubImpl
extends JSPossiblyStoredStubImpl<JSLiteralExpression>
implements JSLiteralExpressionStub {
    @Nullable
    private final String mySignificantValue;

    public JSLiteralExpressionStubImpl(JSLiteralExpression clazz, StubElement parent) {
        this(clazz, parent, (IStubElementType<?, JSLiteralExpression>)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    protected JSLiteralExpressionStubImpl(JSLiteralExpression clazz, StubElement parent, IStubElementType<?, JSLiteralExpression> type) {
        super(clazz, parent, type);
        this.mySignificantValue = clazz.getSignificantValue();
    }

    public JSLiteralExpressionStubImpl(StubInputStream dataStream, StubElement parentStub) throws IOException {
        this(dataStream, parentStub, (IStubElementType<?, JSLiteralExpression>)JSStubElementTypes.LITERAL_EXPRESSION);
    }

    public JSLiteralExpressionStubImpl(StubInputStream dataStream, StubElement parentStub, IStubElementType<?, JSLiteralExpression> type) throws IOException {
        super(dataStream, parentStub, type);
        this.mySignificantValue = dataStream.readNameString();
    }

    @Override
    public void serialize(StubOutputStream dataStream) throws IOException {
        super.serialize(dataStream);
        dataStream.writeName(this.getSignificantValue());
    }

    @Override
    public JSLiteralExpression createPsi() {
        return new JSLiteralExpressionImpl(this);
    }

    @Override
    public void index(IndexSink sink) {
        String value;
        super.index(sink);
        StubElement stub = this.getParentStub();
        if (stub instanceof JSCallExpressionStub && ((JSCallExpressionStub)stub).isRequireCall() && !StringUtil.isEmpty((String)(value = this.getSignificantValue()))) {
            JSLazyIndexedPackagesIndex.index(sink, value);
        }
    }

    @Override
    @Nullable
    public String getSignificantValue() {
        return this.mySignificantValue;
    }
}

