/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeHashCodeUtil;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSDistributedType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDecoratedTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSDecoratedType {
    @NotNull
    private final JSType myType;
    @NotNull
    private final Set<JSDecoratedType.TypeDecoration> myDecorations;

    public JSDecoratedTypeImpl(@NotNull JSTypeSource source2, @NotNull JSType type, @NotNull Set<JSDecoratedType.TypeDecoration> decorations) {
        if (source2 == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(0);
        }
        if (type == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(1);
        }
        if (decorations == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(2);
        }
        super(source2);
        JSType finalOwner = type;
        Set<JSDecoratedType.TypeDecoration> finalDecorators = decorations;
        if (type instanceof JSDecoratedType) {
            finalOwner = ((JSDecoratedType)type).getOriginalType();
            EnumSet<JSDecoratedType.TypeDecoration> merged = EnumSet.copyOf(((JSDecoratedType)type).getDecorations());
            merged.addAll(decorations);
            finalDecorators = merged;
        }
        this.myType = finalOwner;
        this.myDecorations = Collections.unmodifiableSet(finalDecorators);
    }

    JSDecoratedTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(4);
        }
        super(source2);
        this.myType = JSTypeSerializer.TYPE_SERIALIZER.read(source2, inputStream);
        String s = JSTypeSerializer.readString(inputStream);
        EnumSet<JSDecoratedType.TypeDecoration> decorations = EnumSet.noneOf(JSDecoratedType.TypeDecoration.class);
        if (s.contains("?")) {
            decorations.add(JSDecoratedType.TypeDecoration.JSDOC_NULLABLE);
        }
        if (s.contains("!")) {
            decorations.add(JSDecoratedType.TypeDecoration.JSDOC_NOTNULL);
        }
        this.myDecorations = decorations;
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myType, outputStream);
        Object s = "";
        if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NULLABLE)) {
            s = (String)s + "?";
        }
        if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NOTNULL)) {
            s = (String)s + "!";
        }
        JSTypeSerializer.writeString((String)s, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        boolean wrapInBrackets;
        if (format == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(7);
        }
        if (format == JSType.TypeTextFormat.CODE && !this.isJavaScript()) {
            builder.append(this.myType.getTypeText(format));
            return;
        }
        if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NOTNULL)) {
            builder.append("!");
        }
        if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NULLABLE)) {
            builder.append("?");
        }
        boolean bl = wrapInBrackets = (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NOTNULL) || this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NULLABLE)) && JSTypeUtils.isNeedWrapTypeForSerialization(this.myType);
        if (wrapInBrackets) {
            builder.append("(");
        }
        this.myType.buildTypeText(format, builder);
        if (wrapInBrackets) {
            builder.append(")");
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myType, JSTypeHashCodeUtil.getHashCode(this.myDecorations));
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(8);
        }
        if (processingContext == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(9);
        }
        if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NOTNULL)) {
            if (elementType instanceof JSNullType || elementType instanceof JSDecoratedTypeImpl && ((JSDecoratedTypeImpl)elementType).myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NULLABLE)) {
                return false;
            }
        } else if (this.myDecorations.contains((Object)JSDecoratedType.TypeDecoration.JSDOC_NULLABLE) && elementType instanceof JSNullType) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult assignableResult;
        if (elementType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(10);
        }
        if (processingContext == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(11);
        }
        if ((assignableResult = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult2 = assignableResult;
            if (assignableResult2 == null) {
                JSDecoratedTypeImpl.$$$reportNull$$$0(12);
            }
            return assignableResult2;
        }
        JSTypeCastUtil.AssignableResult assignableResult3 = JSTypeCastUtil.toStrictAssignable(this.myType.isDirectlyAssignableType(elementType, processingContext));
        if (assignableResult3 == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(13);
        }
        return assignableResult3;
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        JSDecoratedTypeImpl decoratedType;
        if (type == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(14);
        }
        return this.myDecorations.equals((decoratedType = (JSDecoratedTypeImpl)type).getDecorations()) && this.myType.isEquivalentTo(decoratedType.getType(), processingContext, allowResolve);
    }

    @Override
    @NotNull
    public Set<JSDecoratedType.TypeDecoration> getDecorations() {
        Set<JSDecoratedType.TypeDecoration> set = this.myDecorations;
        if (set == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(15);
        }
        return set;
    }

    @NotNull
    public JSType getType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    @Override
    public void accept(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(17);
        }
        visitor.visitJSDecoratedType(this);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(18);
        }
        this.myType.accept(visitor);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType newType;
        JSType oldType;
        if (childTransform == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(19);
        }
        if (newSource == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(20);
        }
        if ((oldType = this.getType()) == (newType = JSTypeUtils.transformTypeHierarchySafe(oldType, childTransform))) {
            JSDecoratedTypeImpl jSDecoratedTypeImpl = this;
            if (jSDecoratedTypeImpl == null) {
                JSDecoratedTypeImpl.$$$reportNull$$$0(21);
            }
            return jSDecoratedTypeImpl;
        }
        return new JSDecoratedTypeImpl(newSource, newType, this.getDecorations());
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(22);
        }
        return new JSDecoratedTypeImpl(source2, this.getType(), this.getDecorations());
    }

    @Override
    @NotNull
    public JSType getOriginalType() {
        JSType jSType = this.myType;
        if (jSType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(23);
        }
        return jSType;
    }

    @Override
    @NotNull
    public JSType distributeType() {
        if (this.myType instanceof JSDistributedType) {
            JSType distributeType = ((JSDistributedType)((Object)this.myType)).distributeType();
            return distributeType == this ? this : new JSDecoratedTypeImpl(this.getSource(), distributeType, this.getDecorations());
        }
        JSDecoratedTypeImpl jSDecoratedTypeImpl = this;
        if (jSDecoratedTypeImpl == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(24);
        }
        return jSDecoratedTypeImpl;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType original;
        JSType expanded;
        if (context == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(25);
        }
        if ((expanded = (original = this.getOriginalType()).substitute(context)) == null) {
            return null;
        }
        if (expanded != original) {
            return new JSDecoratedTypeImpl(this.getSource(), expanded, this.myDecorations);
        }
        return this;
    }

    @Override
    @NotNull
    protected JSRecordType asRecordTypeNoCache() {
        JSRecordType jSRecordType = this.getOriginalType().asRecordType();
        if (jSRecordType == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(26);
        }
        return jSRecordType;
    }

    @Override
    public boolean hasDecorator(@NotNull JSDecoratedType.TypeDecoration decoration) {
        if (decoration == null) {
            JSDecoratedTypeImpl.$$$reportNull$$$0(27);
        }
        return this.myDecorations.contains((Object)decoration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorations";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSDecoratedTypeImpl";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorations";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalType";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "distributeType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "hasDecorator";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 21: 
            case 23: 
            case 24: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

