/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSCommonTypeNames;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSBooleanLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUniqueSymbolTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnknownType;
import com.intellij.lang.javascript.psi.types.JSUtilType;
import com.intellij.lang.javascript.psi.types.TypeScriptObjectJSTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSThisType;
import com.intellij.lang.javascript.psi.types.primitives.JSBigIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.lang.javascript.psi.types.primitives.JSIntType;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSNumberType;
import com.intellij.lang.javascript.psi.types.primitives.JSObjectType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveFunctionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveReadonlyArrayType;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.types.primitives.JSSymbolType;
import com.intellij.lang.javascript.psi.types.primitives.JSUintType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptIntrinsicJSTypeImpl;
import com.intellij.lang.javascript.psi.types.primitives.TypeScriptNeverJSTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSSpecialNamedTypeImpl
extends JSNamedType
implements JSUtilType {
    protected JSSpecialNamedTypeImpl(@NotNull JSTypeSource source2, @NotNull JSTypeContext staticOrInstance) {
        if (source2 == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(0);
        }
        if (staticOrInstance == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(1);
        }
        super(source2, staticOrInstance);
    }

    protected JSSpecialNamedTypeImpl(@NotNull JSTypeSource typeSource, @NotNull CharacterIterator inputStream) {
        if (typeSource == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(3);
        }
        super(typeSource, inputStream);
    }

    @Nullable
    static JSType getSpecialType(String typeString, JSTypeSource source2, JSTypeContext staticOrInstance, boolean isFromJSDoc) {
        String typeStringUnified;
        switch (typeString) {
            case "string": {
                return new JSStringType(true, source2, staticOrInstance);
            }
            case "number": {
                return new JSNumberType(true, source2, staticOrInstance);
            }
            case "boolean": {
                return new JSBooleanType(true, source2, staticOrInstance);
            }
            case "symbol": {
                return new JSSymbolType(true, source2, staticOrInstance);
            }
            case "bigint": {
                return new JSBigIntType(true, source2, staticOrInstance);
            }
        }
        switch (typeStringUnified = isFromJSDoc ? JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(typeString) : typeString) {
            case "String": {
                return new JSStringType(false, source2, staticOrInstance);
            }
            case "Number": {
                return new JSNumberType(false, source2, staticOrInstance);
            }
            case "Boolean": {
                return new JSBooleanType(false, source2, staticOrInstance);
            }
            case "BigInt": {
                return new JSBigIntType(false, source2, staticOrInstance);
            }
            case "Object": {
                return new JSObjectType(source2, staticOrInstance);
            }
            case "Array": {
                return new JSPrimitiveArrayType(source2, staticOrInstance);
            }
            case "ReadonlyArray": {
                return new JSPrimitiveReadonlyArrayType(source2, staticOrInstance);
            }
            case "unique symbol": {
                return new JSUniqueSymbolTypeImpl(source2, staticOrInstance, false);
            }
            case "null": {
                return new JSNullType(source2);
            }
            case "undefined": {
                return new JSUndefinedType(source2);
            }
            case "void": {
                return new JSVoidType(source2);
            }
            case "intrinsic": {
                return new TypeScriptIntrinsicJSTypeImpl(source2);
            }
        }
        if (isFromJSDoc && "this".equals(typeStringUnified)) {
            return new JSThisType(source2);
        }
        if (JSCommonTypeNames.FUNCTION_CLASS_NAMES.contains(typeStringUnified)) {
            return new JSPrimitiveFunctionType(source2, staticOrInstance);
        }
        if (!source2.isTypeScript()) {
            JSSpecialNamedTypeImpl primitiveType = null;
            if ("int".equals(typeString)) {
                primitiveType = new JSIntType(true, source2, staticOrInstance);
            }
            if ("Integer".equals(typeString)) {
                primitiveType = new JSIntType(false, source2, staticOrInstance);
            }
            if ("uint".equals(typeStringUnified)) {
                primitiveType = new JSUintType(source2, staticOrInstance);
            }
            if (primitiveType != null || source2.isEcma()) {
                return primitiveType;
            }
        }
        switch (typeStringUnified) {
            case "true": {
                return new JSBooleanLiteralTypeImpl(true, false, source2);
            }
            case "false": {
                return new JSBooleanLiteralTypeImpl(false, false, source2);
            }
            case "never": {
                return new TypeScriptNeverJSTypeImpl(source2);
            }
            case "unknown": {
                return source2.isTypeScript() ? JSUnknownType.TS_INSTANCE : JSUnknownType.JS_INSTANCE;
            }
            case "object": {
                if (!source2.isTypeScript()) break;
                return new TypeScriptObjectJSTypeImpl(source2, staticOrInstance);
            }
        }
        return null;
    }

    @Override
    public JSClass resolveClass() {
        if (!this.isEcma()) {
            return null;
        }
        PsiElement clazz = JSResolveUtil.findType(JSDocumentationUtils.doCapitalizeCommentTypeIfNeeded(this.getResolvedTypeText()), (PsiElement)this.getScope(), this.isEcma());
        return clazz instanceof JSClass ? (JSClass)clazz : null;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSResolvedTypeInfo resolvedType;
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(4);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(5);
        }
        if (elementType instanceof JSSpecialNamedTypeImpl) {
            return this.isEquivalentTo(elementType, processingContext) || this.getClass().equals(elementType.getClass()) && this.getTypeHelper().areNamedTypesAssignable(this, (JSSpecialNamedTypeImpl)elementType, processingContext);
        }
        if (elementType instanceof JSResolvableType && (resolvedType = ((JSResolvableType)elementType).resolveType()).isEnum()) {
            return this instanceof JSNumberType;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        if (type == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(6);
        }
        boolean fromSuper = super.isEquivalentToWithSameClass(type, context, allowResolve);
        if (!allowResolve) {
            return fromSuper;
        }
        Object own = this.getScopeId();
        Object other = ((JSSpecialNamedTypeImpl)type).getScopeId();
        return fromSuper && own.equals(other);
    }

    @Override
    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectlyAssignableTypeCommon(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSTypeCastUtil.AssignableResult result2;
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(8);
        }
        if ((result2 = super.isDirectlyAssignableTypeCommon(elementType, processingContext)).isStrict()) {
            JSTypeCastUtil.AssignableResult assignableResult = result2;
            if (assignableResult == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(9);
            }
            return assignableResult;
        }
        if (elementType instanceof JSTypeImpl) {
            JSTypeCastUtil.AssignableResult assignableResult = this.isDirectAssignableWithNamedType((JSNamedType)elementType, processingContext);
            if (assignableResult == null) {
                JSSpecialNamedTypeImpl.$$$reportNull$$$0(10);
            }
            return assignableResult;
        }
        JSTypeCastUtil.AssignableResult assignableResult = result2;
        if (assignableResult == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(11);
        }
        return assignableResult;
    }

    @NotNull
    protected JSTypeCastUtil.AssignableResult isDirectAssignableWithNamedType(@NotNull JSNamedType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(13);
        }
        JSTypeCastUtil.AssignableResult assignableResult = JSTypeCastUtil.toStrictAssignable(this.getTypeHelper().areNamedTypesAssignable(this, elementType, processingContext));
        if (assignableResult == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(14);
        }
        return assignableResult;
    }

    @Override
    @NotNull
    public JSQualifiedName getQualifiedName() {
        String text = this.getTypeText(JSType.TypeTextFormat.RESOLVED);
        JSQualifiedNameImpl jSQualifiedNameImpl = JSQualifiedNameImpl.fromQualifiedName(text);
        if (jSQualifiedNameImpl == null) {
            JSSpecialNamedTypeImpl.$$$reportNull$$$0(15);
        }
        return jSQualifiedNameImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "staticOrInstance";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSSpecialNamedTypeImpl";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "isDirectAssignableWithNamedType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeCommon";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectAssignableWithNamedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

