/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclarationProvider;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.text.StringCharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public final class JSTypeDeclarationProviderImpl
implements JSTypeDeclarationProvider {
    @NotNull
    public static Key<CachedValue<JSType>> CACHED_TYPE_KEY = Key.create((String)"js.type.declaration.cached");
    @TestOnly
    private static boolean CHECK_TYPE = false;

    @TestOnly
    public static void setCheckType(boolean checkType, @NotNull Disposable testRootDisposable) {
        if (testRootDisposable == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(0);
        }
        boolean old = CHECK_TYPE;
        CHECK_TYPE = checkType;
        Disposer.register((Disposable)testRootDisposable, () -> {
            CHECK_TYPE = old;
        });
    }

    @Override
    @NotNull
    public JSType calculateType(@NotNull JSTypeDeclaration type) {
        if (type == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(1);
        }
        JSType jSType = (JSType)CachedValuesManager.getCachedValue((PsiElement)type, CACHED_TYPE_KEY, () -> {
            JSType value = type.calculateType();
            if (CHECK_TYPE) {
                JSTypeDeclarationProviderImpl.validateType(value, type);
            }
            return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{type.getContainingFile()});
        });
        if (jSType == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    private static void validateType(@NotNull JSType type, @NotNull JSTypeDeclaration psiType) {
        JSType result2;
        if (type == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(3);
        }
        if (psiType == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(4);
        }
        if (!Objects.equals((result2 = JSTypeDeclarationProviderImpl.serializeAndDeserialize(type, type.getSource())).toString(), type.toString())) {
            throw new RuntimeException("Serialization problem: \n" + type + "\nafter: \n" + result2 + "\nclass " + psiType.getClass());
        }
    }

    private static JSType serializeAndDeserialize(@NotNull JSType type, @NotNull JSTypeSource source2) {
        if (type == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(5);
        }
        if (source2 == null) {
            JSTypeDeclarationProviderImpl.$$$reportNull$$$0(6);
        }
        StringBuilder builder = new StringBuilder();
        JSTypeSerializer.TYPE_SERIALIZER.write(type, builder);
        String serialized = builder.toString();
        return JSTypeSerializer.TYPE_SERIALIZER.read(source2, new StringCharacterIterator(serialized));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRootDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSTypeDeclarationProviderImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSTypeDeclarationProviderImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setCheckType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateType";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeAndDeserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

