/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.TypeScriptLiteralKeyUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.ecma6.EnumConstantValue;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSForInStringType;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSNumberLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSSpecialNamedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeComparingContextService;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutionContextImpl;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptIndexedAccessJSTypeImpl
extends JSTypeBaseImpl
implements JSType.CompositeStructure,
JSEvaluableType,
JSTypeWithIncompleteSubstitution {
    @NotNull
    private final JSType myOwner;
    @NotNull
    private final JSType myParameterType;
    private final NotNullLazyValue<Boolean> myHasForeignParameters;

    @ApiStatus.Internal
    public TypeScriptIndexedAccessJSTypeImpl(@NotNull JSType owner, @NotNull JSType parameterType, @NotNull JSTypeSource source2) {
        if (owner == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(0);
        }
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(1);
        }
        if (source2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(2);
        }
        super(source2);
        this.myHasForeignParameters = NotNullLazyValue.atomicLazy(this::hasForeignGenericParameters);
        this.myOwner = owner;
        this.myParameterType = parameterType;
    }

    TypeScriptIndexedAccessJSTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(3);
        }
        if (inputStream == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(4);
        }
        super(source2);
        this.myHasForeignParameters = NotNullLazyValue.atomicLazy(this::hasForeignGenericParameters);
        this.myOwner = JSTypeSerializer.TYPE_SERIALIZER.read(source2, inputStream);
        this.myParameterType = JSTypeSerializer.TYPE_SERIALIZER.read(source2, inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(5);
        }
        super.serialize(outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myOwner, outputStream);
        JSTypeSerializer.TYPE_SERIALIZER.write(this.myParameterType, outputStream);
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        JSType owner;
        boolean shouldWrap;
        if (format == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(7);
        }
        if (shouldWrap = JSTypeUtils.isNeedWrapTypeForSerialization(owner = this.getOwner())) {
            builder.append("(");
        }
        owner.buildTypeText(format, builder);
        if (shouldWrap) {
            builder.append(")");
        }
        builder.append("[");
        JSType type = this.getParameterType();
        type.buildTypeText(format, builder);
        builder.append("]");
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.getOwner(), this.getParameterType());
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(8);
        }
        if (newSource == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(9);
        }
        JSType newOwner = JSTypeUtils.transformTypeHierarchySafe(this.getOwner(), childTransform);
        JSType newParameterType = JSTypeUtils.transformTypeHierarchySafe(this.getParameterType(), childTransform);
        if (newOwner == this.getOwner() && newParameterType == this.getParameterType()) {
            TypeScriptIndexedAccessJSTypeImpl typeScriptIndexedAccessJSTypeImpl = this;
            if (typeScriptIndexedAccessJSTypeImpl == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(10);
            }
            return typeScriptIndexedAccessJSTypeImpl;
        }
        JSType jSType = JSCompositeTypeFactory.createIndexedAccessType(newOwner, newParameterType, newSource);
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(11);
        }
        return jSType;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        JSType subst;
        JSType constraintType;
        JSType substitute;
        if (elementType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(12);
        }
        if (processingContext == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(13);
        }
        if (!((substitute = this.substituteCompletely()) instanceof JSAnyType) && substitute != this && substitute.isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        JSType parameterType = this.getParameterType();
        if (elementType instanceof TypeScriptIndexedAccessJSTypeImpl && parameterType instanceof JSGenericParameterImpl && ((TypeScriptIndexedAccessJSTypeImpl)elementType).getParameterType() instanceof JSGenericParameterImpl) {
            JSType thisOwner = this.getOwner();
            JSType otherOwner = ((TypeScriptIndexedAccessJSTypeImpl)elementType).getOwner();
            return thisOwner.isDirectlyAssignableType(otherOwner, processingContext);
        }
        JSType owner = this.getOwner();
        if (owner instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)owner).getConstraintType()) != null && JSCompositeTypeFactory.createIndexedAccessType(constraintType, parameterType, this.getSource()).isDirectlyAssignableType(elementType, processingContext)) {
            return true;
        }
        if (parameterType instanceof JSGenericParameterImpl && (constraintType = ((JSGenericParameterImpl)parameterType).getConstraintType()) != null && (subst = constraintType.substitute()) instanceof JSUnionType) {
            for (JSType type : ((JSUnionType)subst).getTypes()) {
                if (!JSCompositeTypeFactory.createIndexedAccessType(owner, type, this.getSource()).isDirectlyAssignableType(elementType, processingContext)) continue;
                return true;
            }
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(14);
        }
        return new TypeScriptIndexedAccessJSTypeImpl(this.getOwner(), this.getParameterType(), source2);
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        TypeScriptIndexedAccessJSTypeImpl indexedAccessJSType;
        if (type == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(15);
        }
        return (indexedAccessJSType = (TypeScriptIndexedAccessJSTypeImpl)type).getOwner().isEquivalentTo(this.getOwner(), context, allowResolve) && indexedAccessJSType.getParameterType().isEquivalentTo(this.getParameterType(), context, allowResolve);
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        if (context == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(16);
        }
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            return this;
        }
        return this.substituteInternal(context);
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        if (this.myHasForeignParameters.getValue() == Boolean.TRUE) {
            JSType jSType = this.getLocalCachedType(() -> this.substituteInternal(new JSTypeSubstitutionContextImpl()), SUBSTITUTE_COMPLETE);
            if (jSType == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(17);
            }
            return jSType;
        }
        JSType jSType = this.substitute();
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(18);
        }
        return jSType;
    }

    private boolean hasForeignGenericParameters() {
        return JSTypeUtils.hasForeignGenericParameter(this.getOwner()) || JSTypeUtils.hasForeignGenericParameter(this.getParameterType());
    }

    @Nullable
    public JSType substituteInternal(@NotNull JSTypeSubstitutionContext context) {
        JSType type;
        String next;
        JSType owner;
        JSType ownerType;
        if (context == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(19);
        }
        if ((ownerType = context.substituteNested(owner = this.getOwner())) == null) {
            return null;
        }
        JSType parameterType = this.getParameterType();
        JSType parameterTypeExpanded = context.substituteNested(parameterType);
        if (parameterTypeExpanded == null) {
            return null;
        }
        Collection<String> parameterStrings = TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(parameterTypeExpanded);
        if (ownerType instanceof JSTupleType && parameterStrings.size() == 1 && !StringUtil.isEmpty((String)(next = parameterStrings.iterator().next())) && StringUtil.isDecimalDigit((char)next.charAt(0))) {
            try {
                JSType type2;
                int index = (int)Double.parseDouble(next);
                if (((JSTupleType)ownerType).hasTypeByIndex(index) && (type2 = ((JSTupleType)ownerType).getTypeByIndex(index)) != null) {
                    return type2;
                }
            }
            catch (NumberFormatException index) {
                // empty catch block
            }
        }
        HashSet<String> strings = new HashSet<String>(parameterStrings);
        JSRecordType recordType = null;
        SmartList result2 = new SmartList();
        if (!strings.isEmpty()) {
            HashMap<String, JSRecordType.PropertySignature> allSignatures = null;
            recordType = ownerType.asRecordType();
            boolean isStrictNullChecks = TypeScriptConfigUtil.strictNullChecks(this.getSourceElement());
            for (String name : strings) {
                JSType type3;
                JSRecordType.PropertySignature propertySignature = recordType.findPropertySignature(name);
                if (propertySignature == null) {
                    if (allSignatures == null) {
                        allSignatures = new HashMap<String, JSRecordType.PropertySignature>();
                        TypeScriptIndexedAccessJSTypeImpl.collectPropertySignatures(ownerType, allSignatures);
                    }
                    propertySignature = (JSRecordType.PropertySignature)allSignatures.get(name);
                }
                if (propertySignature == null || (type3 = propertySignature.getJSType()) == null) continue;
                TypeScriptIndexedAccessJSTypeImpl.addType((List<JSType>)result2, type3, isStrictNullChecks && propertySignature.isOptional());
            }
            if (result2.size() != 0) {
                return JSCompositeTypeFactory.createUnionType(this.getSource(), (Collection<? extends JSType>)result2);
            }
        }
        if ((type = TypeScriptLiteralKeyUtil.getTypeFromComputedNameProperty(ownerType, parameterType)) != null) {
            return type;
        }
        ProcessingContext processingContext = JSTypeComparingContextService.createProcessingContextWithCache(this.getSourceElement());
        JSRecordType.IndexSignatureKind expectedIndexer = JSRecordType.IndexSignatureKind.UNKNOWN;
        if (this.isAssignableToCommonType(parameterType, "number", processingContext) || parameterType instanceof JSForInStringType) {
            expectedIndexer = JSRecordType.IndexSignatureKind.NUMERIC;
        } else if (this.isAssignableToCommonType(parameterType, "string", processingContext) || parameterType instanceof JSUnionType && ((JSUnionType)parameterType).getTypes().stream().allMatch(t -> this.isAssignableToCommonType((JSType)t, "string", processingContext) || this.isAssignableToCommonType((JSType)t, "number", processingContext))) {
            expectedIndexer = JSRecordType.IndexSignatureKind.STRING;
        }
        if (expectedIndexer != JSRecordType.IndexSignatureKind.UNKNOWN) {
            JSRecordType.IndexSignature indexer;
            if (recordType == null) {
                recordType = ownerType.asRecordType();
            }
            if ((indexer = recordType.findIndexer(expectedIndexer)) != null) {
                return indexer.getMemberType();
            }
        }
        return JSAnyType.get(this.getSource());
    }

    private static void addType(@NotNull List<JSType> result2, @NotNull JSType type, boolean addUndefined) {
        if (result2 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(20);
        }
        if (type == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(21);
        }
        if (addUndefined) {
            type = TypeScriptTypeGuard.wrapWithUndefined(type, type.getSource());
        }
        result2.add(type);
    }

    private static void collectPropertySignatures(@Nullable JSType ownerType, @NotNull Map<String, JSRecordType.PropertySignature> signatures) {
        if (signatures == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(22);
        }
        if (ownerType instanceof JSResolvableType) {
            JSResolvedTypeInfo resolvedTypeInfo = ((JSResolvableType)ownerType).resolveType();
            TypeScriptIndexedAccessJSTypeImpl.collectClassSignatures(resolvedTypeInfo, signatures);
        }
        if (ownerType instanceof JSIntersectionType) {
            for (JSType type : ((JSIntersectionType)ownerType).getTypes()) {
                TypeScriptIndexedAccessJSTypeImpl.collectPropertySignatures(type, signatures);
            }
        }
    }

    private static void collectClassSignatures(@Nullable JSResolvedTypeInfo resolvedTypeInfo, @NotNull Map<String, JSRecordType.PropertySignature> signatures) {
        if (signatures == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(23);
        }
        if (resolvedTypeInfo == null) {
            return;
        }
        for (JSClass jsClass : resolvedTypeInfo.getDeclarationsOfType(JSClass.class)) {
            for (JSElement jSElement : jsClass.getMembers()) {
                if (!(jSElement instanceof JSRecordType.PropertySignature)) continue;
                signatures.put(((JSRecordType.PropertySignature)((Object)jSElement)).getMemberName(), (JSRecordType.PropertySignature)((Object)jSElement));
            }
        }
    }

    private boolean isAssignableToCommonType(@NotNull JSType parameterType, @NotNull String typeName, @NotNull ProcessingContext context) {
        JSType commonType;
        if (parameterType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(24);
        }
        if (typeName == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(25);
        }
        if (context == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(26);
        }
        return (commonType = JSSpecialNamedTypeImpl.getSpecialType(typeName, this.getSource(), JSTypeContext.INSTANCE, false)) != null && commonType.isDirectlyAssignableType(parameterType, context);
    }

    @Nullable
    private static String getEnumConstFieldValue(TypeScriptEnumField field) {
        EnumConstantValue value = field.getConstantValue();
        String stringValue = value.getStringValue();
        if (stringValue != null) {
            return stringValue;
        }
        Double numericValue = value.getNumericValue();
        if (numericValue != null) {
            return value.getAsString();
        }
        return null;
    }

    @NotNull
    public static Collection<String> getParameterStrings(@NotNull JSType expandedType) {
        if (expandedType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(27);
        }
        if (expandedType instanceof JSStringLiteralTypeImpl) {
            List list2 = ContainerUtil.createMaybeSingletonList((Object)((JSStringLiteralTypeImpl)expandedType).getLiteral());
            if (list2 == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(28);
            }
            return list2;
        }
        if (expandedType instanceof JSNumberLiteralTypeImpl) {
            List list3 = ContainerUtil.createMaybeSingletonList((Object)((JSNumberLiteralTypeImpl)expandedType).getValueAsString());
            if (list3 == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(29);
            }
            return list3;
        }
        if (expandedType instanceof JSResolvableType) {
            TypeScriptEnum tsEnum;
            String constFieldValue;
            TypeScriptEnumField field;
            JSResolvedTypeInfo info = ((JSResolvableType)expandedType).resolveType();
            if (info.isEnumLiteral() && (field = info.getDeclarationOfType(TypeScriptEnumField.class)) != null && (constFieldValue = TypeScriptIndexedAccessJSTypeImpl.getEnumConstFieldValue(field)) != null) {
                List list4 = ContainerUtil.createMaybeSingletonList((Object)constFieldValue);
                if (list4 == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(30);
                }
                return list4;
            }
            if (info.isEnumWithLiteralValues() && (tsEnum = info.getDeclarationOfType(TypeScriptEnum.class)) != null) {
                JSField[] fields = tsEnum.getFields();
                ArrayList<String> fieldValues = new ArrayList<String>(fields.length);
                for (JSField field2 : fields) {
                    String constFieldValue2 = TypeScriptIndexedAccessJSTypeImpl.getEnumConstFieldValue((TypeScriptEnumField)field2);
                    if (constFieldValue2 == null) {
                        List list5 = ContainerUtil.emptyList();
                        if (list5 == null) {
                            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(31);
                        }
                        return list5;
                    }
                    fieldValues.add(constFieldValue2);
                }
                ArrayList<String> arrayList = fieldValues;
                if (arrayList == null) {
                    TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(32);
                }
                return arrayList;
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(33);
            }
            return set;
        }
        if (expandedType instanceof JSGenericParameterImpl) {
            JSType constraintType = ((JSGenericParameterImpl)expandedType).getConstraintType();
            if (constraintType != null) {
                return TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constraintType.substitute());
            }
            Set<String> set = Collections.emptySet();
            if (set == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(34);
            }
            return set;
        }
        if (expandedType instanceof JSUnionType) {
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            for (JSType jsType2 : ((JSUnionType)expandedType).getTypes()) {
                result2.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(jsType2));
            }
            LinkedHashSet<String> linkedHashSet = result2;
            if (linkedHashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(35);
            }
            return linkedHashSet;
        }
        if (expandedType instanceof JSIntersectionType) {
            HashSet<String> strings = new HashSet<String>();
            for (JSType constituent : ((JSIntersectionType)expandedType).getTypes()) {
                if (strings.isEmpty()) {
                    strings.addAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
                    continue;
                }
                strings.retainAll(TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(constituent));
            }
            HashSet<String> hashSet = strings;
            if (hashSet == null) {
                TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(36);
            }
            return hashSet;
        }
        JSType substitute = JSTypeWithIncompleteSubstitution.substituteCompletely(expandedType);
        if (substitute != expandedType) {
            return TypeScriptIndexedAccessJSTypeImpl.getParameterStrings(substitute);
        }
        List list6 = ContainerUtil.emptyList();
        if (list6 == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(37);
        }
        return list6;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(38);
        }
        this.getOwner().accept(visitor);
        this.getParameterType().accept(visitor);
    }

    @NotNull
    public JSType getOwner() {
        JSType jSType = this.myOwner;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(39);
        }
        return jSType;
    }

    @NotNull
    public JSType getParameterType() {
        JSType jSType = this.myParameterType;
        if (jSType == null) {
            TypeScriptIndexedAccessJSTypeImpl.$$$reportNull$$$0(40);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signatures";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expandedType";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptIndexedAccessJSTypeImpl";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterStrings";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "substituteInternal";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addType";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectPropertySignatures";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "collectClassSignatures";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAssignableToCommonType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getParameterStrings";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 17: 
            case 18: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

