/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.guard.operations;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSDecoratedType;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardChecker;
import com.intellij.lang.javascript.psi.types.guard.JSTypeGuardUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.guard.operations.JSApplyTypeOperationContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSConditionalTypeOperationBase;
import com.intellij.lang.javascript.psi.types.guard.operations.JSInferDecoratorsContext;
import com.intellij.lang.javascript.psi.types.guard.operations.JSTypeOperation;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNarrowTypeByInstanceOfOperation
extends JSConditionalTypeOperationBase {
    @NotNull
    private final JSType myInstanceType;

    public JSNarrowTypeByInstanceOfOperation(@NotNull JSTypeOperation prev, @NotNull JSExpression instanceOfRightExpression, boolean assumeTrue) {
        if (prev == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(0);
        }
        if (instanceOfRightExpression == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(1);
        }
        super(prev, assumeTrue);
        JSType type = JSNarrowTypeByInstanceOfOperation.getInstanceOfType(instanceOfRightExpression);
        this.myInstanceType = type == null ? JSAnyType.get(JSTypeSource.EMPTY) : type;
    }

    @Nullable
    private static JSType getInstanceOfType(@NotNull JSExpression expression) {
        if (expression == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(2);
        }
        if (!(expression instanceof JSReferenceExpression)) {
            return null;
        }
        JSReferenceExpression operand = (JSReferenceExpression)expression;
        return JSSymbolUtil.createNamespaceFromReferenceExpression(operand, JSContext.INSTANCE, false, false);
    }

    @Override
    @NotNull
    public JSType applyForPrevType(@NotNull JSApplyTypeOperationContext context, @NotNull JSType type) {
        JSType instanceOfType;
        if (context == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(3);
        }
        if (type == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(4);
        }
        if ((instanceOfType = context.expandOperationType(this.myInstanceType)) == null) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(5);
            }
            return jSType;
        }
        JSType targetType = instanceOfType.copyWithStrict(context.getDefaultTypeSource().isStrict());
        if (JSTypeGuardUtil.isSourceTypeAnyAndTargetTypeFunctionOrObject(type, targetType)) {
            JSType jSType = type;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(6);
            }
            return jSType;
        }
        if (JSTypeUtils.isAnyType(type)) {
            JSType jSType = this.myAssumeTrue ? targetType : type;
            if (jSType == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(7);
            }
            return jSType;
        }
        JSType narrowedType = context.getNarrowedType(type, targetType, this.myAssumeTrue, (el, el2) -> TypeScriptTypeRelations.isTypeDerivedFrom(el, el2, context.getContextElement()));
        JSType jSType = context.processNeverType(type, narrowedType);
        if (jSType == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(8);
        }
        return jSType;
    }

    @Override
    @NotNull
    protected Set<JSDecoratedType.TypeDecoration> inferTypeDecoratorsImpl(@NotNull JSInferDecoratorsContext context) {
        if (context == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(9);
        }
        Set<JSDecoratedType.TypeDecoration> prevDecorators = super.inferTypeDecoratorsImpl(context);
        if (!this.myAssumeTrue) {
            Set<JSDecoratedType.TypeDecoration> set = prevDecorators;
            if (set == null) {
                JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(10);
            }
            return set;
        }
        Set<JSDecoratedType.TypeDecoration> set = this.mergeSimilarDecorators(JSTypeGuardChecker.NOTNULL_NOTUNDEFINED, prevDecorators);
        if (set == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Override
    protected boolean checkOwnEquality(@NotNull JSTypeOperation sameTypeOperation) {
        if (sameTypeOperation == null) {
            JSNarrowTypeByInstanceOfOperation.$$$reportNull$$$0(12);
        }
        return this.checkTypeEquals(this.myInstanceType, ((JSNarrowTypeByInstanceOfOperation)sameTypeOperation).myInstanceType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOfRightExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByInstanceOfOperation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sameTypeOperation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/guard/operations/JSNarrowTypeByInstanceOfOperation";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "applyForPrevType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDecoratorsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceOfType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyForPrevType";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeDecoratorsImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkOwnEquality";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

