/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.typescript;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptGenericParameterImpl;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptGenericDeclarationTypeImpl
extends JSTypeBaseImpl
implements JSGenericParameterType {
    @NotNull
    private final JSTypeSubstitutor.JSTypeGenericId myId;
    @Nullable
    private final NotNullLazyValue<? extends JSType> myConstraintType;
    @Nullable
    private final NotNullLazyValue<? extends JSType> myDefaultType;

    public TypeScriptGenericDeclarationTypeImpl(@NotNull JSTypeSubstitutor.JSTypeGenericId id, @Nullable NotNullLazyValue<? extends JSType> constraintType, @Nullable NotNullLazyValue<? extends JSType> defaultType, @NotNull JSTypeSource source2) {
        if (id == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(0);
        }
        if (source2 == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(1);
        }
        super(source2);
        this.myId = id;
        this.myConstraintType = constraintType;
        this.myDefaultType = defaultType;
    }

    public TypeScriptGenericDeclarationTypeImpl(@NotNull JSTypeSource source2, @NotNull CharacterIterator inputStream) {
        if (source2 == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(2);
        }
        if (inputStream == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(3);
        }
        super(source2);
        this.myId = JSTypeSerializer.readGenericId(inputStream);
        JSType constraintType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source2, inputStream);
        this.myConstraintType = constraintType == null ? null : NotNullLazyValue.createConstantValue((Object)constraintType);
        JSType defaultType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source2, inputStream);
        this.myDefaultType = defaultType == null ? null : NotNullLazyValue.createConstantValue((Object)defaultType);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(4);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeGenericId(this.myId, outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.getConstraintType(), outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.getDefaultType(), outputStream);
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        if (childTransform == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(5);
        }
        if (newSource == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(6);
        }
        JSType defaultType = this.getDefaultType();
        JSType newDefault = JSTypeUtils.transformTypeHierarchySafe(defaultType, childTransform);
        JSType constraintType = this.getConstraintType();
        JSType newConstraint = JSTypeUtils.transformTypeHierarchySafe(constraintType, childTransform);
        if (newDefault == defaultType && newConstraint == constraintType) {
            TypeScriptGenericDeclarationTypeImpl typeScriptGenericDeclarationTypeImpl = this;
            if (typeScriptGenericDeclarationTypeImpl == null) {
                TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(7);
            }
            return typeScriptGenericDeclarationTypeImpl;
        }
        return new TypeScriptGenericDeclarationTypeImpl(this.myId, (NotNullLazyValue<? extends JSType>)(newConstraint != null ? NotNullLazyValue.createConstantValue((Object)newConstraint) : null), (NotNullLazyValue<? extends JSType>)(newDefault != null ? NotNullLazyValue.createConstantValue((Object)newDefault) : null), newSource);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source2) {
        if (source2 == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(8);
        }
        return new TypeScriptGenericDeclarationTypeImpl(this.myId, this.myConstraintType, this.myDefaultType, source2);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(9);
        }
        if (processingContext == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(10);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        JSType defaultType;
        JSType constraintType;
        if (visitor == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(11);
        }
        if ((constraintType = this.getConstraintType()) != null) {
            constraintType.accept(visitor);
        }
        if ((defaultType = this.getDefaultType()) != null) {
            defaultType.accept(visitor);
        }
    }

    @Override
    protected boolean isEquivalentToWithSameClass(@NotNull JSType type, @Nullable ProcessingContext context, boolean allowResolve) {
        TypeScriptGenericDeclarationTypeImpl rType;
        if (type == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(12);
        }
        if (!Objects.equals((rType = (TypeScriptGenericDeclarationTypeImpl)type).getName(), this.getName())) {
            return false;
        }
        if (!JSType.isEquivalentToSafe(this.getConstraintType(), rType.getConstraintType(), context, allowResolve)) {
            return false;
        }
        if (!JSType.isEquivalentToSafe(this.getDefaultType(), rType.getDefaultType(), context, allowResolve)) {
            return false;
        }
        return this.myId.equals(rType.myId);
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myId, this.getConstraintType(), this.getDefaultType());
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        JSType constraintType;
        if (format == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(14);
        }
        builder.append(this.myId.getName());
        JSType defaultType = this.getDefaultType();
        if (defaultType != null) {
            builder.append("=");
            defaultType.buildTypeText(format, builder);
        }
        if ((constraintType = this.getConstraintType()) != null) {
            builder.append(" extends ");
            constraintType.buildTypeText(format, builder);
        }
    }

    @Override
    @Nullable
    public JSType getConstraintType() {
        return this.myConstraintType != null ? (JSType)this.myConstraintType.getValue() : null;
    }

    @Nullable
    public JSType getDefaultType() {
        return this.myDefaultType != null ? (JSType)this.myDefaultType.getValue() : null;
    }

    @NotNull
    public String getName() {
        String string = this.myId.getName();
        if (string == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public JSTypeSubstitutor.JSTypeGenericId getGenericId() {
        JSTypeSubstitutor.JSTypeGenericId jSTypeGenericId = this.myId;
        if (jSTypeGenericId == null) {
            TypeScriptGenericDeclarationTypeImpl.$$$reportNull$$$0(16);
        }
        return jSTypeGenericId;
    }

    @NotNull
    public JSGenericParameterType toGenericParameter() {
        return new TypeScriptGenericParameterImpl(this.myId, this.getSource(), this.getConstraintType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/typescript/TypeScriptGenericDeclarationTypeImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/typescript/TypeScriptGenericDeclarationTypeImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenericId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

