/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractSuper;

import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersDialog;
import com.intellij.lang.ecmascript6.refactoring.FilePathWithBrowseButton;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.JSNamesValidation;
import com.intellij.lang.javascript.refactoring.extractSuper.ES6ExtractSuperParameters;
import com.intellij.lang.javascript.refactoring.extractSuper.ES6ExtractSuperProcessor;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractInterfaceHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperClassHandler;
import com.intellij.lang.javascript.refactoring.extractSuper.JSExtractSuperMode;
import com.intellij.lang.javascript.refactoring.ui.JSMemberSelectionPanel;
import com.intellij.lang.javascript.refactoring.util.JSInterfaceContainmentVerifier;
import com.intellij.lang.javascript.refactoring.util.JSMemberInfo;
import com.intellij.lang.javascript.refactoring.util.JSUsesAndInterfacesDependencyMemberInfoModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExtractSuperDialog
extends RefactoringDialog {
    @Nullable
    private JRadioButton myExtractAndTurnRefsRB;
    @NlsContexts.DialogTitle
    @NotNull
    private final String myRefactoringName;
    protected final JSClass mySourceClass;
    protected final List<JSMemberInfo> myMemberInfos;
    private final boolean myIsExtractInterface;
    @Nullable
    private JRadioButton myRbExtractSuperclass;
    private JTextField mySourceClassField;
    private JLabel myClassNameLabel;
    private JTextField myExtractedSuperNameField;
    protected FilePathWithBrowseButton myDestinationFileField;

    public ES6ExtractSuperDialog(@NotNull JSClass sourceClass, @Nullable JSElement selectedElement, boolean isExtractInterface) {
        if (sourceClass == null) {
            ES6ExtractSuperDialog.$$$reportNull$$$0(0);
        }
        super(sourceClass.getProject(), true);
        this.myRefactoringName = isExtractInterface ? JSExtractInterfaceHandler.getRefactoringName() : JSExtractSuperClassHandler.getRefactoringName();
        this.mySourceClass = sourceClass;
        this.myMemberInfos = JSMemberInfo.selectMembers(sourceClass, selectedElement, (MemberInfoBase.Filter<? super JSAttributeListOwner>)((MemberInfoBase.Filter)t -> !isExtractInterface || !JSPsiImplUtils.hasModifier(t, JSAttributeList.ModifierType.STATIC)));
        this.myIsExtractInterface = isExtractInterface;
        this.init();
    }

    protected void init() {
        this.setTitle(this.myRefactoringName);
        this.mySourceClassField = this.createSourceClassField();
        PsiFile containingFile = this.mySourceClass.getContainingFile();
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)containingFile);
        String defaultPath = file2 == null ? "" : StringUtil.notNullize((String)file2.getPresentableUrl());
        this.myDestinationFileField = ES6MoveModuleMembersDialog.createDestinationFileField(this.mySourceClass, defaultPath);
        this.myExtractedSuperNameField = new JTextField();
        this.myExtractedSuperNameField.setText(StringUtil.notNullize((String)this.mySourceClass.getName()));
        super.init();
        this.updateDialog();
    }

    @Nullable
    protected JComponent createActionComponent() {
        if (DialectDetector.isJavaScript(this.mySourceClass)) {
            return null;
        }
        Box box = Box.createHorizontalBox();
        String s = StringUtil.decapitalize((String)this.getEntityName());
        this.myRbExtractSuperclass = new JRadioButton();
        this.myRbExtractSuperclass.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{s}));
        box.add(this.myRbExtractSuperclass);
        box.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myRbExtractSuperclass);
        this.myExtractAndTurnRefsRB = new JRadioButton(JavaScriptBundle.message("extract.0.turn.refs", StringUtil.decapitalize((String)this.getEntityName())));
        buttonGroup.add(this.myExtractAndTurnRefsRB);
        box.add((Component)this.myExtractAndTurnRefsRB, 1);
        this.myExtractAndTurnRefsRB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ES6ExtractSuperDialog.this.updateDialog();
            }
        });
        this.myRbExtractSuperclass.setSelected(true);
        ItemListener listener2 = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ES6ExtractSuperDialog.this.updateDialog();
            }
        };
        this.myRbExtractSuperclass.addItemListener(listener2);
        return box;
    }

    protected JComponent createNorthPanel() {
        Box box = Box.createVerticalBox();
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)new JLabel(this.getTopLabelText()), "North");
        _panel.add((Component)this.mySourceClassField, "Center");
        box.add(_panel);
        JComponent actionComponent = this.createActionComponent();
        if (actionComponent != null) {
            box.add(Box.createVerticalStrut(10));
            box.add(actionComponent);
            box.add(Box.createVerticalStrut(10));
        }
        this.myClassNameLabel = new JLabel();
        _panel = new JPanel(new BorderLayout());
        _panel.add((Component)this.myClassNameLabel, "North");
        _panel.add((Component)this.myExtractedSuperNameField, "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(5));
        _panel = new JPanel(new BorderLayout());
        JLabel destinationFileLabel = new JLabel();
        destinationFileLabel.setText(JavaScriptBundle.message("es6.extract.super.destination.label", new Object[0]));
        _panel.add((Component)destinationFileLabel, "North");
        _panel.add((Component)((Object)this.myDestinationFileField), "Center");
        box.add(_panel);
        box.add(Box.createVerticalStrut(10));
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)box, "Center");
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedSuperNameField;
    }

    public String getExtractedSuperName() {
        return this.myExtractedSuperNameField.getText().trim();
    }

    protected void doAction() {
        String extractedSuperName = this.getExtractedSuperName();
        if (extractedSuperName != null && extractedSuperName.isEmpty()) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage(this.getExtractedSuperNameNotSpecifiedMessage());
            return;
        }
        String nameError = this.validateName(extractedSuperName);
        if (nameError != null) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage(nameError);
            return;
        }
        if (StringUtil.equals((CharSequence)extractedSuperName, (CharSequence)this.mySourceClass.getName())) {
            this.myExtractedSuperNameField.requestFocusInWindow();
            this.showErrorMessage(JavaScriptBundle.message("es6.extract.super.different.name.expected", new Object[0]));
            return;
        }
        String validationMessage = ES6MoveModuleMembersDialog.checkOrCreateFile((PsiElement)this.mySourceClass.getContainingFile(), this.myDestinationFileField.getText(), this.getTitle(), true);
        if (validationMessage != null) {
            this.myDestinationFileField.requestFocusInWindow();
            this.showErrorMessage(validationMessage);
            return;
        }
        this.invokeRefactoring(this.createProcessor());
        this.closeOKAction();
    }

    private void showErrorMessage(@Nullable @NlsContexts.DialogMessage String s) {
        if (StringUtil.isNotEmpty((String)s)) {
            CommonRefactoringUtil.showErrorMessage((String)this.myRefactoringName, (String)s, (String)this.getHelpId(), (Project)this.myProject);
        }
    }

    @NotNull
    @NlsContexts.DialogMessage
    protected String getExtractedSuperNameNotSpecifiedMessage() {
        String string = this.myIsExtractInterface ? RefactoringBundle.message((String)"no.interface.name.specified") : RefactoringBundle.message((String)"no.superclass.name.specified");
        if (string == null) {
            ES6ExtractSuperDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsContexts.Label
    @NotNull
    protected String getTopLabelText() {
        String string = this.myIsExtractInterface ? RefactoringBundle.message((String)"extract.interface.from") : RefactoringBundle.message((String)"extract.superclass.from");
        if (string == null) {
            ES6ExtractSuperDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected BaseRefactoringProcessor createProcessor() {
        ES6ExtractSuperParameters parameters = new ES6ExtractSuperParameters(this.mySourceClass, this.getSelectedMemberInfos().toArray(JSMemberInfo.EMPTY_ARRAY), this.getExtractedSuperName(), this.myDestinationFileField.getText(), 2, this.getMode(), !this.myIsExtractInterface);
        return new ES6ExtractSuperProcessor(parameters);
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        String message = this.myIsExtractInterface ? JavaScriptBundle.message("es6.extract.super.members.in.interface", new Object[0]) : JavaScriptBundle.message("es6.extract.super.members.in.superclass", new Object[0]);
        String abstractColumnHeader = this.myIsExtractInterface ? null : RefactoringBundle.message((String)"make.abstract");
        JSMemberSelectionPanel memberSelectionPanel = new JSMemberSelectionPanel(message, this.myMemberInfos, abstractColumnHeader);
        MyMemberInfoModel model = new MyMemberInfoModel(this.mySourceClass);
        memberSelectionPanel.getTable().setMemberInfoModel((MemberInfoModel)model);
        memberSelectionPanel.getTable().addMemberInfoChangeListener((MemberInfoChangeListener)model);
        model.memberInfoChanged(new MemberInfoChange(this.myMemberInfos));
        panel2.add((Component)memberSelectionPanel, "Center");
        return panel2;
    }

    protected String getHelpId() {
        return DialectDetector.isTypeScript(this.mySourceClass) ? (this.myIsExtractInterface ? "reference.typescript.extract.interface" : "reference.typescript.extract.superclass") : "reference.javascript.extract.superclass";
    }

    @Nls
    protected String getClassNameLabelText() {
        return this.myIsExtractInterface ? RefactoringBundle.message((String)"interface.name.prompt") : RefactoringBundle.message((String)"superclass.name");
    }

    @NotNull
    protected String getEntityName() {
        String string = this.myIsExtractInterface ? RefactoringBundle.message((String)"extractSuperInterface.interface") : RefactoringBundle.message((String)"ExtractSuperClass.superclass");
        if (string == null) {
            ES6ExtractSuperDialog.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected JTextField createSourceClassField() {
        JTextField result2 = new JTextField(this.mySourceClass.getName());
        result2.setEnabled(false);
        result2.setEditable(false);
        return result2;
    }

    @NlsContexts.DialogMessage
    @Nullable
    protected String validateName(String name) {
        if (name != null && name.isEmpty()) {
            return RefactoringBundle.message((String)"no.destination.class.specified");
        }
        if (!JSNamesValidation.isIdentifier(name, this.mySourceClass)) {
            return JavaScriptBundle.message("0.is.not.a.legal.name", name);
        }
        return null;
    }

    public Collection<JSMemberInfo> getSelectedMemberInfos() {
        return Arrays.asList(JSMemberInfo.getSelected(this.myMemberInfos, this.mySourceClass, (Condition<? super JSMemberInfo>)Conditions.alwaysTrue()));
    }

    protected JSExtractSuperMode getMode() {
        if (this.myRbExtractSuperclass != null && this.myRbExtractSuperclass.isSelected()) {
            return JSExtractSuperMode.ExtractSuper;
        }
        if (this.myExtractAndTurnRefsRB != null && this.myExtractAndTurnRefsRB.isSelected()) {
            return JSExtractSuperMode.ExtractSuperTurnRefs;
        }
        return JSExtractSuperMode.ExtractSuper;
    }

    protected void updateDialog() {
        this.myClassNameLabel.setText(this.getClassNameLabelText());
        this.getPreviewAction().setEnabled(this.getMode() != JSExtractSuperMode.ExtractSuper);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractedSuperNameNotSpecifiedMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLabelText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEntityName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMemberInfoModel
    extends JSUsesAndInterfacesDependencyMemberInfoModel {
        MyMemberInfoModel(JSClass aClass) {
            super(aClass, null, false, JSInterfaceContainmentVerifier.create(ES6ExtractSuperDialog.this.myMemberInfos));
        }

        public int checkForProblems(@NotNull JSMemberInfo member) {
            if (member == null) {
                MyMemberInfoModel.$$$reportNull$$$0(0);
            }
            if (ES6ExtractSuperDialog.this.myIsExtractInterface) {
                return 0;
            }
            return super.checkForProblems((MemberInfoBase)member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/refactoring/extractSuper/ES6ExtractSuperDialog$MyMemberInfoModel", "checkForProblems"));
        }
    }
}

