/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceVariable;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatementList;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.refactoring.JSIntroduceTargetChooser;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionPopup;
import com.intellij.lang.javascript.refactoring.JSScopeSelectionUI;
import com.intellij.lang.javascript.refactoring.introduce.BaseIntroduceSettings;
import com.intellij.lang.javascript.refactoring.introduce.BasicIntroducedEntityInfoProvider;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.InplaceSettings;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.introduce.inplace.OccurrencesChooser;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntroduceConstantHandler
extends JSBaseIntroduceHandler<JSSourceElement, BaseIntroduceSettings, JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider>>
implements ContextAwareActionHandler {
    private static final JSIntroduceTargetChooser<JSElement> DEFAULT_SCOPE_CHOOSER = (editor, elements, callback, presenter) -> callback.pass(ContainerUtil.getLastItem((List)elements));
    private final JSIntroduceTargetChooser<JSElement> myScopeChooser;
    private final JSIntroduceFieldHandler myFieldHandler;
    private final JSNoBalloonIntroduceVariableHandler myVarHandler;

    public JSIntroduceConstantHandler() {
        this(ApplicationManager.getApplication().isUnitTestMode() ? DEFAULT_SCOPE_CHOOSER : JSIntroduceConstantHandler::showScopeChooser);
    }

    public JSIntroduceConstantHandler(JSIntroduceTargetChooser<JSElement> chooser) {
        this.myScopeChooser = chooser;
        this.myFieldHandler = new JSIntroduceFieldHandler(true){

            @Override
            @Nullable
            @NonNls
            public String getRefactoringId() {
                return JSIntroduceConstantHandler.this.getRefactoringId();
            }
        };
        this.myVarHandler = new JSNoBalloonIntroduceVariableHandler(){

            @Override
            @Nullable
            @NonNls
            public String getRefactoringId() {
                return JSIntroduceConstantHandler.this.getRefactoringId();
            }

            @Override
            protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope) {
                return Settings.IntroducedVarType.CONST;
            }

            @Override
            protected JSSourceElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, boolean replaceAllOccurrences) {
                return JSIntroduceConstantHandler.this.findAnchor((JSBaseIntroduceHandler.BaseIntroduceContext)context, replaceAllOccurrences);
            }
        };
    }

    @Override
    @Nullable
    @NonNls
    public String getRefactoringId() {
        return "refactoring.javascript.introduceConstant";
    }

    @Override
    protected boolean canInplaceIntroduceForSubexpression() {
        return true;
    }

    public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(2);
        }
        return JSIntroduceConstantHandler.isSupportedLanguageLevel((PsiElement)ObjectUtils.coalesce((Object)((PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)), (Object)file2));
    }

    private static boolean isSupportedLanguageLevel(@NotNull PsiElement element) {
        DialectOptionHolder dialect;
        if (element == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(3);
        }
        return (dialect = DialectDetector.dialectOfElement(element)) != null && (dialect.isTypeScript || dialect.isFlow || dialect.isECMA6);
    }

    private static void showScopeChooser(Editor editor, List<? extends JSElement> elements, Pass<? super JSElement> pass, Function<? super JSElement, String> presenter) {
        if (elements.size() == 0) {
            return;
        }
        if (elements.size() == 1) {
            pass.accept((Object)elements.get(0));
            return;
        }
        new JSScopeSelectionPopup<JSElement>(editor, 3){

            @Override
            protected void doSetText(JSElement value, DefaultListCellRenderer renderer) {
                renderer.setText(JSIntroduceConstantHandler.getScopePresentation(value));
            }
        }.show(elements.get(0), ContainerUtil.map(elements, e -> new JSScopeSelectionUI.ScopePresentation<JSElement>((JSElement)e, JSIntroduceConstantHandler.getScopePresentation(e), JSIntroduceConstantHandler.getScopePresentableOffset(e), e instanceof JSFile ? 0 : 1)), (Consumer<JSElement>)pass);
    }

    private static int getScopePresentableOffset(@NotNull JSElement e) {
        JSBlockStatement block;
        PsiElement itemAtOffset;
        Editor editor;
        if (e == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(4);
        }
        int currentOffset = (editor = PsiEditorUtil.findEditor((PsiElement)e)) == null ? -1 : editor.getCaretModel().getOffset();
        PsiFile file2 = e.getContainingFile();
        PsiElement psiElement = itemAtOffset = file2 == null || currentOffset == -1 ? null : file2.findElementAt(currentOffset);
        if (e instanceof JSClass) {
            PsiElement memberForOffset = JSIntroduceConstantHandler.getMemberForTooltip(itemAtOffset, (PsiElement)e, ((JSClass)e).getMembers());
            return memberForOffset.getTextRange().getEndOffset();
        }
        if (e instanceof JSStatementList) {
            PsiElement memberForOffset = JSIntroduceConstantHandler.getMemberForTooltip(itemAtOffset, (PsiElement)e, Arrays.asList(((JSStatementList)((Object)e)).getStatementListItems()));
            return memberForOffset.getTextRange().getStartOffset();
        }
        if (e instanceof JSFunction && (block = ((JSFunction)e).getBlock()) != null) {
            return JSIntroduceConstantHandler.getScopePresentableOffset(block);
        }
        return e.getTextOffset();
    }

    private static PsiElement getMemberForTooltip(PsiElement itemAtOffset, PsiElement memberForOffset, Iterable<? extends JSElement> members) {
        PsiElement child;
        if (itemAtOffset != null) {
            boolean first = true;
            for (JSElement jSElement : members) {
                if (PsiTreeUtil.isAncestor((PsiElement)jSElement, (PsiElement)itemAtOffset, (boolean)false)) {
                    if (first) break;
                    memberForOffset = jSElement;
                    break;
                }
                first = false;
            }
        }
        if ((child = memberForOffset.getFirstChild()) instanceof PsiWhiteSpace) {
            child = PsiTreeUtil.skipWhitespacesForward((PsiElement)child);
        }
        return (PsiElement)ObjectUtils.coalesce((Object)child, (Object)memberForOffset);
    }

    @Override
    protected JSBaseInplaceIntroducer<BaseIntroduceSettings> createInplaceIntroducer(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, JSElement scope, Editor editor, Project project, JSExpression[] occurrences, Runnable callback) {
        if (scope instanceof JSClass) {
            return this.myFieldHandler.createInplaceIntroducer((JSBaseIntroduceHandler.BaseIntroduceContext)context, scope, editor, project, occurrences, callback);
        }
        return this.myVarHandler.createInplaceIntroducer(context, scope, editor, project, occurrences, callback);
    }

    @Override
    protected boolean isInplaceIntroduce(Editor editor, JSElement scope, PsiFile file2) {
        return !(scope instanceof JSClass) && super.isInplaceIntroduce(editor, scope, file2);
    }

    @Override
    protected void findIntroducedScope(@NotNull Editor editor, @NotNull Pair<? extends JSExpression, ? extends TextRange> expressionDescriptor, @NotNull NullableConsumer<? super JSElement> callback) {
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(5);
        }
        if (expressionDescriptor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(7);
        }
        JSIntroduceConstantHandler.chooseElement(this.myScopeChooser, editor, JSIntroduceConstantHandler.getScopeCandidates((JSExpression)expressionDescriptor.first), arg_0 -> callback.consume(arg_0), JSIntroduceConstantHandler::getScopePresentation);
    }

    @Override
    protected String getDeclText(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> baseIntroduceContext, JSSourceElement anchor) {
        return baseIntroduceContext.scope instanceof JSClass ? this.myFieldHandler.getDeclText(baseIntroduceContext, anchor) : this.myVarHandler.getDeclText(baseIntroduceContext, anchor);
    }

    @Override
    protected Pair<JSVarStatement, Boolean> prepareDeclaration(String varDeclText, JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, Project project, @Nullable JSLanguageDialect languageDialect, JSSourceElement anchorStatement, Editor editor) throws IncorrectOperationException {
        return context.scope instanceof JSClass ? this.myFieldHandler.prepareDeclaration(varDeclText, context, project, languageDialect, anchorStatement, editor) : this.myVarHandler.prepareDeclaration(varDeclText, context, project, languageDialect, anchorStatement, editor);
    }

    private static boolean isAwaitOrYield(PsiElement element) {
        return element instanceof JSPrefixExpression && ((JSPrefixExpression)element).getOperationSign() == JSTokenTypes.AWAIT_KEYWORD || element instanceof JSYieldExpression;
    }

    @NotNull
    private static List<JSElement> getScopeCandidates(JSExpression first) {
        PsiFile file2;
        JSElement grandParent;
        SmartList candidates = new SmartList();
        JSElement parentElement = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)first, (Class[])new Class[]{JSClass.class, JSFunction.class});
        if (parentElement != null && JSIntroduceConstantHandler.checkLocalRefs(first, parentElement)) {
            candidates.add(parentElement);
        }
        if (parentElement instanceof JSFunction && (((JSFunction)parentElement).isAsync() || ((JSFunction)parentElement).isGenerator()) && ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)first).forceIgnore(Conditions.instanceOf(JSFunction.class))).filter(JSIntroduceConstantHandler::isAwaitOrYield)).traverse().isNotEmpty()) {
            SmartList smartList = candidates;
            if (smartList == null) {
                JSIntroduceConstantHandler.$$$reportNull$$$0(8);
            }
            return smartList;
        }
        if ((parentElement == null || parentElement instanceof JSFunction) && (grandParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)parentElement, (Object)first)), JSClass.class)) != null && JSIntroduceConstantHandler.checkLocalRefs(first, grandParent)) {
            candidates.add(grandParent);
        }
        if ((candidates.isEmpty() || parentElement instanceof JSClass) && (grandParent = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)parentElement, (Object)first)), JSFunction.class)) != null && JSIntroduceConstantHandler.checkLocalRefs(first, grandParent)) {
            candidates.add(grandParent);
        }
        if ((file2 = first.getContainingFile()) instanceof JSFile && JSIntroduceConstantHandler.checkLocalRefs(first, (JSFile)file2)) {
            candidates.add((JSElement)file2);
        }
        SmartList smartList = candidates;
        if (smartList == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    private static boolean checkLocalRefs(JSExpression first, JSElement parentElement) {
        if (parentElement instanceof JSClass && !DialectDetector.isTypeScript((PsiElement)parentElement)) {
            return false;
        }
        return SyntaxTraverser.psiTraverser((PsiElement)first).filter(JSReferenceExpression.class).filter(referenceExpression -> JSIntroduceConstantHandler.isLocalReference(referenceExpression, parentElement)).isEmpty();
    }

    private static boolean isLocalReference(JSReferenceExpression referenceExpression, JSElement parentElement) {
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier instanceof JSThisExpression) {
            PsiElement element = ((JSThisExpression)qualifier).resolve();
            return element != null && PsiTreeUtil.isAncestor((PsiElement)parentElement, (PsiElement)element, (boolean)true);
        }
        PsiElement resolve = referenceExpression.resolve();
        if (resolve == null) {
            return false;
        }
        SearchScope scope = resolve.getUseScope();
        if (!(scope instanceof LocalSearchScope)) {
            return false;
        }
        for (PsiElement element : ((LocalSearchScope)scope).getScope()) {
            if (!PsiTreeUtil.isAncestor((PsiElement)parentElement, (PsiElement)element, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.ListItem
    private static String getScopePresentation(@NotNull JSElement element) {
        if (element == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(10);
        }
        if (element instanceof JSClass) {
            return JavaScriptBundle.message("list.item.class.field", new Object[0]);
        }
        if (element instanceof JSFile) {
            return JavaScriptBundle.message("list.item.global.or.module.constant", new Object[0]);
        }
        return JavaScriptBundle.message("list.item.local.constant", new Object[0]);
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = JavaScriptBundle.message("javascript.introduce.constant.title", new Object[0]);
        if (string == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    protected String getCannotIntroduceMessagePropertyKey() {
        return "javascript.introduce.constant.error.no.expression.selected";
    }

    @Override
    protected String getCannotIntroduceVoidExpressionTypeMessagePropertyKey() {
        return "javascript.introduce.constant.error.expression.has.void.type";
    }

    @Override
    protected InplaceSettings<BaseIntroduceSettings> getInplaceSettings(Pair<JSExpression, TextRange> expr, JSExpression[] occurrences, PsiElement scope, OccurrencesChooser.ReplaceChoice choice) {
        if (scope instanceof JSClass) {
            return this.myFieldHandler.getInplaceSettings(expr, occurrences, scope, choice);
        }
        return this.myVarHandler.getInplaceSettings(expr, occurrences, scope, choice);
    }

    @Override
    protected JSBaseIntroduceDialog<BasicIntroducedEntityInfoProvider> createDialog(Project project, JSExpression expression, JSExpression[] occurrences, PsiElement scope) {
        if (scope instanceof JSClass) {
            return this.myFieldHandler.createDialog(project, expression, occurrences, scope);
        }
        return this.myVarHandler.createDialog(project, expression, occurrences, scope);
    }

    @Override
    public JSExpression createRefExpr(PsiElement context, BaseIntroduceSettings settings, PsiElement scope, JSLanguageDialect languageDialect) {
        return scope instanceof JSClass ? this.myFieldHandler.createRefExpr(context, settings, scope, languageDialect) : this.myVarHandler.createRefExpr(context, settings, scope, languageDialect);
    }

    @Override
    protected boolean isSilent() {
        return true;
    }

    @Override
    protected void afterIntroduce(boolean isInPlace, JSElement scope, Editor editor) {
        if (isInPlace) {
            return;
        }
        PsiFile file2 = scope.getContainingFile();
        PsiElement element = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
        if (element instanceof PsiWhiteSpace) {
            element = file2.findElementAt(editor.getCaretModel().getOffset());
        }
        if (element == null) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof JSThisExpression) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSReferenceExpression)) {
            return;
        }
        PsiElement resolved = ((JSReferenceExpression)parent).resolve();
        if (!(resolved instanceof JSFieldVariable)) {
            return;
        }
        editor.getCaretModel().moveToOffset(parent.getTextRange().getEndOffset());
        JSRefactoringUtil.suggestSameFileRename(file2, editor, (JSFieldVariable)resolved, ((JSFieldVariable)resolved).getName());
    }

    @Override
    protected boolean validateSelectedExpression(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Pair<JSExpression, TextRange> expressionDescriptor) {
        JSExpression expression;
        if (file2 == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(13);
        }
        if (expressionDescriptor == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(14);
        }
        if (!JSIntroduceConstantHandler.isSupportedLanguageLevel((PsiElement)(expression = (JSExpression)expressionDescriptor.first))) {
            this.showErrorHint(editor, file2, JavaScriptBundle.message("javascript.introduce.constant.in.es5", new Object[0]));
            return false;
        }
        return super.validateSelectedExpression(file2, editor, expressionDescriptor);
    }

    @Override
    protected JSSourceElement findAnchor(JSBaseIntroduceHandler.BaseIntroduceContext<BaseIntroduceSettings> context, boolean replaceAllOccurrences) {
        JSExpression[] jSExpressionArray;
        if (replaceAllOccurrences) {
            jSExpressionArray = context.occurrences;
        } else {
            JSExpression[] jSExpressionArray2 = new JSExpression[1];
            jSExpressionArray = jSExpressionArray2;
            jSExpressionArray2[0] = (JSExpression)context.expressionDescriptor.first;
        }
        JSExpression[] allExpressions = jSExpressionArray;
        PsiElement scope = context.scope;
        for (PsiElement child : JSIntroduceConstantHandler.getAnchorChildren(scope)) {
            if (!(child instanceof JSSourceElement) || !Arrays.stream(allExpressions).allMatch(e -> PsiTreeUtil.isAncestor((PsiElement)child, (PsiElement)e, (boolean)true))) continue;
            return (JSSourceElement)child;
        }
        return (JSSourceElement)super.findAnchor(context, replaceAllOccurrences);
    }

    private static PsiElement @NotNull [] getAnchorChildren(PsiElement scope) {
        if (scope instanceof JSFunction) {
            JSBlockStatement block = ((JSFunction)scope).getBlock();
            PsiElement[] psiElementArray = block == null ? PsiElement.EMPTY_ARRAY : block.getChildren();
            if (psiElementArray == null) {
                JSIntroduceConstantHandler.$$$reportNull$$$0(15);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = scope.getChildren();
        if (psiElementArray == null) {
            JSIntroduceConstantHandler.$$$reportNull$$$0(16);
        }
        return psiElementArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionDescriptor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceConstantHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/introduceVariable/JSIntroduceConstantHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeCandidates";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchorChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableForQuickList";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSupportedLanguageLevel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getScopePresentableOffset";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIntroducedScope";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getScopePresentation";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateSelectedExpression";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

