/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.regexp;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.EnumSet;
import java.util.List;
import org.intellij.lang.regexp.DefaultRegExpPropertiesProvider;
import org.intellij.lang.regexp.RegExpLanguageHost;
import org.intellij.lang.regexp.ecmascript.EcmaScriptUnicodeRegexpLanguage;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElement;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNamedGroupRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRegexpHost
implements RegExpLanguageHost {
    private final DefaultRegExpPropertiesProvider myPropertiesProvider;
    private final Property[] myBinaryProperties = new Property[]{new Property("ASCII", "ASCII", new String[0]), new Property("AHex", "Hexadecimal digit or ASCII", "ASCII_Hex_Digit"), new Property("Alpha", "Alphabetic characters", "Alphabetic"), new Property("Any", null, new String[0]), new Property("Assigned", null, new String[0]), new Property("Bidi_C", null, "Bidi_Control"), new Property("Bidi_M", null, "Bidi_Mirrored"), new Property("CI", null, "Case_Ignorable"), new Property("Cased", null, new String[0]), new Property("CWCF", null, "Changes_When_Casefolded"), new Property("CWCM", null, "Changes_When_Casemapped"), new Property("CWL", null, "Changes_When_Lowercased"), new Property("CWKCF", null, "Changes_When_NFKC_Casefolded"), new Property("CWT", null, "Changes_When_Titlecased"), new Property("CWU", null, "Changes_When_Uppercased"), new Property("Dash", null, new String[0]), new Property("DI", null, "Default_Ignorable_Code_Point"), new Property("Dep", null, "Deprecated"), new Property("Dia", null, "Diacritic"), new Property("Emoji", null, new String[0]), new Property("Emoji_Component", null, new String[0]), new Property("Emoji_Modifier", null, new String[0]), new Property("Emoji_Modifier_Base", null, new String[0]), new Property("Emoji_Presentation", null, new String[0]), new Property("Ext", null, "Extender"), new Property("Gr_Base", null, "Grapheme_Base"), new Property("Gr_Ext", null, "Grapheme_Extend"), new Property("Hex", "Hexadecimal digit", "Hex_Digit"), new Property("IDSB", null, "IDS_Binary_Operator"), new Property("IDST", null, "IDS_Trinary_Operator"), new Property("IDC", null, "ID_Continue"), new Property("IDS", null, "ID_Start"), new Property("Ideo", null, "Ideographic"), new Property("Join_C", null, "Join_Control"), new Property("LOE", null, "Logical_Order_Exception"), new Property("Lower", "Lowercase Alphabetic", "Lowercase"), new Property("Math", "Math symbol", new String[0]), new Property("NChar", null, "Noncharacter_Code_Point"), new Property("Pat_Syn", null, "Pattern_Syntax"), new Property("Pat_WS", null, "Pattern_White_Space"), new Property("QMark", null, "Quotation_Mark"), new Property("Radical", null, new String[0]), new Property("RI", null, "Regional_Indicator"), new Property("STerm", null, "Sentence_Terminal"), new Property("SD", null, "Soft_Dotted"), new Property("Term", null, "Terminal_Punctuation"), new Property("UIdeo", null, "Unified_Ideograph"), new Property("Upper", "Uppercase Alphabetic", "Uppercase"), new Property("VS", null, "Variation_Selector"), new Property("Whitespace", "Whitespace", "White_Space", "space", "WSpace"), new Property("XIDC", null, "XID_Continue"), new Property("XIDS", null, "XID_Start")};
    private final Property[] myGeneralCategoryProperties = new Property[]{new Property("L", "Letter", "Letter"), new Property("Lu", "Uppercase Letter", "Uppercase_Letter"), new Property("Ll", "Lowercase Letter", "Lowercase_Letter"), new Property("Lt", "Titlecase Letter", "Titlecase_Letter"), new Property("Lm", "Modifier Letter", "Modifier_Letter"), new Property("Lo", "Other Letter", "Other_Letter"), new Property("M", "Mark", "Mark", "Combining_Mark"), new Property("Mn", "Non-Spacing Mark", "Nonspacing_Mark"), new Property("Mc", "Spacing Combining Mark", "Spacing_Mark"), new Property("Me", "Enclosing Mark", "Enclosing_Mark"), new Property("N", "Number", "Number"), new Property("Nd", "Decimal Digit Number", "Decimal_Number", "digit"), new Property("Nl", "Letter Number", "Letter_Number"), new Property("No", "Other Number", "Other_Number"), new Property("S", "Symbol", "Symbol"), new Property("Sm", "Math Symbol", "Math_Symbol"), new Property("Sc", "Currency Symbol", "Currency_Symbol"), new Property("Sk", "Modifier Symbol", "Modifier_Symbol"), new Property("So", "Other Symbol", "Other_Symbol"), new Property("P", "Punctuation", "Punctuation", "punct"), new Property("Pc", "Connector Punctuation", "Connector_Punctuation"), new Property("Pd", "Dash Punctuation", "Dash_Punctuation"), new Property("Ps", "Open Punctuation", "Open_Punctuation"), new Property("Pe", "Close Punctuation", "Close_Punctuation"), new Property("Pi", "Initial Punctuation", "Initial_Punctuation"), new Property("Pf", "Final Punctuation", "Final_Punctuation"), new Property("Po", "Other Punctuation", "Other_Punctuation"), new Property("Z", "Separator", "Separator"), new Property("Zs", "Space Separator", "Space_Separator"), new Property("Zl", "Line Separator", "Line_Separator"), new Property("Zp", "Paragraph Separator", "Paragraph_Separator"), new Property("C", "Other", "Other"), new Property("Cc", "Control", "Control", "cntrl"), new Property("Cf", "Format", "Format"), new Property("Cs", "Surrogate", "Surrogate"), new Property("Co", "Private Use", "Private_Use"), new Property("Cn", "Unassigned", "Unassigned")};
    private final String[][] myToplevelCompletionProperties;

    public JSRegexpHost() {
        this.myPropertiesProvider = DefaultRegExpPropertiesProvider.getInstance();
        List interestingBinaryProperties = ContainerUtil.filter((Object[])this.myBinaryProperties, property -> property.description != null);
        this.myToplevelCompletionProperties = (String[][])ArrayUtil.mergeArrays((Object[])JSRegexpHost.toCompletionItems(interestingBinaryProperties.toArray(new Property[0])), (Object[])JSRegexpHost.toCompletionItems(this.myGeneralCategoryProperties));
    }

    public boolean characterNeedsEscaping(char c) {
        return c == '/';
    }

    public boolean supportsPerl5EmbeddedComments() {
        return false;
    }

    public boolean supportsPossessiveQuantifiers() {
        return false;
    }

    public boolean supportsPythonConditionalRefs() {
        return false;
    }

    public boolean supportsNamedGroupSyntax(RegExpGroup group) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost((PsiElement)group);
        if (dialect != null && dialect.isECMA4) {
            return group.getType() == RegExpGroup.Type.PYTHON_NAMED_GROUP;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return group.getType() == RegExpGroup.Type.NAMED_GROUP;
        }
        return false;
    }

    public boolean isValidGroupName(String name, @NotNull RegExpGroup group) {
        int codePoint;
        DialectOptionHolder holder;
        if (group == null) {
            JSRegexpHost.$$$reportNull$$$0(0);
        }
        if (!JSRegexpHost.isES6Regexp(holder = JSRegexpHost.dialectOfHost((PsiElement)group))) {
            return super.isValidGroupName(name, group);
        }
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        int firstCodePoint = (name = JSStringUtil.replaceUnicodeEscapeSequences(name)).codePointAt(0);
        if (!JSRegexpHost.isGroupNameStart(firstCodePoint)) {
            return false;
        }
        for (int index = Character.charCount(firstCodePoint); index < name.length(); index += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(index);
            if (JSRegexpHost.isGroupNamePart(codePoint)) continue;
            return false;
        }
        return true;
    }

    private static boolean isGroupNameStart(int codePoint) {
        return Character.isUnicodeIdentifierStart(codePoint) || codePoint == 36 || codePoint == 95;
    }

    private static boolean isGroupNamePart(int codePoint) {
        return Character.isUnicodeIdentifierPart(codePoint) || codePoint == 36 || codePoint == 95;
    }

    public boolean supportsNamedGroupRefSyntax(RegExpNamedGroupRef ref) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost((PsiElement)ref);
        if (dialect != null && dialect.isECMA4) {
            return ref.isPythonNamedGroupRef();
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return ref.isNamedGroupRef();
        }
        return false;
    }

    @NotNull
    public EnumSet<RegExpGroup.Type> getSupportedNamedGroupTypes(RegExpElement context) {
        DialectOptionHolder dialect = JSRegexpHost.dialectOfHost((PsiElement)context);
        if (dialect != null && dialect.isECMA4) {
            EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.PYTHON_NAMED_GROUP);
            if (enumSet == null) {
                JSRegexpHost.$$$reportNull$$$0(1);
            }
            return enumSet;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            EnumSet<RegExpGroup.Type> enumSet = EnumSet.of(RegExpGroup.Type.NAMED_GROUP);
            if (enumSet == null) {
                JSRegexpHost.$$$reportNull$$$0(2);
            }
            return enumSet;
        }
        EnumSet enumSet = EMPTY_NAMED_GROUP_TYPES;
        if (enumSet == null) {
            JSRegexpHost.$$$reportNull$$$0(3);
        }
        return enumSet;
    }

    public boolean supportsExtendedHexCharacter(RegExpChar regExpChar) {
        return JSRegexpHost.isUnicodeRegexpLanguage((PsiElement)regExpChar) && regExpChar.getUnescapedText().charAt(1) == 'u';
    }

    public RegExpLanguageHost.Lookbehind supportsLookbehind(@NotNull RegExpGroup lookbehindGroup) {
        DialectOptionHolder dialect;
        if (lookbehindGroup == null) {
            JSRegexpHost.$$$reportNull$$$0(4);
        }
        if ((dialect = JSRegexpHost.dialectOfHost((PsiElement)lookbehindGroup)) != null && dialect.isECMA4) {
            return RegExpLanguageHost.Lookbehind.VARIABLE_LENGTH_ALTERNATION;
        }
        if (JSRegexpHost.isES6Regexp(dialect)) {
            return RegExpLanguageHost.Lookbehind.FULL;
        }
        return RegExpLanguageHost.Lookbehind.NOT_SUPPORTED;
    }

    private static boolean isES6Regexp(@Nullable DialectOptionHolder dialect) {
        return dialect != null && (dialect.isECMA6 || dialect.isTypeScript);
    }

    public boolean isValidCategory(@NotNull String category) {
        if (category == null) {
            JSRegexpHost.$$$reportNull$$$0(5);
        }
        return JSRegexpHost.findProperty(this.myBinaryProperties, category) != null || JSRegexpHost.findProperty(this.myGeneralCategoryProperties, category) != null;
    }

    public boolean isValidPropertyName(@NotNull String name) {
        if (name == null) {
            JSRegexpHost.$$$reportNull$$$0(6);
        }
        return JSRegexpHost.isGeneralCategory(name) || JSRegexpHost.isScriptPropertyName(name);
    }

    public boolean isValidPropertyValue(@NotNull String propertyName, @NotNull String value) {
        if (propertyName == null) {
            JSRegexpHost.$$$reportNull$$$0(7);
        }
        if (value == null) {
            JSRegexpHost.$$$reportNull$$$0(8);
        }
        if (JSRegexpHost.isGeneralCategory(propertyName)) {
            return JSRegexpHost.findProperty(this.myGeneralCategoryProperties, value) != null;
        }
        if (JSRegexpHost.isScriptPropertyName(propertyName)) {
            return JSRegexpHost.isValidUnicodeScript(value);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public String[] @NotNull [] getAllPropertyValues(@NotNull String propertyName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean supportsPropertySyntax(@NotNull PsiElement context) {
        if (context == null) {
            JSRegexpHost.$$$reportNull$$$0(10);
        }
        return JSRegexpHost.isUnicodeRegexpLanguage(context) && JSRegexpHost.isES6Regexp(JSRegexpHost.dialectOfHost(context));
    }

    public String[] @NotNull [] getAllKnownProperties() {
        return this.myToplevelCompletionProperties;
    }

    @Nullable
    public String getPropertyDescription(@Nullable String name) {
        Property property = (Property)ObjectUtils.coalesce((Object)JSRegexpHost.findProperty(this.myGeneralCategoryProperties, name), (Object)JSRegexpHost.findProperty(this.myBinaryProperties, name));
        return property != null ? property.description : null;
    }

    public String[] @NotNull [] getKnownCharacterClasses() {
        return this.myPropertiesProvider.getKnownCharacterClasses();
    }

    private static boolean isUnicodeRegexpLanguage(@NotNull PsiElement element) {
        if (element == null) {
            JSRegexpHost.$$$reportNull$$$0(11);
        }
        return EcmaScriptUnicodeRegexpLanguage.INSTANCE.equals(element.getContainingFile().getLanguage());
    }

    @Nullable
    private static DialectOptionHolder dialectOfHost(@NotNull PsiElement element) {
        if (element == null) {
            JSRegexpHost.$$$reportNull$$$0(12);
        }
        return DialectDetector.dialectOfElement(FileContextUtil.getFileContext((PsiFile)element.getContainingFile()));
    }

    private static boolean isValidUnicodeScript(@NotNull String value) {
        if (value == null) {
            JSRegexpHost.$$$reportNull$$$0(13);
        }
        if (!JSRegexpHost.isStrictlyCapitalizedWords(value)) {
            return false;
        }
        try {
            return Character.UnicodeScript.forName(value) != null;
        }
        catch (IllegalArgumentException ignore) {
            return false;
        }
    }

    private static boolean isStrictlyCapitalizedWords(@NotNull String value) {
        if (value == null) {
            JSRegexpHost.$$$reportNull$$$0(14);
        }
        char[] array = value.toCharArray();
        boolean isWordStart = true;
        for (char c : array) {
            if (!Character.isLetter(c)) {
                isWordStart = true;
                continue;
            }
            if (Character.isUpperCase(c) != isWordStart) {
                return false;
            }
            isWordStart = false;
        }
        return true;
    }

    private static boolean isGeneralCategory(@NotNull String propertyName) {
        if (propertyName == null) {
            JSRegexpHost.$$$reportNull$$$0(15);
        }
        return StringUtil.equals((CharSequence)propertyName, (CharSequence)"General_Category") || StringUtil.equals((CharSequence)propertyName, (CharSequence)"gc");
    }

    private static boolean isScriptPropertyName(@NotNull String propertyName) {
        if (propertyName == null) {
            JSRegexpHost.$$$reportNull$$$0(16);
        }
        return StringUtil.equals((CharSequence)"Script", (CharSequence)propertyName) || StringUtil.equals((CharSequence)"sc", (CharSequence)propertyName) || StringUtil.equals((CharSequence)"Script_Extensions", (CharSequence)propertyName) || StringUtil.equals((CharSequence)"scx", (CharSequence)propertyName);
    }

    /*
     * Exception decompiling
     */
    private static String[] @NotNull [] toCompletionItems(Property[] properties) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriter(StaticFunctionInvokation.java:90)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static Property findProperty(Property[] properties2, @Nullable String name) {
        if (name == null) {
            return null;
        }
        for (Property property : properties2) {
            if (StringUtil.equals((CharSequence)property.name, (CharSequence)name)) {
                return property;
            }
            for (String alias : property.aliases) {
                if (!StringUtil.equals((CharSequence)alias, (CharSequence)name)) continue;
                return property;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/regexp/JSRegexpHost";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookbehindGroup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: 
            case 9: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 8: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/regexp/JSRegexpHost";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedNamedGroupTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidGroupName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportsLookbehind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isValidCategory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isValidPropertyValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllPropertyValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsPropertySyntax";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnicodeRegexpLanguage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "dialectOfHost";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidUnicodeScript";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isStrictlyCapitalizedWords";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGeneralCategory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isScriptPropertyName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Property {
        public final String name;
        public final String description;
        public final String[] aliases;

        public Property(@NotNull String name, @Nullable String description2, String ... aliases) {
            if (name == null) {
                Property.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.description = description2;
            this.aliases = aliases;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/regexp/JSRegexpHost$Property", "<init>"));
        }
    }
}

