/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.surroundWith.JSStatementSurrounder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;

public class JSWithDoWhileSurrounder
extends JSStatementSurrounder {
    public String getTemplateDescription() {
        return JavaScriptBundle.message("javascript.surround.with.do.while", new Object[0]);
    }

    @Override
    protected String getStatementTemplate(Project project, PsiElement context) {
        return "do { } while (true);";
    }

    @Override
    protected ASTNode getInsertBeforeNode(ASTNode statementNode) {
        JSDoWhileStatement stmt = (JSDoWhileStatement)statementNode.getPsi();
        return stmt.getBody().getLastChild().getNode();
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSDoWhileStatement stmt = (JSDoWhileStatement)statementNode.getPsi();
        return stmt.getCondition().getTextRange();
    }
}

