/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.validation.HighlightSeverityHolder;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSReferenceProblemReporter
implements JSProblemReporter<Void> {
    @NotNull
    private final ProblemsHolder myHolder;

    public JSReferenceProblemReporter(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSReferenceProblemReporter.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    @Nullable
    public Void registerProblem(PsiElement referenceNameElement, @Nullable TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (message == null) {
            JSReferenceProblemReporter.$$$reportNull$$$0(1);
        }
        if (highlightType == null && referenceNameElement instanceof HighlightSeverityHolder) {
            highlightType = HighlightInfo.convertSeverityToProblemHighlight((HighlightSeverity)((HighlightSeverityHolder)referenceNameElement).getUnresolvedReferenceSeverity());
        }
        if (highlightType == null) {
            highlightType = ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
        }
        if (!this.myHolder.isOnTheFly() && highlightType == ProblemHighlightType.INFORMATION) {
            return null;
        }
        JSReferenceProblemReporter.registerFixes(referenceNameElement, fixes);
        this.myHolder.registerProblem(referenceNameElement, message, highlightType, null, fixes);
        return null;
    }

    public static void registerFixes(@NotNull PsiElement referenceNameElement, LocalQuickFix[] fixes) {
        if (referenceNameElement == null) {
            JSReferenceProblemReporter.$$$reportNull$$$0(2);
        }
        SmartPsiElementPointer pointer = null;
        for (LocalQuickFix l : fixes) {
            if (!(l instanceof FixAndIntentionAction)) continue;
            pointer = ((FixAndIntentionAction)l).registerElementRefForFix(referenceNameElement, pointer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceNameElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/JSReferenceProblemReporter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

