/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.psi.JSCaseClause;
import com.intellij.lang.javascript.psi.JSInheritedLanguagesHelper;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.util.ControlFlowUtils;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FallThroughInSwitchStatementJSInspection
extends JavaScriptInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("fall.through.in.switch.statement.error.string", new Object[0]);
        if (string == null) {
            FallThroughInSwitchStatementJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/FallThroughInSwitchStatementJSInspection", "buildErrorString"));
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private static final Pattern commentPattern = Pattern.compile("(?i)falls?\\s*-?thro?u");

        private Visitor() {
        }

        @Override
        public void visitJSSwitchStatement(JSSwitchStatement jsSwitchStatement) {
            JSCaseClause[] caseClauses = jsSwitchStatement.getCaseClauses();
            for (int i2 = 1; i2 < caseClauses.length; ++i2) {
                JSSourceElement lastStatementOfClause;
                JSCaseClause previousClause;
                Object[] statements;
                JSCaseClause clause = caseClauses[i2];
                if (Visitor.isCommented(clause) || (statements = (previousClause = caseClauses[i2 - 1]).getStatementListItems()).length == 0 || (lastStatementOfClause = (JSSourceElement)ArrayUtil.getLastElement((Object[])statements)) instanceof JSStatement && (JSInheritedLanguagesHelper.isCaseStatementInterrupted((JSStatement)lastStatementOfClause) || !ControlFlowUtils.statementMayCompleteNormally((JSStatement)lastStatementOfClause))) continue;
                this.registerError(clause.getFirstChild());
            }
        }

        private static boolean isCommented(JSCaseClause caseClause) {
            PsiElement element = PsiTreeUtil.skipWhitespacesBackward((PsiElement)caseClause);
            if (!(element instanceof PsiComment)) {
                return false;
            }
            String commentText = element.getText();
            return commentPattern.matcher(commentText).find();
        }
    }
}

