/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.style;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.JavaScriptInspection;
import org.jetbrains.annotations.NotNull;

public class ChainedEqualityJSInspection
extends JavaScriptInspection {
    @Override
    @NotNull
    @InspectionMessage
    public String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("chained.equality.error.string", new Object[0]);
        if (string == null) {
            ChainedEqualityJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ChainedEqualityVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/style/ChainedEqualityJSInspection", "buildErrorString"));
    }

    private static class ChainedEqualityVisitor
    extends BaseInspectionVisitor {
        private ChainedEqualityVisitor() {
        }

        @Override
        public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
            if (expression == null) {
                ChainedEqualityVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSBinaryExpression(expression);
            if (expression.getROperand() == null) {
                return;
            }
            if (!ChainedEqualityVisitor.isEqualityComparison(expression)) {
                return;
            }
            JSExpression lhs = expression.getLOperand();
            if (!(lhs instanceof JSBinaryExpression)) {
                return;
            }
            if (!ChainedEqualityVisitor.isEqualityComparison((JSBinaryExpression)lhs)) {
                return;
            }
            this.registerError((PsiElement)expression);
        }

        private static boolean isEqualityComparison(@NotNull JSBinaryExpression expression) {
            IElementType tokenType;
            if (expression == null) {
                ChainedEqualityVisitor.$$$reportNull$$$0(1);
            }
            return JSTokenTypes.EQEQ.equals(tokenType = expression.getOperationSign()) || JSTokenTypes.NE.equals(tokenType);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "expression";
            objectArray2[1] = "com/sixrr/inspectjs/style/ChainedEqualityJSInspection$ChainedEqualityVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSBinaryExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEqualityComparison";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

