/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ResultsProducer;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.StandardResultsProcessors;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import kotlin.Unit;
import org.jetbrains.annotations.NotNull;

public abstract class RawPlanData {
    public abstract void load(@NotNull DatabaseConnectionCore var1, @NotNull String var2, boolean var3);

    public abstract void load(@NotNull String var1);

    public abstract String dump();

    protected static StateSaver setAutoCommit(final boolean autoCommit) {
        return new StateSaver(){
            private Boolean myAutoCommit = null;

            @Override
            public void save(DatabaseConnectionCore conn) throws PlanRetrievalException {
                try {
                    this.myAutoCommit = conn.getAutoCommit();
                    conn.setAutoCommit(autoCommit);
                }
                catch (SQLException e2) {
                    throw new PlanRetrievalException("Failed to set auto commit", (Throwable)e2);
                }
            }

            @Override
            public void restore(DatabaseConnectionCore conn) {
                try {
                    if (this.myAutoCommit != null) {
                        conn.setAutoCommit(this.myAutoCommit.booleanValue());
                    }
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
    }

    protected static void useStatementWithPreserved(final DatabaseConnectionCore conn, final ResourceUser<? super ReusableSmartStatement<String>> user, StateSaver ... savers) throws PlanRetrievalException {
        RawPlanData.withPreserved(conn, (ResourceUser<? super DatabaseConnectionCore>)new ResourceUser<DatabaseConnectionCore>(){

            @Override
            public void use(DatabaseConnectionCore resource) throws PlanRetrievalException, SQLException {
                try (ReusableSmartStatement statement = SmartStatementFactoryService.getInstance().poweredBy(conn).simple().reuse();){
                    user.use(statement);
                }
            }
        }, savers);
    }

    @NotNull
    protected static ResultsProducer.VoidReadyProcessor<Unit> processing(@NotNull ThrowableConsumer<? super RemoteResultSet, ? extends Exception> consumer) {
        if (consumer == null) {
            RawPlanData.$$$reportNull$$$0(0);
        }
        ResultsProducer.VoidReadyProcessor voidReadyProcessor = StandardResultsProcessors.results(rs -> {
            try {
                consumer.consume(rs);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new PlanRetrievalException("Failed to process plan query results", (Throwable)e3);
            }
        }, () -> RawPlanData.failWithEmptyResultSetError());
        if (voidReadyProcessor == null) {
            RawPlanData.$$$reportNull$$$0(1);
        }
        return voidReadyProcessor;
    }

    protected static void failWithEmptyResultSetError() {
        throw new PlanRetrievalException("No data returned for plan query");
    }

    protected static void withPreserved(DatabaseConnectionCore conn, ResourceUser<? super DatabaseConnectionCore> user, StateSaver ... savers) throws PlanRetrievalException {
        int preserved = 0;
        for (StateSaver saver : savers) {
            ++preserved;
            saver.save(conn);
        }
        try {
            user.use((DatabaseConnectionCore)conn);
        }
        catch (SQLException ignore) {
            throw new ProcessCanceledException();
        }
        finally {
            for (int i2 = preserved - 1; i2 >= 0; --i2) {
                try {
                    savers[i2].restore(conn);
                    continue;
                }
                catch (Exception e2) {
                    AbstractPlanModelBuilder.LOG.warn((Throwable)e2);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/base/plan/RawPlanData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processing";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processing";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface StateSaver {
        public void save(DatabaseConnectionCore var1) throws PlanRetrievalException;

        public void restore(DatabaseConnectionCore var1);
    }

    protected static interface ResourceUser<T> {
        public void use(T var1) throws PlanRetrievalException, SQLException;
    }
}

